/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.registries;

import com.google.common.collect.ImmutableMap;
import de.dafuqs.arrowhead.api.CrossbowShootingCallback;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.api.item.PrioritizedBlockInteraction;
import de.dafuqs.spectrum.api.item.PrioritizedEntityInteraction;
import de.dafuqs.spectrum.blocks.chests.CompactingChestBlockEntity;
import de.dafuqs.spectrum.blocks.idols.FirestarterIdolBlock;
import de.dafuqs.spectrum.blocks.pastel_network.Pastel;
import de.dafuqs.spectrum.cca.EverpromiseRibbonComponent;
import de.dafuqs.spectrum.cca.HardcoreDeathComponent;
import de.dafuqs.spectrum.cca.MiscPlayerDataComponent;
import de.dafuqs.spectrum.entity.spawners.ShootingStarSpawner;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.helpers.TimeHelper;
import de.dafuqs.spectrum.items.magic_items.ExchangeStaffItem;
import de.dafuqs.spectrum.items.tools.GlassCrestCrossbowItem;
import de.dafuqs.spectrum.items.tools.TuningStampItem;
import de.dafuqs.spectrum.items.trinkets.AshenCircletItem;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import de.dafuqs.spectrum.items.trinkets.WhispyCircletItem;
import de.dafuqs.spectrum.mixin.accessors.RecipeManagerAccessor;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.recipe.GatedSpectrumRecipe;
import de.dafuqs.spectrum.recipe.enchantment_upgrade.EnchantmentUpgradeRecipeSerializer;
import de.dafuqs.spectrum.registries.SpectrumAttributeTags;
import de.dafuqs.spectrum.registries.SpectrumDimensions;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import de.dafuqs.spectrum.registries.client.SpectrumColorProviders;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityCombatEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.item.v1.ModifyItemAttributeModifiersCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1269;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1860;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3324;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3545;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_5134;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import net.minecraft.server.MinecraftServer;

public class SpectrumEventListeners {
    public static final HashMap<class_3611, Integer> fluidLuminance = new HashMap();

    public static void register() {
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            if (!world.field_9236 && !player.method_7325()) {
                class_1799 mainHandStack = player.method_6047();
                class_1792 patt0$temp = mainHandStack.method_7909();
                if (patt0$temp instanceof ExchangeStaffItem) {
                    Optional<class_2248> storedBlock;
                    ExchangeStaffItem exchangeStaffItem = (ExchangeStaffItem)patt0$temp;
                    class_2680 targetBlockState = world.method_8320(pos);
                    if (exchangeStaffItem.canInteractWith(targetBlockState, (class_1922)world, pos, player) && (storedBlock = ExchangeStaffItem.getStoredBlock(player.method_6047())).isPresent() && storedBlock.get() != targetBlockState.method_26204() && storedBlock.get().method_8389() != class_1802.field_8162 && ExchangeStaffItem.exchange(world, pos, player, storedBlock.get(), player.method_6047(), true, direction)) {
                        return class_1269.field_5812;
                    }
                    world.method_8396(null, player.method_24515(), class_3417.field_14701, class_3419.field_15248, 1.0f, 1.0f);
                    return class_1269.field_5814;
                }
                class_1792 patt1$temp = mainHandStack.method_7909();
                if (patt1$temp instanceof TuningStampItem) {
                    TuningStampItem tuningStampItem = (TuningStampItem)patt1$temp;
                    if (mainHandStack.method_7948().method_10545("spectrum:stamping_data")) {
                        tuningStampItem.clearData(Optional.of(player), mainHandStack);
                    }
                }
            }
            return class_1269.field_5811;
        });
        CommonLifecycleEvents.TAGS_LOADED.register((registries, client) -> {
            if (client) {
                SpectrumColorProviders.resetToggleableProviders();
            }
        });
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, blockEntity) -> {
            if (player instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)player;
                SpectrumAdvancementCriteria.BLOCK_BROKEN.trigger(serverPlayerEntity, state);
            }
        });
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            class_1799 handStack = player.method_5998(hand);
            if (handStack.method_7909() instanceof PrioritizedEntityInteraction && entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                return handStack.method_7920(player, livingEntity, hand);
            }
            return class_1269.field_5811;
        });
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_1799 handStack = player.method_5998(hand);
            if (handStack.method_7909() instanceof PrioritizedBlockInteraction) {
                return handStack.method_7981(new class_1838(player, hand, hitResult));
            }
            return class_1269.field_5811;
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            try {
                Pastel.getServerInstance().tick();
            }
            catch (Exception e) {
                SpectrumCommon.logError("Error in the Pastel Network transmission loop.");
                e.printStackTrace();
            }
            class_3324 playerManager = server.method_3760();
            for (class_3222 player : playerManager.method_14571()) {
                class_1937 world = player.method_37908();
                if (player.method_7337() || player.method_7325() || world.method_27983() != SpectrumDimensions.DIMENSION_KEY || !(player.method_23318() > (double)world.method_31600())) continue;
                player.method_5643(player.method_48923().method_48829(), 10.0f);
                if (!player.method_29504()) continue;
                Support.grantAdvancementCriterion(player, "lategame/get_killed_while_out_of_deeper_down_bounds", "get_rekt");
            }
        });
        ServerTickEvents.START_WORLD_TICK.register(world -> {
            if (world.method_8510() % 100L == 0L && TimeHelper.getTimeOfDay((class_1937)world).isNight() && SpectrumCommon.CONFIG.ShootingStarWorlds.contains(world.method_27983().method_29177().toString())) {
                ShootingStarSpawner.INSTANCE.method_6445(world, true, true);
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            SpectrumCommon.logInfo("Querying fluid luminance...");
            Iterator it = class_7923.field_41175.method_10220().iterator();
            while (it.hasNext()) {
                class_2248 block = (class_2248)it.next();
                if (!(block instanceof class_2404)) continue;
                class_2404 fluidBlock = (class_2404)block;
                fluidLuminance.put(fluidBlock.method_9545(fluidBlock.method_9564()).method_15772(), fluidBlock.method_9564().method_26213());
            }
            SpectrumCommon.logInfo("Injecting dynamic recipes into recipe manager...");
            FirestarterIdolBlock.addBlockSmeltingRecipes(server);
            SpectrumEventListeners.injectEnchantmentUpgradeRecipes(server);
        });
        EntitySleepEvents.STOP_SLEEPING.register((entity, sleepingPos) -> {
            class_3222 serverPlayerEntity;
            if (entity instanceof class_3222 && (serverPlayerEntity = (class_3222)entity).method_7297() == 100 && SpectrumTrinketItem.hasEquipped(entity, SpectrumItems.WHISPY_CIRCLET)) {
                entity.method_6033(entity.method_6063());
                WhispyCircletItem.removeNegativeStatusEffects(entity);
            }
        });
        ServerEntityCombatEvents.AFTER_KILLED_OTHER_ENTITY.register((world, entity, killedEntity) -> {
            class_3222 serverPlayerEntity;
            if (entity instanceof class_3222 && SpectrumTrinketItem.hasEquipped((class_1309)(serverPlayerEntity = (class_3222)entity), SpectrumItems.JEOPARDANT)) {
                SpectrumAdvancementCriteria.JEOPARDANT_KILL.trigger(serverPlayerEntity, (class_1297)killedEntity);
            }
        });
        ServerLivingEntityEvents.MOB_CONVERSION.register((previous, converted, keepEquipment) -> {
            if (EverpromiseRibbonComponent.hasRibbon((class_1309)previous)) {
                EverpromiseRibbonComponent.attachRibbon((class_1309)converted);
            }
        });
        ServerEntityEvents.EQUIPMENT_CHANGE.register((livingEntity, equipmentSlot, previousStack, currentStack) -> {
            class_6862<class_1320> effectType;
            int oldInexorable = class_1890.method_8225((class_1887)SpectrumEnchantments.INEXORABLE, (class_1799)previousStack);
            int newInexorable = class_1890.method_8225((class_1887)SpectrumEnchantments.INEXORABLE, (class_1799)currentStack);
            class_6862<class_1320> class_68622 = effectType = equipmentSlot == class_1304.field_6174 ? SpectrumAttributeTags.INEXORABLE_ARMOR_EFFECTIVE : SpectrumAttributeTags.INEXORABLE_HANDHELD_EFFECTIVE;
            if (oldInexorable > 0 && newInexorable <= 0) {
                livingEntity.method_6026().stream().filter(instance -> {
                    class_1291 statusEffect = instance.method_5579();
                    Set attributes = statusEffect.method_5565().keySet();
                    return attributes.stream().anyMatch(attribute -> {
                        Optional attributeRegistryOptional = class_7923.field_41190.method_40266(effectType);
                        return attributeRegistryOptional.map(registryEntries -> registryEntries.method_40239().map(class_6880::comp_349).anyMatch(entityAttribute -> {
                            if (!statusEffect.method_5565().containsKey(entityAttribute)) {
                                return false;
                            }
                            double value = ((class_1322)statusEffect.method_5565().get(entityAttribute)).method_6186();
                            return value < 0.0;
                        })).orElse(false);
                    });
                }).forEach(instance -> instance.method_5579().method_5555(livingEntity, livingEntity.method_6127(), instance.method_5578()));
            }
        });
        ModifyItemAttributeModifiersCallback.EVENT.register((stack, slot, attributeModifiers) -> {
            int tightGripLevel;
            if (slot == class_1304.field_6173 && (tightGripLevel = class_1890.method_8225((class_1887)SpectrumEnchantments.TIGHT_GRIP, (class_1799)stack)) > 0) {
                float attackSpeedBonus = (float)tightGripLevel * SpectrumCommon.CONFIG.TightGripAttackSpeedBonusPercentPerLevel;
                class_1322 mod = new class_1322(UUID.fromString("b09d9b57-eefb-4499-9150-5d8d3e644a40"), "Tight Grip modifier", (double)attackSpeedBonus, class_1322.class_1323.field_6331);
                attributeModifiers.put((Object)class_5134.field_23723, (Object)mod);
            }
        });
        EntitySleepEvents.ALLOW_BED.register((entity, sleepingPos, state, vanillaResult) -> {
            class_1657 player;
            if (entity instanceof class_1657 && MiscPlayerDataComponent.get(player = (class_1657)entity).isSleeping()) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        EntitySleepEvents.MODIFY_SLEEPING_DIRECTION.register((entity, sleepingPos, sleepingDirection) -> {
            class_1657 player;
            if (entity instanceof class_1657 && MiscPlayerDataComponent.get(player = (class_1657)entity).isSleeping()) {
                return player.method_5735();
            }
            return sleepingDirection;
        });
        EntitySleepEvents.ALLOW_NEARBY_MONSTERS.register((player, sleepingPos, vanillaResult) -> {
            if (MiscPlayerDataComponent.get(player).isSleeping() || player.method_6059(SpectrumStatusEffects.SOMNOLENCE)) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        EntitySleepEvents.ALLOW_SLEEP_TIME.register((player, sleepingPos, vanillaResult) -> {
            if (player.method_6059(SpectrumStatusEffects.SOMNOLENCE)) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        CrossbowShootingCallback.register((world, shooter, hand, crossbow, projectile, projectileEntity) -> {
            if (crossbow.method_7909() instanceof GlassCrestCrossbowItem && GlassCrestCrossbowItem.isOvercharged(crossbow) && !world.field_9236) {
                class_243 particleVelocity = projectileEntity.method_18798().method_1021(0.05);
                if (GlassCrestCrossbowItem.getOvercharge(crossbow) > 0.99f) {
                    SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity((class_3218)world, projectileEntity.method_19538(), (class_2394)class_2398.field_29645, 5, class_243.field_1353, particleVelocity);
                    SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity((class_3218)world, projectileEntity.method_19538(), (class_2394)class_2398.field_29643, 5, class_243.field_1353, particleVelocity);
                    SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity((class_3218)world, projectileEntity.method_19538(), (class_2394)class_2398.field_29642, 5, class_243.field_1353, particleVelocity);
                    SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity((class_3218)world, projectileEntity.method_19538(), (class_2394)class_2398.field_28479, 5, class_243.field_1353, particleVelocity);
                    if (shooter instanceof class_3222) {
                        class_3222 serverPlayerEntity = (class_3222)shooter;
                        Support.grantAdvancementCriterion(serverPlayerEntity, SpectrumCommon.locate("lategame/shoot_fully_overcharged_crossbow"), "shot_fully_overcharged_crossbow");
                    }
                    if (projectileEntity instanceof class_1665) {
                        class_1665 persistentProjectileEntity = (class_1665)projectileEntity;
                        persistentProjectileEntity.method_7438(persistentProjectileEntity.method_7448() * 1.5);
                    }
                }
                SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity((class_3218)world, projectileEntity.method_19538(), (class_2394)class_2398.field_11248, 10, class_243.field_1353, particleVelocity);
                GlassCrestCrossbowItem.unOvercharge(crossbow);
            }
        });
        ServerLivingEntityEvents.ALLOW_DEATH.register((entity, damageSource, damageAmount) -> {
            if (damageSource.method_48789(class_8103.field_42242)) {
                return true;
            }
            Optional optionalTrinketComponent = TrinketsApi.getTrinketComponent((class_1309)entity);
            if (optionalTrinketComponent.isPresent()) {
                List totems = ((TrinketComponent)optionalTrinketComponent.get()).getEquipped(SpectrumItems.TOTEM_PENDANT);
                for (class_3545 pair : totems) {
                    class_1799 totemStack = (class_1799)pair.method_15441();
                    if (totemStack.method_7947() <= 0) continue;
                    if (entity instanceof class_3222) {
                        class_3222 serverPlayerEntity = (class_3222)entity;
                        serverPlayerEntity.method_7259(class_3468.field_15372.method_14956((Object)class_1802.field_8288));
                        class_174.field_1204.method_9165(serverPlayerEntity, totemStack);
                    }
                    totemStack.method_7934(1);
                    entity.method_6033(1.0f);
                    entity.method_6012();
                    entity.method_6092(new class_1293(class_1294.field_5924, 900, 1));
                    entity.method_6092(new class_1293(class_1294.field_5898, 100, 1));
                    entity.method_6092(new class_1293(class_1294.field_5918, 800, 0));
                    entity.method_37908().method_8421((class_1297)entity, (byte)35);
                    return false;
                }
            }
            return true;
        });
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                if (entity.method_37908().method_8401().method_152() || HardcoreDeathComponent.isInHardcore(player)) {
                    HardcoreDeathComponent.addHardcoreDeath(player.method_7334());
                }
            }
        });
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> {
            if (source.method_49708(class_8111.field_42338)) {
                Optional<class_1799> ashenCircletStack = SpectrumTrinketItem.getFirstEquipped(entity, SpectrumItems.ASHEN_CIRCLET);
                if (ashenCircletStack.isPresent() && AshenCircletItem.getCooldownTicks(ashenCircletStack.get(), entity.method_37908()) == 0L) {
                    AshenCircletItem.grantFireResistance(ashenCircletStack.get(), entity);
                    return false;
                }
            } else if (source.method_48789(class_8103.field_42246) && SpectrumTrinketItem.hasEquipped(entity, SpectrumItems.ASHEN_CIRCLET)) {
                return false;
            }
            return true;
        });
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){
            private final class_2960 id = SpectrumCommon.locate("cache_clearer");

            public void method_14491(class_3300 manager) {
                CompactingChestBlockEntity.clearCache();
                SpectrumCommon.CACHED_ITEM_TAG_MAP.clear();
                if (SpectrumCommon.minecraftServer != null) {
                    SpectrumEventListeners.injectEnchantmentUpgradeRecipes(SpectrumCommon.minecraftServer);
                    FirestarterIdolBlock.addBlockSmeltingRecipes(SpectrumCommon.minecraftServer);
                }
            }

            public class_2960 getFabricId() {
                return this.id;
            }
        });
    }

    public static void injectEnchantmentUpgradeRecipes(MinecraftServer minecraftServer) {
        if (!EnchantmentUpgradeRecipeSerializer.enchantmentUpgradeRecipesToInject.isEmpty()) {
            ImmutableMap collectedRecipes = (ImmutableMap)EnchantmentUpgradeRecipeSerializer.enchantmentUpgradeRecipesToInject.stream().collect(ImmutableMap.toImmutableMap(GatedSpectrumRecipe::method_8114, enchantmentUpgradeRecipe -> enchantmentUpgradeRecipe));
            Map<class_3956<?>, Map<class_2960, class_1860<?>>> recipes = ((RecipeManagerAccessor)minecraftServer.method_3772()).getRecipes();
            ArrayList<Object> newList = new ArrayList<Object>();
            for (Map<class_2960, class_1860<?>> r : recipes.values()) {
                newList.addAll(r.values());
            }
            for (class_1860 recipe : collectedRecipes.values()) {
                if (newList.contains(recipe)) continue;
                newList.add(recipe);
            }
            minecraftServer.method_3772().method_20702(newList);
        }
    }

    public static int getFluidLuminance(class_3611 fluid) {
        return fluidLuminance.getOrDefault(fluid, 0);
    }
}

