/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.sound;

import de.dafuqs.spectrum.entity.entity.MagicProjectileEntity;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1102;
import net.minecraft.class_1113;
import net.minecraft.class_1117;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;

@Environment(value=EnvType.CLIENT)
public class MagicProjectileSoundInstance
extends class_1102
implements class_1117 {
    private final class_5321<class_1937> worldKey;
    private final MagicProjectileEntity projectile;
    private final int maxDurationTicks = 280;
    private int ticksPlayed = 0;
    private boolean done;
    private boolean playedExplosion;

    protected MagicProjectileSoundInstance(class_5321<class_1937> worldKey, MagicProjectileEntity projectile) {
        super(SpectrumSoundEvents.INK_PROJECTILE_LAUNCH, class_3419.field_15254, class_1113.method_43221());
        this.worldKey = worldKey;
        this.projectile = projectile;
        this.field_5440 = class_1113.class_1114.field_5478;
        this.field_5439 = this.projectile.method_23317();
        this.field_5450 = this.projectile.method_23318();
        this.field_5449 = this.projectile.method_23321();
        this.field_5446 = false;
        this.field_5451 = 0;
        this.field_5442 = 1.0f;
    }

    @Environment(value=EnvType.CLIENT)
    public static void startSoundInstance(MagicProjectileEntity projectile) {
        class_310 client = class_310.method_1551();
        MagicProjectileSoundInstance newInstance = new MagicProjectileSoundInstance((class_5321<class_1937>)client.field_1687.method_27983(), projectile);
        class_310.method_1551().method_1483().method_4873((class_1113)newInstance);
    }

    public boolean method_4793() {
        return this.done;
    }

    public boolean method_4785() {
        return true;
    }

    public void method_16896() {
        class_310 client = class_310.method_1551();
        ++this.ticksPlayed;
        this.field_5439 = this.projectile.method_23317();
        this.field_5450 = this.projectile.method_23318();
        this.field_5449 = this.projectile.method_23321();
        this.field_5442 = Math.max(0.0f, 0.7f - Math.max(0.0f, (float)this.projectile.method_24515().method_19455((class_2382)client.field_1724.method_24515()) / 128.0f - 0.2f));
        if (this.ticksPlayed > 280 || !Objects.equals(this.worldKey, class_310.method_1551().field_1687.method_27983()) || this.projectile.method_31481()) {
            this.setDone();
        }
    }

    protected final void setDone() {
        class_310 client = class_310.method_1551();
        this.ticksPlayed = this.maxDurationTicks;
        this.done = true;
        this.field_5446 = false;
        if (this.projectile.method_31481() && !this.playedExplosion) {
            client.field_1724.method_17356(class_3417.field_15152, class_3419.field_15254, Math.max(0.1f, this.field_5442 / 4.0f), 1.1f + client.field_1687.field_9229.method_43057() * 0.2f);
            this.projectile.spawnImpactParticles();
            this.playedExplosion = true;
        }
    }
}

