/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.status_effects;

import de.dafuqs.spectrum.cca.MiscPlayerDataComponent;
import de.dafuqs.spectrum.registries.SpectrumEntityAttributes;
import de.dafuqs.spectrum.registries.SpectrumEntityTypeTags;
import de.dafuqs.spectrum.registries.SpectrumStatusEffectTags;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import de.dafuqs.spectrum.status_effects.SpectrumStatusEffect;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_4081;
import org.jetbrains.annotations.Nullable;

public class SleepStatusEffect
extends SpectrumStatusEffect {
    private final boolean scales;

    public SleepStatusEffect(class_4081 category, int color, boolean scales) {
        super(category, color);
        this.scales = scales;
    }

    public static float getSleepResistance(@Nullable class_1293 sleepEffect, class_1309 entity) {
        class_1657 player;
        class_1299 type = entity.method_5864();
        if (sleepEffect == null || type.method_20210(SpectrumEntityTypeTags.SOULLESS)) {
            return Float.MAX_VALUE;
        }
        float scaling = entity instanceof class_1657 && (player = (class_1657)entity).method_37908().method_8608() ? (float)MiscPlayerDataComponent.get(player).getLastSyncedSleepPotency() : (float)entity.method_26825(SpectrumEntityAttributes.MENTAL_PRESENCE);
        if (type.method_20210(SpectrumEntityTypeTags.SLEEP_WEAK)) {
            scaling /= 3.0f;
        } else if (type.method_20210(SpectrumEntityTypeTags.SLEEP_RESISTANT)) {
            scaling *= 2.0f;
        } else if (SleepStatusEffect.isImmuneish(entity)) {
            scaling *= 10.0f;
        }
        return scaling;
    }

    public static boolean isImmuneish(class_1309 entity) {
        if (entity.method_6059(SpectrumStatusEffects.FRENZY)) {
            return true;
        }
        class_1299 type = entity.method_5864();
        if (type.method_20210(SpectrumEntityTypeTags.SLEEP_WEAK)) {
            return false;
        }
        return type.method_20210(SpectrumEntityTypeTags.SLEEP_IMMUNEISH);
    }

    public static float getGeneralSleepResistanceIfEntityHasSoporificEffect(class_1309 entity) {
        if (SpectrumStatusEffectTags.hasEffectWithTag(entity, SpectrumStatusEffectTags.SOPORIFIC)) {
            return SleepStatusEffect.getSleepResistance(entity.method_6112(SleepStatusEffect.getStrongestSleepEffect(entity)), entity);
        }
        return -1.0f;
    }

    public static float getSleepScaling(class_1309 entity) {
        float potency = SleepStatusEffect.getGeneralSleepResistanceIfEntityHasSoporificEffect(entity);
        if (potency == -1.0f || potency >= 1.0f) {
            return -1.0f;
        }
        return 2.0f * (float)Math.pow(1.0f - potency, 2.0);
    }

    @Nullable
    public static class_1291 getStrongestSleepEffect(class_1309 entity) {
        if (entity.method_6059(SpectrumStatusEffects.FATAL_SLUMBER)) {
            return SpectrumStatusEffects.FATAL_SLUMBER;
        }
        if (entity.method_6059(SpectrumStatusEffects.ETERNAL_SLUMBER)) {
            return SpectrumStatusEffects.ETERNAL_SLUMBER;
        }
        if (entity.method_6059(SpectrumStatusEffects.SOMNOLENCE)) {
            return SpectrumStatusEffects.SOMNOLENCE;
        }
        return null;
    }

    public double method_5563(int amplifier, class_1322 modifier) {
        if (this.scales) {
            return super.method_5563(amplifier, modifier);
        }
        return modifier.method_6186();
    }
}

