/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.worldgen.features;

import com.mojang.serialization.Codec;
import de.dafuqs.spectrum.blocks.jade_vines.JadeiteFlowerBlock;
import de.dafuqs.spectrum.blocks.jade_vines.JadeiteLotusStemBlock;
import de.dafuqs.spectrum.registries.SpectrumBlockTags;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.worldgen.features.JadeiteLotusFeatureConfig;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class JadeiteLotusFeature
extends class_3031<JadeiteLotusFeatureConfig> {
    public JadeiteLotusFeature(Codec<JadeiteLotusFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<JadeiteLotusFeatureConfig> context) {
        class_5281 world = context.method_33652();
        class_2338 origin = context.method_33655();
        class_5819 random = context.method_33654();
        class_2794 chunkGen = context.method_33653();
        Boolean inverted = ((JadeiteLotusFeatureConfig)context.method_33656()).inverted();
        class_2680 floorState = world.method_8320(inverted != false ? origin.method_10074() : origin.method_10084());
        if (!floorState.method_26164(class_3481.field_29822) && !floorState.method_26164(SpectrumBlockTags.BASE_STONE_DEEPER_DOWN)) {
            return false;
        }
        int stemHeight = Math.round(class_3532.method_32855((class_5819)random, (float)8.0f, (float)10.0f) + 5.0f);
        class_2338.class_2339 mutablePos = origin.method_25503();
        for (int i = 0; i < stemHeight + 2; ++i) {
            if (inverted.booleanValue()) {
                mutablePos.method_10098(class_2350.field_11036);
                if (mutablePos.method_10264() <= chunkGen.method_12104() && JadeiteLotusFeature.isReplaceable((class_1936)world, (class_2338)mutablePos)) continue;
                stemHeight = i - 2 - random.method_43048(2);
                break;
            }
            mutablePos.method_10098(class_2350.field_11033);
            if (mutablePos.method_10264() >= chunkGen.method_33730() && JadeiteLotusFeature.isReplaceable((class_1936)world, (class_2338)mutablePos)) continue;
            stemHeight = i - 2 - random.method_43048(2);
            break;
        }
        if (stemHeight < 4) {
            return false;
        }
        this.generateStem((class_1936)world, origin, stemHeight, inverted);
        return true;
    }

    private static boolean isReplaceable(class_1936 world, class_2338 pos) {
        return world.method_8320(pos).method_45474();
    }

    private void generateStem(class_1936 world, class_2338 origin, int stemHeight, boolean inverted) {
        class_2338.class_2339 stemPointer = origin.method_25503();
        boolean topStem = false;
        for (int height = 0; height < stemHeight; ++height) {
            if (height == 0) {
                this.method_13153((class_1945)world, (class_2338)stemPointer, (class_2680)SpectrumBlocks.JADEITE_LOTUS_STEM.method_9564().method_11657((class_2769)JadeiteLotusStemBlock.INVERTED, (Comparable)Boolean.valueOf(inverted)));
                topStem = true;
            } else if (height == stemHeight - 1) {
                this.method_13153((class_1945)world, (class_2338)stemPointer, (class_2680)SpectrumBlocks.JADEITE_LOTUS_FLOWER.method_9564().method_11657((class_2769)JadeiteFlowerBlock.field_10927, (Comparable)(inverted ? class_2350.field_11036 : class_2350.field_11033)));
            } else {
                this.method_13153((class_1945)world, (class_2338)stemPointer, JadeiteLotusStemBlock.getStemVariant(topStem, inverted));
                topStem = !topStem;
            }
            stemPointer.method_10100(0, inverted ? 1 : -1, 0);
        }
    }
}

