/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.worldgen.features;

import com.mojang.serialization.Codec;
import de.dafuqs.spectrum.blocks.jade_vines.NephriteBlossomLeavesBlock;
import de.dafuqs.spectrum.blocks.jade_vines.NephriteBlossomStemBlock;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.worldgen.features.NephriteBlossomFeatureConfig;
import java.util.List;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class NephriteBlossomFeature
extends class_3031<NephriteBlossomFeatureConfig> {
    private static final List<class_2350> VALID_DIRS = List.of(class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039);

    public NephriteBlossomFeature(Codec<NephriteBlossomFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<NephriteBlossomFeatureConfig> context) {
        class_5281 world = context.method_33652();
        class_2338 origin = context.method_33655();
        class_5819 random = context.method_33654();
        class_2794 chunkGen = context.method_33653();
        class_2680 floor = world.method_8320(origin.method_10074());
        Boolean flowering = ((NephriteBlossomFeatureConfig)context.method_33656()).flowering();
        if (!floor.method_26164(class_3481.field_29822)) {
            return false;
        }
        int stemHeight = Math.round(class_3532.method_32855((class_5819)random, (float)2.0f, (float)1.0f) + 1.0f);
        if (stemHeight + origin.method_10264() > chunkGen.method_12104() || !NephriteBlossomFeature.isReplaceable((class_1936)world, origin, true)) {
            return false;
        }
        this.generateStem((class_1936)world, origin, stemHeight);
        this.genereateLeaves((class_1936)world, origin, random, stemHeight, flowering);
        return true;
    }

    private void generateStem(class_1936 world, class_2338 origin, int stemHeight) {
        class_2338.class_2339 stemPointer = origin.method_25503();
        boolean topStem = false;
        for (int height = 0; height < stemHeight; ++height) {
            if (height == 0) {
                this.method_13153((class_1945)world, (class_2338)stemPointer, SpectrumBlocks.NEPHRITE_BLOSSOM_STEM.method_9564());
                topStem = true;
            } else if (NephriteBlossomFeature.isReplaceable(world, (class_2338)stemPointer, true)) {
                this.method_13153((class_1945)world, (class_2338)stemPointer, NephriteBlossomStemBlock.getStemVariant(topStem));
                topStem = !topStem;
            }
            stemPointer.method_10100(0, 1, 0);
        }
    }

    private void genereateLeaves(class_1936 world, class_2338 origin, class_5819 random, int stemHeight, boolean flowering) {
        int leafHeight = Math.round(class_3532.method_32855((class_5819)random, (float)2.5f, (float)0.9f) + 1.85f);
        class_2338.class_2339 leafPointer = origin.method_25503().method_10100(0, stemHeight, 0);
        class_2350 leafDirection = VALID_DIRS.get(random.method_43048(4));
        for (int i = 0; i < leafHeight; ++i) {
            int leaf;
            for (leaf = 0; leaf < 4; ++leaf) {
                leafPointer.method_10098(leafDirection);
                NephriteBlossomFeature.setBlockStateWithoutUpdatingNeighbors(world, (class_2338)leafPointer, this.getLeafState(random, flowering));
                leafDirection = this.cycleDirections(leafDirection, 1);
            }
            if (i != 0 && i != leafHeight - 1) {
                leafDirection = leafDirection.method_10153();
                for (leaf = 0; leaf < 4; ++leaf) {
                    leafPointer.method_10098(leafDirection);
                    NephriteBlossomFeature.setBlockStateWithoutUpdatingNeighbors(world, (class_2338)leafPointer, this.getLeafState(random, flowering));
                    leafDirection = this.cycleDirections(leafDirection, 1);
                }
                leafDirection = leafDirection.method_10153();
            }
            leafPointer.method_10100(0, 1, 0);
            if (!(random.method_43056() ^ i % 3 == 0)) continue;
            leafDirection = this.cycleDirections(leafDirection, random.method_43048(3) - 1);
        }
    }

    private static void setBlockStateWithoutUpdatingNeighbors(class_1936 world, class_2338 pos, class_2680 state) {
        if (NephriteBlossomFeature.isReplaceable(world, pos, false)) {
            world.method_8652(pos, state, 19);
        }
    }

    private class_2680 getLeafState(class_5819 random, boolean allowFlowering) {
        class_2680 state = (class_2680)SpectrumBlocks.NEPHRITE_BLOSSOM_LEAVES.method_9564().method_11657((class_2769)NephriteBlossomLeavesBlock.field_11199, (Comparable)Integer.valueOf(1));
        if (!allowFlowering) {
            return state;
        }
        if (random.method_43056()) {
            return (class_2680)state.method_11657((class_2769)NephriteBlossomLeavesBlock.AGE, (Comparable)Integer.valueOf(1));
        }
        if (random.method_43056()) {
            return (class_2680)state.method_11657((class_2769)NephriteBlossomLeavesBlock.AGE, (Comparable)Integer.valueOf(2));
        }
        return state;
    }

    private class_2350 cycleDirections(class_2350 currentDir, int change) {
        return this.getDirectionFor(this.getDirectionOridinal(currentDir) + Math.abs(change));
    }

    private class_2350 getDirectionFor(int ordinal) {
        return VALID_DIRS.get(ordinal % 4);
    }

    private int getDirectionOridinal(class_2350 direction) {
        return VALID_DIRS.indexOf(direction);
    }

    private static boolean isReplaceable(class_1936 world, class_2338 pos, boolean replacePlants) {
        return world.method_16358(pos, state -> state.method_45474() || replacePlants);
    }
}

