/*
 * Decompiled with CFR 0.152.
 */
package elocindev.deathknights.item.weapon;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import elocindev.deathknights.api.DKAttributeAPI;
import elocindev.deathknights.api.types.RunebladeSize;
import elocindev.deathknights.api.types.RunebladeType;
import elocindev.deathknights.registry.ItemRegistry;
import java.util.UUID;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1832;
import net.minecraft.class_1856;
import net.minecraft.class_1935;

public class RuneaxeItem
extends class_1743 {
    private Multimap<class_1320, class_1322> mainHandAttributes;
    private Multimap<class_1320, class_1322> offHandAttributes;
    private RunebladeType type;
    private RunebladeSize size;
    private float spellPowerAmount;
    private boolean isAddition;

    public RuneaxeItem(RunebladeType type, RunebladeSize size, class_1832 material, int attackDamage, float attackSpeed, float attributeAmount, boolean isAddition) {
        this(type, size, material, attackDamage, attackSpeed, attributeAmount, isAddition, false);
    }

    public RuneaxeItem(RunebladeType type, RunebladeSize size, final class_1832 material, int attackDamage, float attackSpeed, float attributeAmount, boolean isAddition, final boolean isRubyorAeternium) {
        super(new class_1832(){

            public int method_8025() {
                return material.method_8025();
            }

            public float method_8027() {
                return material.method_8027();
            }

            public float method_8028() {
                if (isRubyorAeternium) {
                    return material.method_8028() - 0.5f;
                }
                return material.method_8028();
            }

            public int method_8026() {
                return material.method_8026();
            }

            public int method_8024() {
                return material.method_8024();
            }

            public class_1856 method_8023() {
                return class_1856.method_8091((class_1935[])new class_1935[]{ItemRegistry.RUNECARVED_STONE});
            }
        }, (float)attackDamage, attackSpeed, (class_1792.class_1793)new FabricItemSettings());
        this.type = type;
        this.size = size;
        this.spellPowerAmount = attributeAmount;
        this.isAddition = isAddition;
        ImmutableMultimap.Builder mh_modifiers = ImmutableMultimap.builder();
        ImmutableMultimap.Builder oh_modifiers = ImmutableMultimap.builder();
        this.buildMainHandAttributes((ImmutableMultimap.Builder<class_1320, class_1322>)mh_modifiers);
        this.buildOffHandAttributes((ImmutableMultimap.Builder<class_1320, class_1322>)oh_modifiers);
        this.mainHandAttributes = mh_modifiers.build();
        this.offHandAttributes = oh_modifiers.build();
    }

    public RunebladeType getType() {
        return this.type;
    }

    public boolean isTwoHanded() {
        return this.size == RunebladeSize.TWO_HANDED;
    }

    public boolean isOneHanded() {
        return this.size == RunebladeSize.ONE_HANDED;
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        switch (slot) {
            case field_6173: {
                return this.mainHandAttributes;
            }
            case field_6171: {
                return this.offHandAttributes;
            }
        }
        return super.method_7844(slot);
    }

    private void buildMainHandAttributes(ImmutableMultimap.Builder<class_1320, class_1322> modifiers) {
        modifiers.putAll(super.method_7844(class_1304.field_6173));
        class_1322.class_1323 operator = this.isAddition ? class_1322.class_1323.field_6328 : class_1322.class_1323.field_6330;
        DKAttributeAPI.buildMagicAttributes(modifiers, this.type, UUID.fromString("0484aa27-cc29-47ce-9ad9-ff7d88eb84e3"), operator, this.spellPowerAmount);
    }

    private void buildOffHandAttributes(ImmutableMultimap.Builder<class_1320, class_1322> modifiers) {
        if (this.size != RunebladeSize.ONE_HANDED) {
            return;
        }
        class_1322.class_1323 operator = this.isAddition ? class_1322.class_1323.field_6328 : class_1322.class_1323.field_6330;
        DKAttributeAPI.buildMagicAttributes(modifiers, this.type, UUID.fromString("a8082dfc-871c-4a75-80e3-4cc6ec2ffbb0"), operator, this.spellPowerAmount);
    }
}

