/*
 * Decompiled with CFR 0.152.
 */
package elocindev.deathknights.spells.unholy;

import elocindev.deathknights.config.Configs;
import elocindev.deathknights.config.entries.spells.unholy.DeathCoilConfig;
import elocindev.deathknights.config.entries.spells.unholy.PlaguesConfig;
import elocindev.deathknights.registry.SpellSchoolRegistry;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.spell_engine.api.event.CombatEvents;
import net.spell_engine.utils.TargetHelper;
import net.spell_power.api.SpellDamageSource;
import net.spell_power.api.SpellSchool;

public class DeathCoilHandler {
    private static DeathCoilConfig CONFIG = Configs.Spells.Unholy.DEATH_COIL;

    public static void register() {
        CombatEvents.SPELL_CAST.register(args -> {
            class_1657 caster = args.caster();
            if (caster == null) {
                return;
            }
            if (args.spell().id().toString().equals("death_knights:death_coil")) {
                List targets = args.targets();
                for (class_1297 target : targets) {
                    class_1293 plagueInstance;
                    if (!(target instanceof class_1309)) continue;
                    class_1309 livingTarget = (class_1309)target;
                    PlaguesConfig.PlagueProperty activePlague = null;
                    class_1291 activeEffect = null;
                    for (PlaguesConfig.PlagueProperty plague : PlaguesConfig.INSTANCE.plagues) {
                        class_1291 plagueEffect = (class_1291)class_7923.field_41174.method_10223(new class_2960(plague.effect_id));
                        if (plagueEffect == null || !livingTarget.method_6059(plagueEffect)) continue;
                        activePlague = plague;
                        activeEffect = plagueEffect;
                        break;
                    }
                    if (activePlague == null || activeEffect == null || (plagueInstance = livingTarget.method_6112(activeEffect)) == null) continue;
                    int currentStacks = plagueInstance.method_5578() + 1;
                    int stacksToExplode = Math.min(currentStacks, DeathCoilHandler.CONFIG.plague_stacks);
                    int remainingStacks = currentStacks - stacksToExplode;
                    float damagePerStack = (float)(caster.method_26825(SpellSchoolRegistry.UNHOLY.attribute) * (double)DeathCoilHandler.CONFIG.unholy_coefficent);
                    livingTarget.method_5643(SpellDamageSource.create((SpellSchool)SpellSchoolRegistry.UNHOLY, (class_1309)caster), damagePerStack * (float)stacksToExplode);
                    if (remainingStacks > 0) {
                        livingTarget.method_6092(new class_1293(activeEffect, activePlague.duration_ticks, remainingStacks - 1));
                    } else {
                        livingTarget.method_6016(activeEffect);
                    }
                    DeathCoilHandler.applyPlagueToNearbyTargets(livingTarget, caster, activeEffect, activePlague);
                }
            }
        });
    }

    private static void applyPlagueToNearbyTargets(class_1309 target, class_1657 caster, class_1291 plagueEffect, PlaguesConfig.PlagueProperty plague) {
        List nearbyEntities = target.method_37908().method_8390(class_1309.class, target.method_5829().method_1014(DeathCoilHandler.CONFIG.spread_radius), e -> e != target);
        for (class_1309 ent : nearbyEntities) {
            class_1657 playerVictim;
            class_1293 currentEffect = ent.method_6112(plagueEffect);
            if (ent.equals((Object)caster) || ent instanceof class_1657 && ((playerVictim = (class_1657)ent).method_7337() || playerVictim.method_7325() || !TargetHelper.allowedToHurt((class_1297)caster, (class_1297)playerVictim))) continue;
            if (currentEffect != null) {
                int currentStacks = currentEffect.method_5578() + 1;
                int newStacks = Math.min(currentStacks + 1, plague.max_stacks);
                ent.method_6092(new class_1293(plagueEffect, plague.duration_ticks, newStacks - 1));
                continue;
            }
            ent.method_6092(new class_1293(plagueEffect, plague.duration_ticks, 0));
        }
    }
}

