/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.multiblocks;

import aztech.modern_industrialization.api.machine.holder.CrafterComponentHolder;
import aztech.modern_industrialization.api.machine.holder.MultiblockInventoryComponentHolder;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.components.ActiveShapeComponent;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.MultiblockInventoryComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.CraftingMultiblockGui;
import aztech.modern_industrialization.machines.guicomponents.ReiSlotLocking;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.util.Tickable;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCraftingMultiblockBlockEntity
extends MultiblockMachineBlockEntity
implements Tickable,
MultiblockInventoryComponentHolder,
CrafterComponentHolder {
    @Nullable
    private ShapeMatcher shapeMatcher = null;
    private OperatingState operatingState = OperatingState.NOT_MATCHED;
    protected final ActiveShapeComponent activeShape;
    protected final MultiblockInventoryComponent inventory;
    protected final CrafterComponent crafter;
    private final IsActiveComponent isActive;

    public AbstractCraftingMultiblockBlockEntity(BEP bep, String name, OrientationComponent.Params orientationParams, ShapeTemplate[] shapeTemplates) {
        super(bep, new MachineGuiParameters.Builder(name, false).backgroundHeight(200).build(), orientationParams);
        this.activeShape = new ActiveShapeComponent(shapeTemplates);
        this.inventory = new MultiblockInventoryComponent();
        this.crafter = new CrafterComponent(this, this.inventory, this.getBehavior());
        this.isActive = new IsActiveComponent();
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        serverArray[0] = new CraftingMultiblockGui.Server(() -> this.shapeValid.shapeValid, this.crafter::getProgress, this.crafter);
        this.registerGuiComponent(serverArray);
        GuiComponent.Server[] serverArray2 = new GuiComponent.Server[1];
        serverArray2[0] = new ReiSlotLocking.Server(this.crafter::lockRecipe, () -> this.operatingState != OperatingState.NOT_MATCHED);
        this.registerGuiComponent(serverArray2);
        this.registerComponents(this.activeShape, this.crafter, this.isActive);
    }

    protected abstract CrafterComponent.Behavior getBehavior();

    protected abstract void onSuccessfulMatch(ShapeMatcher var1);

    @Override
    public ShapeTemplate getActiveShape() {
        return this.activeShape.getActiveShape();
    }

    @Override
    public MultiblockInventoryComponent getMultiblockInventoryComponent() {
        return this.inventory;
    }

    @Override
    public CrafterComponent getCrafterComponent() {
        return this.crafter;
    }

    @Override
    public final MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    @Override
    protected final MachineModelClientData getModelData() {
        return new MachineModelClientData(null, this.orientation.facingDirection).active(this.isActive.isActive);
    }

    @Override
    public final void tick() {
        if (!this.field_11863.field_9236) {
            this.link();
            boolean newActive = false;
            if (this.operatingState == OperatingState.TRYING_TO_RESUME && this.crafter.tryContinueRecipe()) {
                this.operatingState = OperatingState.NORMAL_OPERATION;
            }
            if (this.operatingState == OperatingState.NORMAL_OPERATION) {
                if (this.crafter.tickRecipe()) {
                    newActive = true;
                }
            } else {
                this.crafter.decreaseEfficiencyTicks();
            }
            this.isActive.updateActive(newActive, this);
        }
        this.tickExtra();
    }

    public void tickExtra() {
    }

    protected final void link() {
        if (this.shapeMatcher == null) {
            this.shapeMatcher = new ShapeMatcher(this.field_11863, this.field_11867, this.orientation.facingDirection, this.getActiveShape());
            this.shapeMatcher.registerListeners(this.field_11863);
        }
        if (this.shapeMatcher.needsRematch()) {
            this.operatingState = OperatingState.NOT_MATCHED;
            this.shapeValid.shapeValid = false;
            this.shapeMatcher.rematch(this.field_11863);
            if (this.shapeMatcher.isMatchSuccessful()) {
                this.inventory.rebuild(this.shapeMatcher);
                this.onSuccessfulMatch(this.shapeMatcher);
                this.shapeValid.shapeValid = true;
                this.operatingState = OperatingState.TRYING_TO_RESUME;
            }
            if (this.shapeValid.update()) {
                this.sync(false);
            }
        }
    }

    @Override
    public final void unlink() {
        if (this.shapeMatcher != null) {
            this.shapeMatcher.unlinkHatches();
            this.shapeMatcher.unregisterListeners(this.field_11863);
            this.shapeMatcher = null;
        }
    }

    private static enum OperatingState {
        NOT_MATCHED,
        TRYING_TO_RESUME,
        NORMAL_OPERATION;

    }
}

