/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.extramodintegrations;

import com.kneelawk.extramodintegrations.ExMIPlugin;
import com.kneelawk.extramodintegrations.ExMITextures;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class FluidIntoContainerEmiRecipe
implements EmiRecipe {
    private final class_2960 id;
    private final EmiStack fluid;
    private final EmiStack container;
    private final EmiStack emptyContainer;
    private final List<EmiIngredient> inputs;
    private final List<EmiStack> outputs;

    public FluidIntoContainerEmiRecipe(class_2960 id, EmiStack fluid, EmiStack container, EmiStack emptyContainer) {
        this.id = id;
        this.fluid = fluid;
        this.container = container;
        this.emptyContainer = emptyContainer;
        this.inputs = !emptyContainer.isEmpty() ? List.of(fluid, emptyContainer) : List.of(fluid);
        this.outputs = List.of(container);
    }

    public EmiRecipeCategory getCategory() {
        return ExMIPlugin.FLUID_INTO_CONTAINER_CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        if (this.emptyContainer.isEmpty()) {
            return 60;
        }
        return 102;
    }

    public int getDisplayHeight() {
        return 18;
    }

    public void addWidgets(WidgetHolder widgets) {
        int offset;
        if (!this.emptyContainer.isEmpty()) {
            widgets.addSlot((EmiIngredient)this.emptyContainer, 0, 0);
            widgets.addTexture(ExMITextures.PLUS_LARGE_SYMBOL, 22, 1);
            offset = 42;
        } else {
            offset = 0;
        }
        widgets.addSlot((EmiIngredient)this.fluid, offset, 0);
        widgets.addTexture(ExMITextures.RIGHT_ARROW, offset + 18 + 4, 1);
        widgets.addSlot((EmiIngredient)this.container, offset + 18 + 24, 0).recipeContext((EmiRecipe)this);
    }
}

