/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.extramodintegrations.util;

import com.kneelawk.extramodintegrations.ExMIMod;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.Nullable;

public class ReflectionUtils {
    public static <T> T newInstance(String name) throws ClassNotFoundException {
        try {
            return (T)Class.forName(name).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to get instance: " + name, e);
        }
    }

    @Nullable
    public static <T> T newIntegrationInstance(String name, String modDisplayName) {
        try {
            return ReflectionUtils.newInstance(name);
        }
        catch (ClassNotFoundException e) {
            ExMIMod.LOGGER.warn("[Extra Mod Integrations] Attempted to load " + modDisplayName + " integration, but Extra Mod Integrations was compiled with " + modDisplayName + " integration disabled. EMI <-> " + modDisplayName + " integration will not work.");
            return null;
        }
    }
}

