/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.extramodintegrations.util;

import com.kneelawk.extramodintegrations.ExMIMod;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1058;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class UIUtils {
    public static final float FLUID_PATCH_WIDTH = 16.0f;
    public static final float FLUID_PATCH_HEIGHT = 16.0f;
    private static final String[] suffixes = new String[]{"metric.format.0", "metric.format.1", "metric.format.2", "metric.format.3", "metric.format.4", "metric.format.5", "metric.format.6", "metric.format.7", "metric.format.8", "metric.format.9"};

    public static class_5481 cookTime(int ticks) {
        float secs = (float)ticks / 20.0f;
        return ExMIMod.gui("cook_time", Float.valueOf(secs)).method_30937();
    }

    public static void cookTime(WidgetHolder widgets, int ticks, int x, int y) {
        widgets.addText(UIUtils.cookTime(ticks), x, y, -12632257, false);
    }

    public static void cookArrow(WidgetHolder widgets, int ticks, int x, int y) {
        widgets.addFillingArrow(x, y, ticks * 50).tooltip((x1, y1) -> List.of(class_5684.method_32662((class_5481)UIUtils.cookTime(ticks))));
    }

    public static class_2561 metricNumber(int number) {
        int power = class_3532.method_15340((int)((int)Math.log10(number)), (int)0, (int)9) / 3 * 3;
        double chopped = (double)number / Math.pow(10.0, power);
        return ExMIMod.gui(suffixes[power], chopped);
    }

    public static void drawSlotHightlight(class_332 context, int x, int y, int w, int h) {
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        context.method_25294(x, y, x + w, y + h, -2130706433);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        context.method_51448().method_22909();
    }

    public static void renderFluid(class_4587 matrices, FluidVariant fluid, int x, int areaY, float areaHeight, float fluidHeight, float fluidWidth) {
        class_1058[] sprites = FluidVariantRendering.getSprites((FluidVariant)fluid);
        if (sprites == null || sprites.length < 1 || sprites[0] == null) {
            return;
        }
        class_1058 sprite = sprites[0];
        RenderSystem.setShader(class_757::method_34541);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)sprite.method_45852());
        Matrix4f model = matrices.method_23760().method_23761();
        int color = FluidVariantRendering.getColor((FluidVariant)fluid);
        float r = (float)(color >> 16 & 0xFF) / 256.0f;
        float g = (float)(color >> 8 & 0xFF) / 256.0f;
        float b = (float)(color & 0xFF) / 256.0f;
        class_289 tess = class_289.method_1348();
        class_287 bufferBuilder = tess.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        int fluidStripCount = (int)(fluidHeight / 16.0f);
        for (int i = 0; i < fluidStripCount; ++i) {
            UIUtils.buildFluidHorizontalStrip(bufferBuilder, model, sprite, x, (float)areaY + areaHeight - 16.0f * (float)(i + 1), fluidWidth, 16.0f, r, g, b);
        }
        float stripRemainder = fluidHeight % 16.0f;
        UIUtils.buildFluidHorizontalStrip(bufferBuilder, model, sprite, x, (float)areaY + areaHeight - 16.0f * (float)fluidStripCount - stripRemainder, fluidWidth, stripRemainder, r, g, b);
        tess.method_1350();
    }

    private static void buildFluidHorizontalStrip(class_287 bufferBuilder, Matrix4f model, class_1058 sprite, float x0, float y0, float width, float height, float r, float g, float b) {
        int fluidPatchCount = (int)(width / 16.0f);
        for (int i = 0; i < fluidPatchCount; ++i) {
            UIUtils.buildFluidPatch(bufferBuilder, model, sprite, x0 + 16.0f * (float)i, y0, 16.0f, height, r, g, b);
        }
        float patchRemainder = width % 16.0f;
        UIUtils.buildFluidPatch(bufferBuilder, model, sprite, x0 + 16.0f * (float)fluidPatchCount, y0, patchRemainder, height, r, g, b);
    }

    private static void buildFluidPatch(class_287 bufferBuilder, Matrix4f model, class_1058 sprite, float x0, float y0, float width, float height, float r, float g, float b) {
        float x1 = x0 + width;
        float y1 = y0 + height;
        float uMax = sprite.method_4577();
        float vMax = sprite.method_4575();
        float spriteWidth = sprite.method_4577() - sprite.method_4594();
        float spriteHeight = sprite.method_4575() - sprite.method_4593();
        float uMin = uMax - spriteWidth * width / 16.0f;
        float vMin = vMax - spriteHeight * height / 16.0f;
        bufferBuilder.method_22918(model, x0, y1, 1.0f).method_22915(r, g, b, 1.0f).method_22913(uMin, vMax).method_1344();
        bufferBuilder.method_22918(model, x1, y1, 1.0f).method_22915(r, g, b, 1.0f).method_22913(uMax, vMax).method_1344();
        bufferBuilder.method_22918(model, x1, y0, 1.0f).method_22915(r, g, b, 1.0f).method_22913(uMax, vMin).method_1344();
        bufferBuilder.method_22918(model, x0, y0, 1.0f).method_22915(r, g, b, 1.0f).method_22913(uMin, vMin).method_1344();
    }
}

