/*
 * Decompiled with CFR 0.152.
 */
package info.partonetrain.botaniacombat;

import info.partonetrain.botaniacombat.BotaniaCombat;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;

public abstract class PsiContributorColors {
    private static volatile Map<String, int[]> colormap = Collections.emptyMap();

    public static void load(Properties props) {
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key).replace("#", "0x");
            try {
                int[] values = Stream.of(value.split(",")).mapToInt(el -> Integer.parseInt(el.substring(2), 16)).toArray();
                map.put(key, values);
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                BotaniaCombat.LOGGER.error("Psi Contributor " + key + " has an invalid hexcode!");
            }
        }
        colormap = map;
    }

    public static boolean isContributor(String name) {
        return colormap.containsKey(name);
    }

    public static int[] getColors(String name) {
        return colormap.getOrDefault(name, new int[]{0x20FF20});
    }

    public static void get() {
        try {
            URL url = new URL("https://raw.githubusercontent.com/Vazkii/Psi/master/contributors.properties");
            Properties props = new Properties();
            try (InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);){
                props.load(reader);
                PsiContributorColors.load(props);
            }
        }
        catch (IOException e) {
            BotaniaCombat.LOGGER.info("Could not load Psi contributors list. Either you're offline or GitHub is down. Nothing to worry about, carry on~");
        }
    }
}

