/*
 * Decompiled with CFR 0.152.
 */
package info.partonetrain.botaniacombat.mixin.ranged;

import info.partonetrain.botaniacombat.BotaniaCombat;
import info.partonetrain.botaniacombat.BotaniaNerfConfiguredValues;
import java.util.UUID;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.ManaBlasterItem;

@Mixin(value={ManaBlasterItem.class})
public abstract class ManaBlasterMixin
extends class_1792 {
    @Unique
    private static final String TAG_DAMAGING_COOLDOWN = "botaniacombat:damagingMaxCooldown";
    @Unique
    float damage;
    @Unique
    class_1322 mod1;
    @Unique
    class_1322 mod2;

    public ManaBlasterMixin(class_1792.class_1793 properties) {
        super(properties);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Inject(method={"inventoryTick"}, at={@At(value="HEAD")})
    public void botaniacombat$setDamageLensNBT(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected, CallbackInfo ci) {
        if (ManaBlasterItem.getLens((class_1799)stack).method_31574(BotaniaItems.lensDamage) && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (!entity.method_37908().method_8608()) {
                this.damage = BotaniaNerfConfiguredValues.dmgLensDamage;
                if (stack.method_7926(class_1304.field_6173).containsKey((Object)EntityAttributes_RangedWeapon.DAMAGE.attribute)) return;
                this.mod1 = new class_1322(UUID.fromString("60dfc4ff-de55-4f4f-8b4b-a7748c26ec4d"), "Blaster mainhand damage", (double)this.damage, class_1322.class_1323.field_6328);
                this.mod2 = new class_1322(UUID.fromString("2c9b7180-d04f-4b1f-9574-174969759856"), "Blaster offhand damage", (double)this.damage, class_1322.class_1323.field_6328);
                stack.method_7916(EntityAttributes_RangedWeapon.DAMAGE.attribute, this.mod1, class_1304.field_6173);
                stack.method_7916(EntityAttributes_RangedWeapon.DAMAGE.attribute, this.mod2, class_1304.field_6171);
                stack.method_7948().method_10569(TAG_DAMAGING_COOLDOWN, this.calculateModifiedCooldown(player));
                return;
            }
        }
        if (stack.method_7969() == null) return;
        stack.method_7969().method_10551("AttributeModifiers");
        stack.method_7969().method_10551(TAG_DAMAGING_COOLDOWN);
    }

    @Inject(method={"use"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;isSecondaryUseActive()Z")})
    public void botaniacombat$useRangedWeaponHaste(class_1937 world, class_1657 player, @NotNull class_1268 hand, CallbackInfoReturnable<class_1271<class_1799>> cir) {
        class_1799 stack = player.method_5998(hand);
        if (ManaBlasterItem.getLens((class_1799)stack).method_31574(BotaniaItems.lensDamage) && !player.method_37908().method_8608()) {
            stack.method_7948().method_10569(TAG_DAMAGING_COOLDOWN, this.calculateModifiedCooldown(player));
        }
    }

    @ModifyArgs(method={"use"}, at=@At(value="INVOKE", target="Lvazkii/botania/common/item/ManaBlasterItem;setCooldown(Lnet/minecraft/world/item/ItemStack;I)V", ordinal=1))
    public void botaniacombat$useModifiedCooldown(Args args) {
        class_1799 stack = (class_1799)args.get(0);
        int cooldown = (Integer)args.get(1);
        if (ManaBlasterItem.getLens((class_1799)stack).method_31574(BotaniaItems.lensDamage)) {
            int modifiedCooldown = ItemNBTHelper.getInt((class_1799)stack, (String)TAG_DAMAGING_COOLDOWN, (int)30);
            args.set(1, (Object)modifiedCooldown);
        }
    }

    @Unique
    public int calculateModifiedCooldown(class_1657 player) {
        int modifiedCooldown = 30;
        double attributeValue = player.method_26825(EntityAttributes_RangedWeapon.HASTE.attribute);
        double cooldownMultiplier = (100.0 - attributeValue) / 100.0;
        modifiedCooldown = (int)((double)modifiedCooldown + (double)modifiedCooldown * cooldownMultiplier);
        return modifiedCooldown;
    }

    @Inject(method={"getBarColor"}, at={@At(value="HEAD")}, cancellable=true)
    public void botaniacombat$dontCrashIfCooldownIncreased(class_1799 stack, CallbackInfoReturnable<Integer> cir) {
        int cd = stack.method_7948().method_10550("cooldown");
        try {
            cir.setReturnValue((Object)class_3532.method_15369((float)((1.0f - (float)cd / 30.0f) / 3.0f), (float)1.0f, (float)1.0f));
        }
        catch (RuntimeException e) {
            BotaniaCombat.LOGGER.error(e.getMessage());
            cir.setReturnValue((Object)class_3532.method_15369((float)1.0f, (float)1.0f, (float)1.0f));
        }
    }
}

