/*
 * Decompiled with CFR 0.152.
 */
package io.github.thepoultryman.walllanterns.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.thepoultryman.walllanterns.WallLanterns;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.apache.commons.io.IOUtils;

public class Config {
    public static final Config INSTANCE = new Config();
    public ConfigType configuration;

    public Config() {
        try {
            Path configPath = Path.of(FabricLoader.getInstance().getConfigDir() + "/walllanterns.json", new String[0]);
            if (configPath.toFile().exists()) {
                this.loadConfig();
            } else {
                InputStream inputStream = this.getClass().getResourceAsStream("/assets/walllanterns/walllanterns.json");
                if (inputStream != null) {
                    FileOutputStream outputStream = new FileOutputStream(configPath.toFile());
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                    this.loadConfig();
                }
            }
        }
        catch (FileNotFoundException configPath) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadConfig() {
        Path configPath = Path.of(FabricLoader.getInstance().getConfigDir() + "/walllanterns.json", new String[0]);
        if (configPath.toFile().exists()) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try {
                FileReader reader = new FileReader(configPath.toFile());
                this.configuration = (ConfigType)gson.fromJson((Reader)reader, ConfigType.class);
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (!this.configuration.isConfigUpToDate()) {
                WallLanterns.LOGGER.info("Config file is out of date, updating.");
                this.configuration.updateConfig();
                try {
                    FileWriter writer = new FileWriter(configPath.toFile());
                    gson.toJson((Object)this.configuration, (Appendable)writer);
                    ((Writer)writer).close();
                }
                catch (IOException exception) {
                    WallLanterns.LOGGER.warn("Error updating configuration file. An attempt will be made next launch to update the file.", (Throwable)exception);
                }
            }
        }
    }

    public List<class_2960> getVanillaTypeLanterns() {
        ArrayList<class_2960> identifiers = new ArrayList<class_2960>();
        for (String identifier : this.configuration.vanillaTypeLanterns) {
            identifiers.add(new class_2960(identifier));
        }
        return identifiers;
    }

    public static String[] getSupportedMods() {
        return new String[]{"oxidized", "extendedcopper"};
    }

    public static class ConfigType {
        private static final int EXPECTED_VANILLA_TYPE_LANTERNS = 2;
        public final List<String> vanillaTypeLanterns = new ArrayList<String>();

        public boolean isConfigUpToDate() {
            return this.vanillaTypeLanterns.size() == 2;
        }

        public void updateConfig() {
            InputStream inputStream = this.getClass().getResourceAsStream("/assets/walllanterns/walllanterns.json");
            if (inputStream != null) {
                Gson gson = new Gson();
                InputStreamReader reader = new InputStreamReader(inputStream);
                ConfigType defaultConfig = (ConfigType)gson.fromJson((Reader)reader, ConfigType.class);
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                for (String identifier : defaultConfig.vanillaTypeLanterns) {
                    if (this.vanillaTypeLanterns.contains(identifier)) continue;
                    this.vanillaTypeLanterns.add(identifier);
                }
            }
        }
    }
}

