/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_2248;
import net.minecraft.class_2361;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.service.MixinService;
import virtuoel.kanos_config.api.InvalidatableLazySupplier;
import virtuoel.kanos_config.api.JsonConfigBuilder;
import virtuoel.kanos_config.api.JsonConfigHandler;
import virtuoel.kanos_config.api.MutableConfigEntry;
import virtuoel.statement.api.StatementApi;
import virtuoel.statement.api.StatementConfig;
import virtuoel.statement.util.FabricApiCompatibility;
import virtuoel.statement.util.ModLoaderUtils;
import virtuoel.statement.util.RegistryUtils;
import virtuoel.statement.util.StatementPropertyExtensions;
import virtuoel.statement.util.StatementStateExtensions;

@ApiStatus.Internal
public class Statement
implements ModInitializer,
StatementApi {
    public static final String MOD_ID = "statement";
    public static final ILogger LOGGER = MixinService.getService().getLogger("statement");
    public static final class_2960 BLOCK_STATE_VALIDATION_PACKET = Statement.id("block_state_validation");
    public static final class_2960 FLUID_STATE_VALIDATION_PACKET = Statement.id("fluid_state_validation");

    public Statement() {
        ((JsonConfigHandler)StatementConfig.BUILDER.config).get();
    }

    public void onInitialize() {
        boolean fabricCommandsLoaded = ModLoaderUtils.isModLoaded("fabric-command-api-v2") || ModLoaderUtils.isModLoaded("fabric-command-api-v1");
        boolean fabricNetworkingLoaded = ModLoaderUtils.isModLoaded("fabric-networking-api-v1");
        boolean fabricRegistrySyncLoaded = ModLoaderUtils.isModLoaded("fabric-registry-sync-v0");
        if (fabricCommandsLoaded) {
            FabricApiCompatibility.registerCommands();
        }
        if (fabricNetworkingLoaded) {
            FabricApiCompatibility.setupServerNetworking();
        }
        if (fabricRegistrySyncLoaded) {
            FabricApiCompatibility.setupIdRemapCallbacks();
        }
    }

    public static class_2960 id(String name) {
        return new class_2960(MOD_ID, name);
    }

    public static void markRegistryAsModded(class_2378<?> registry) {
        boolean fabricRegistrySyncLoaded = ModLoaderUtils.isModLoaded("fabric-registry-sync-v0");
        if (fabricRegistrySyncLoaded) {
            FabricApiCompatibility.markRegistryAsModded(registry);
        }
    }

    public static <S> MutableConfigEntry<Set<S>> createSetConfig(JsonConfigBuilder builder, String name, Function<Supplier<JsonObject>, Supplier<Set<S>>> entryGetterFunction) {
        return builder.customConfig(name, config -> arg_0 -> Statement.lambda$createSetConfig$0((Supplier)config, name, arg_0), Collections.emptySet(), entryGetterFunction);
    }

    public static Supplier<Set<class_2680>> createBlockStateDeferralConfig(Supplier<JsonObject> config) {
        return InvalidatableLazySupplier.of(() -> Statement.loadStateDeferralData(config, "customBlockStateDeferral", RegistryUtils.BLOCK_REGISTRY, class_2248::method_9595));
    }

    public static Supplier<Set<class_3610>> createFluidStateDeferralConfig(Supplier<JsonObject> config) {
        return InvalidatableLazySupplier.of(() -> Statement.loadStateDeferralData(config, "customFluidStateDeferral", RegistryUtils.FLUID_REGISTRY, class_3611::method_15783));
    }

    private static <O, S extends class_2688<O, S>> Set<S> loadStateDeferralData(Supplier<JsonObject> config, String member, class_2378<O> registry, Function<O, class_2689<O, S>> managerFunc) {
        JsonObject data = Optional.ofNullable(config.get().get(member)).filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).orElseGet(JsonObject::new);
        HashSet deferralData = new HashSet();
        for (Map.Entry e : data.entrySet()) {
            RegistryUtils.getOrEmpty(registry, new class_2960((String)e.getKey())).ifPresent(block -> {
                JsonArray states = Optional.ofNullable((JsonElement)e.getValue()).filter(JsonElement::isJsonArray).map(JsonElement::getAsJsonArray).orElseGet(JsonArray::new);
                class_2689 manager = (class_2689)managerFunc.apply(block);
                for (JsonElement s : states) {
                    if (!s.isJsonObject()) continue;
                    JsonObject stateSyncData = s.getAsJsonObject();
                    JsonObject properties = Optional.ofNullable(stateSyncData.get("properties")).filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).orElseGet(JsonObject::new);
                    HashMap predicates = new HashMap();
                    for (Map.Entry p : properties.entrySet()) {
                        class_2769 property = manager.method_11663((String)p.getKey());
                        if (property == null) continue;
                        ((StatementPropertyExtensions)property).statement_parse(((JsonElement)p.getValue()).getAsString()).ifPresent(val -> predicates.put(property, val::equals));
                    }
                    manager.method_11662().stream().filter(st -> predicates.entrySet().stream().allMatch(en -> ((Predicate)en.getValue()).test(st.method_11654((class_2769)en.getKey())))).forEach(deferralData::add);
                }
            });
        }
        return deferralData;
    }

    public static <S> boolean shouldStateBeDeferred(class_2361<S> idList, S state) {
        if (StatementConfig.COMMON.enableStateDeferralApi.get().booleanValue()) {
            for (StatementApi api : StatementApi.ENTRYPOINTS) {
                if (!api.shouldDeferState(idList, state)) continue;
                return true;
            }
        } else {
            if (idList == class_2248.field_10651) {
                return StatementConfig.COMMON.customBlockStateDeferral.get().contains(state);
            }
            if (idList == class_3611.field_15904) {
                return StatementConfig.COMMON.customFluidStateDeferral.get().contains(state);
            }
        }
        return false;
    }

    @Override
    public <S> boolean shouldDeferState(class_2361<S> idList, S state) {
        if (idList == class_2248.field_10651) {
            return StatementConfig.COMMON.customBlockStateDeferral.get().contains(state);
        }
        if (idList == class_3611.field_15904) {
            return StatementConfig.COMMON.customFluidStateDeferral.get().contains(state);
        }
        return StatementApi.super.shouldDeferState(idList, state);
    }

    public static OptionalInt getSyncedBlockStateId(@Nullable int id) {
        return Statement.getSyncedStateId(class_2248.field_10651, id);
    }

    public static OptionalInt getSyncedBlockStateId(@Nullable class_2680 state) {
        return Statement.getSyncedStateId(class_2248.field_10651, state);
    }

    public static OptionalInt getSyncedFluidStateId(@Nullable int id) {
        return Statement.getSyncedStateId(class_3611.field_15904, id);
    }

    public static OptionalInt getSyncedFluidStateId(@Nullable class_3610 state) {
        return Statement.getSyncedStateId(class_3611.field_15904, state);
    }

    public static <S> OptionalInt getSyncedStateId(class_2361<S> idList, int id) {
        return Statement.getSyncedStateId(idList, id, class_2361::method_10206, class_2361::method_10200, class_2361::method_10204);
    }

    public static <S> OptionalInt getSyncedStateId(class_2361<S> idList, @Nullable S state) {
        return Statement.getSyncedStateId(idList, state, class_2361::method_10206, class_2361::method_10200, class_2361::method_10204);
    }

    public static <S, L extends Iterable<S>> OptionalInt getSyncedStateId(L idList, int id, BiFunction<L, S, Integer> idFunc, BiFunction<L, Integer, S> getFunc, Function<L, Integer> sizeFunc) {
        return Statement.getSyncedStateId(idList, getFunc.apply(idList, id), idFunc, getFunc, sizeFunc);
    }

    public static <S, L extends Iterable<S>> OptionalInt getSyncedStateId(L idList, @Nullable S state, BiFunction<L, S, Integer> idFunc, BiFunction<L, Integer, S> getFunc, Function<L, Integer> sizeFunc) {
        if (state != null) {
            if (StatementConfig.COMMON.enableIdSyncApi.get().booleanValue()) {
                for (StatementApi api : StatementApi.ENTRYPOINTS) {
                    OptionalInt syncedId = api.getSyncedId(idList, state, idFunc, getFunc, sizeFunc);
                    if (!syncedId.isPresent()) continue;
                    return syncedId;
                }
            } else {
                if (idList == class_2248.field_10651) {
                    return StatementConfig.COMMON.customBlockStateSync.get().getOrDefault(state, OptionalInt.empty());
                }
                if (idList == class_3611.field_15904) {
                    return StatementConfig.COMMON.customFluidStateSync.get().getOrDefault(state, OptionalInt.empty());
                }
            }
        }
        return OptionalInt.empty();
    }

    public static <K, V> MutableConfigEntry<Map<K, V>> createMapConfig(JsonConfigBuilder builder, String name, Function<Supplier<JsonObject>, Supplier<Map<K, V>>> entryGetterFunction) {
        return builder.customConfig(name, config -> arg_0 -> Statement.lambda$createMapConfig$8((Supplier)config, name, arg_0), Collections.emptyMap(), entryGetterFunction);
    }

    public static Supplier<Map<class_2680, OptionalInt>> createBlockStateSyncConfig(Supplier<JsonObject> config) {
        return InvalidatableLazySupplier.of(() -> Statement.loadStateSyncData(config, "customBlockStateSync", class_2248.field_10651, RegistryUtils.BLOCK_REGISTRY, class_2248::method_9595, class_2248::method_9564));
    }

    public static Supplier<Map<class_3610, OptionalInt>> createFluidStateSyncConfig(Supplier<JsonObject> config) {
        return InvalidatableLazySupplier.of(() -> Statement.loadStateSyncData(config, "customFluidStateSync", class_3611.field_15904, RegistryUtils.FLUID_REGISTRY, class_3611::method_15783, class_3611::method_15785));
    }

    private static <O, S extends class_2688<O, S>> Map<S, OptionalInt> loadStateSyncData(Supplier<JsonObject> config, String member, class_2361<S> idList, class_2378<O> registry, Function<O, class_2689<O, S>> managerFunc, Function<O, S> defaultStateFunc) {
        JsonObject data = Optional.ofNullable(config.get().get(member)).filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).orElseGet(JsonObject::new);
        HashMap syncData = new HashMap();
        Function<class_2960, Optional> getOrEmpty = id -> RegistryUtils.getOrEmpty(registry, id);
        for (Map.Entry e : data.entrySet()) {
            getOrEmpty.apply(new class_2960((String)e.getKey())).ifPresent(block -> {
                JsonArray states = Optional.ofNullable((JsonElement)e.getValue()).filter(JsonElement::isJsonArray).map(JsonElement::getAsJsonArray).orElseGet(JsonArray::new);
                class_2689 manager = (class_2689)managerFunc.apply(block);
                for (JsonElement s : states) {
                    Function<class_2688, Integer> stateIdFunc;
                    if (!s.isJsonObject()) continue;
                    JsonObject stateSyncData = s.getAsJsonObject();
                    JsonObject properties = Optional.ofNullable(stateSyncData.get("properties")).filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).orElseGet(JsonObject::new);
                    JsonObject syncedStateData = Optional.ofNullable(stateSyncData.get("syncedState")).filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).orElseGet(JsonObject::new);
                    Optional<class_2960> syncedBlockId = Optional.ofNullable(syncedStateData.get("name")).filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsString).map(class_2960::new);
                    JsonObject syncedStateProperties = Optional.ofNullable(syncedStateData.get("properties")).filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).orElseGet(JsonObject::new);
                    if (syncedBlockId.isPresent()) {
                        class_2688 syncedState = syncedBlockId.map(getOrEmpty).orElseGet(Optional::empty).map(defaultStateFunc).orElse(null);
                        if (syncedState != null) {
                            int id = idList.method_10206((Object)Statement.getStateWithProperties(manager, syncedState, syncedStateProperties.entrySet()));
                            stateIdFunc = state -> id;
                        } else {
                            stateIdFunc = state -> -1;
                        }
                    } else {
                        stateIdFunc = state -> idList.method_10206((Object)Statement.getStateWithProperties(manager, state, syncedStateProperties.entrySet()));
                    }
                    OptionalInt syncedId = Optional.ofNullable(stateSyncData.get("syncedId")).filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsJsonPrimitive).filter(JsonPrimitive::isNumber).map(JsonPrimitive::getAsInt).map(OptionalInt::of).orElseGet(OptionalInt::empty);
                    HashMap predicates = new HashMap();
                    for (Map.Entry p : properties.entrySet()) {
                        class_2769 property = manager.method_11663((String)p.getKey());
                        if (property == null) continue;
                        ((StatementPropertyExtensions)property).statement_parse(((JsonElement)p.getValue()).getAsString()).ifPresent(val -> predicates.put(property, val::equals));
                    }
                    manager.method_11662().stream().filter(st -> predicates.entrySet().stream().allMatch(en -> ((Predicate)en.getValue()).test(st.method_11654((class_2769)en.getKey())))).forEach(st -> {
                        int id = (Integer)stateIdFunc.apply((class_2688)st);
                        syncData.put(st, id == -1 ? syncedId : OptionalInt.of(id));
                    });
                }
            });
        }
        return syncData;
    }

    private static <O, S extends class_2688<O, S>> S getStateWithProperties(class_2689<O, S> manager, S state, Set<Map.Entry<String, JsonElement>> properties) {
        for (Map.Entry<String, JsonElement> p : properties) {
            Optional value;
            class_2769 property = manager.method_11663(p.getKey());
            if (property == null || !(value = ((StatementPropertyExtensions)property).statement_parse(p.getValue().getAsString())).isPresent()) continue;
            state = (class_2688)((StatementStateExtensions)state).statement_with(property, (Comparable)value.get());
        }
        return state;
    }

    @Override
    public <S, L extends Iterable<S>> OptionalInt getSyncedId(L idList, @Nullable S state, BiFunction<L, S, Integer> idFunc, BiFunction<L, Integer, S> getFunc, Function<L, Integer> sizeFunc) {
        if (idList == class_2248.field_10651) {
            return StatementConfig.COMMON.customBlockStateSync.get().getOrDefault(state, OptionalInt.empty());
        }
        if (idList == class_3611.field_15904) {
            return StatementConfig.COMMON.customFluidStateSync.get().getOrDefault(state, OptionalInt.empty());
        }
        return OptionalInt.empty();
    }

    public static void invalidateCustomStateData(class_2361<?> idList) {
        if (idList == class_2248.field_10651) {
            InvalidatableLazySupplier.of(StatementConfig.COMMON.customBlockStateDeferral).invalidate();
            InvalidatableLazySupplier.of(StatementConfig.COMMON.customBlockStateSync).invalidate();
        } else if (idList == class_3611.field_15904) {
            InvalidatableLazySupplier.of(StatementConfig.COMMON.customFluidStateDeferral).invalidate();
            InvalidatableLazySupplier.of(StatementConfig.COMMON.customFluidStateSync).invalidate();
        }
    }

    private static /* synthetic */ void lambda$createMapConfig$8(Supplier config, String name, Map v) {
        if (v.isEmpty()) {
            ((JsonObject)config.get()).add(name, (JsonElement)new JsonObject());
        }
    }

    private static /* synthetic */ void lambda$createSetConfig$0(Supplier config, String name, Set v) {
        if (v.isEmpty()) {
            ((JsonObject)config.get()).add(name, (JsonElement)new JsonObject());
        }
    }
}

