/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.api;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Collections;
import java.util.Map;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;
import virtuoel.statement.util.StatementPropertyExtensions;

public interface MutableStateManager {
    default public Map<String, class_2769<?>> statement_getProperties() {
        return Collections.emptyMap();
    }

    default public void statement_setProperties(Map<String, class_2769<?>> properties) {
    }

    @Nullable
    default public <V extends Comparable<V>> class_2769<?> statement_addProperty(class_2769<V> property, V defaultValue) {
        return this.statement_addProperty(property);
    }

    @Nullable
    default public class_2769<?> statement_addProperty(class_2769<?> property) {
        String name;
        Map<String, class_2769<?>> properties = this.statement_getProperties();
        class_2769<?> ret = properties.get(name = ((StatementPropertyExtensions)property).statement_getName());
        if (ret != property) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            builder.put((Object)name, property);
            if (ret != null) {
                for (Map.Entry<String, class_2769<?>> e : properties.entrySet()) {
                    class_2769<?> value = e.getValue();
                    if (value == ret) continue;
                    builder.put((Object)e.getKey(), value);
                }
            } else {
                builder.putAll(properties);
            }
            this.statement_setProperties((Map<String, class_2769<?>>)builder.build());
        }
        return ret;
    }

    @Nullable
    default public class_2769<?> statement_removeProperty(String propertyName) {
        Map<String, class_2769<?>> properties = this.statement_getProperties();
        class_2769<?> ret = properties.get(propertyName);
        if (ret != null) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            for (Map.Entry<String, class_2769<?>> e : properties.entrySet()) {
                class_2769<?> value = e.getValue();
                if (value == ret) continue;
                builder.put((Object)e.getKey(), value);
            }
            this.statement_setProperties((Map<String, class_2769<?>>)builder.build());
        }
        return ret;
    }

    default public boolean statement_removeProperty(class_2769<?> property) {
        String name = ((StatementPropertyExtensions)property).statement_getName();
        return this.statement_removeProperty(name) != null;
    }
}

