/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.class_2688;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import org.apache.commons.lang3.tuple.Pair;
import virtuoel.statement.api.MutableStateManager;
import virtuoel.statement.api.StateRefresher;
import virtuoel.statement.api.compatibility.FoamFixCompatibility;
import virtuoel.statement.util.StatementPropertyExtensions;
import virtuoel.statement.util.StatementStateExtensions;

public interface RefreshableStateManager<O, S extends class_2688<O, S>>
extends MutableStateManager {
    default public BiFunction<O, ImmutableMap<class_2769<?>, Comparable<?>>, S> statement_getStateFunction() {
        return (o, m) -> null;
    }

    default public Optional<Object> statement_getFactory() {
        return Optional.empty();
    }

    default public void statement_setStateList(ImmutableList<S> states) {
    }

    default public void statement_rebuildCodec() {
    }

    default public <V extends Comparable<V>> Collection<S> statement_reconstructStateList(Map<class_2769<V>, Collection<V>> addedValueMap) {
        Stream stateStream;
        class_2689 self = (class_2689)this;
        Object owner = self.method_11660();
        Collection properties = self.method_11659();
        ImmutableList states = self.method_11662();
        Stream<List<Object>> tableStream = Stream.of(Collections.emptyList());
        for (class_2769 entry : properties) {
            Collection deferred = addedValueMap.getOrDefault(entry, new LinkedList());
            tableStream = tableStream.flatMap(propertyList -> {
                StatementPropertyExtensions p = (StatementPropertyExtensions)entry;
                ArrayList values = new ArrayList();
                ArrayList addedValues = new ArrayList();
                for (Comparable val : p.statement_getValues()) {
                    ArrayList<Pair> list = new ArrayList<Pair>((Collection<Pair>)propertyList);
                    list.add(Pair.of((Object)entry, (Object)val));
                    (deferred.contains(val) ? addedValues : values).add(list);
                }
                values.addAll(addedValues);
                return values.stream();
            });
        }
        LinkedList currentStates = new LinkedList();
        LinkedList addedStates = new LinkedList();
        LinkedHashMap stateMap = new LinkedHashMap();
        this.statement_rebuildCodec();
        BiFunction function = this.statement_getStateFunction();
        Optional<Object> mapper = FoamFixCompatibility.INSTANCE.constructPropertyValueMapper(properties);
        FoamFixCompatibility.INSTANCE.setFactoryMapper(this.statement_getFactory(), mapper);
        tableStream.forEach(valueList -> {
            class_2688 currentState;
            ImmutableMap propertyValueMap = (ImmutableMap)valueList.stream().collect(ImmutableMap.toImmutableMap(Pair::getLeft, Pair::getRight));
            if (addedValueMap.entrySet().stream().anyMatch(e -> ((Collection)e.getValue()).contains(propertyValueMap.get(e.getKey())))) {
                currentState = (class_2688)function.apply(owner, propertyValueMap);
                if (currentState != null) {
                    addedStates.add(currentState);
                }
            } else {
                currentState = (StateRefresher.INSTANCE.isParallel() ? states.parallelStream() : states.stream()).filter(state -> ((StatementStateExtensions)state).statement_getEntries().equals((Object)propertyValueMap)).findFirst().orElse(null);
            }
            if (currentState != null) {
                stateMap.put(propertyValueMap, currentState);
                currentStates.add(currentState);
            }
        });
        Stream stream = stateStream = StateRefresher.INSTANCE.isParallel() ? currentStates.parallelStream() : currentStates.stream();
        if (!addedStates.isEmpty()) {
            stateStream.forEach(propertyContainer -> {
                FoamFixCompatibility.INSTANCE.setStateOwner((class_2688<?, ?>)propertyContainer, mapper);
                StatementStateExtensions.statement_cast(propertyContainer).statement_createWithTable(stateMap);
            });
            this.statement_setStateList(ImmutableList.copyOf(currentStates));
        } else if (FoamFixCompatibility.INSTANCE.isEnabled()) {
            stateStream.forEach(propertyContainer -> FoamFixCompatibility.INSTANCE.setStateOwner((class_2688<?, ?>)propertyContainer, mapper));
        }
        return addedStates;
    }
}

