/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.api;

import com.google.gson.JsonObject;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import org.jetbrains.annotations.ApiStatus;
import virtuoel.kanos_config.api.JsonConfigBuilder;
import virtuoel.kanos_config.api.JsonConfigHandler;
import virtuoel.statement.Statement;

public class StatementConfig {
    @ApiStatus.Internal
    public static final JsonConfigBuilder BUILDER = new JsonConfigBuilder("statement", FabricLoader.getInstance().getConfigDir().resolve("statement").resolve("config.json").normalize());
    public static final Client CLIENT = new Client(BUILDER);
    public static final Common COMMON = new Common(BUILDER);
    public static final Server SERVER = new Server(BUILDER);
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    public static final Supplier<JsonObject> HANDLER = StatementConfig.BUILDER.config;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
    public static final JsonObject DATA = (JsonObject)((JsonConfigHandler)StatementConfig.BUILDER.config).get();

    private StatementConfig() {
    }

    public static final class Client {
        private Client(JsonConfigBuilder builder) {
        }
    }

    public static final class Common {
        public final Supplier<Boolean> enableStateDeferralApi;
        public final Supplier<Boolean> enableIdSyncApi;
        public final Supplier<Boolean> forceParallelMode;
        public final Supplier<Set<class_2680>> customBlockStateDeferral;
        public final Supplier<Map<class_2680, OptionalInt>> customBlockStateSync;
        public final Supplier<Set<class_3610>> customFluidStateDeferral;
        public final Supplier<Map<class_3610, OptionalInt>> customFluidStateSync;

        private Common(JsonConfigBuilder builder) {
            this.enableStateDeferralApi = builder.booleanConfig("enableStateDeferralApi", true);
            this.enableIdSyncApi = builder.booleanConfig("enableIdSyncApi", true);
            this.forceParallelMode = builder.booleanConfig("forceParallelMode", false);
            this.customBlockStateDeferral = Statement.createSetConfig(builder, "customBlockStateDeferral", Statement::createBlockStateDeferralConfig);
            this.customBlockStateSync = Statement.createMapConfig(builder, "customBlockStateSync", Statement::createBlockStateSyncConfig);
            this.customFluidStateDeferral = Statement.createSetConfig(builder, "customFluidStateDeferral", Statement::createFluidStateDeferralConfig);
            this.customFluidStateSync = Statement.createMapConfig(builder, "customFluidStateSync", Statement::createFluidStateSyncConfig);
        }
    }

    public static final class Server {
        private Server(JsonConfigBuilder builder) {
        }
    }
}

