/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.mixin.compat115minus;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2769;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import virtuoel.statement.Statement;
import virtuoel.statement.util.HydrogenCompatibility;
import virtuoel.statement.util.StatementStateExtensions;

@Mixin(targets={"net.minecraft.class_2679"}, remap=false)
public abstract class AbstractStateMixin<O, S>
implements StatementStateExtensions<S> {
    @Shadow(remap=false)
    @Final
    @Mutable
    protected O field_12287;
    @Shadow(remap=false)
    @Final
    @Mutable
    private ImmutableMap<class_2769<?>, Comparable<?>> field_12285;
    @Shadow(remap=false)
    private Table<class_2769<?>, Comparable<?>, S> field_12288;
    @Unique
    String getMissingOwner = "";
    @Unique
    String withMissingOwner = "";
    @Unique
    String withDisallowedOwner = "";
    @Unique
    final Map<class_2769<?>, Comparable<?>> cachedFallbacks = new HashMap();

    @Inject(method={"method_11654"}, cancellable=true, at={@At(value="INVOKE", target="Ljava/lang/IllegalArgumentException;<init>(Ljava/lang/String;)V")}, remap=false)
    private <T extends Comparable<T>> void onGet(class_2769<T> property, CallbackInfoReturnable<T> info) {
        String ownerString = this.field_12287.toString();
        if (!this.getMissingOwner.equals(ownerString)) {
            Statement.LOGGER.info("Cannot get property {} as it does not exist in {}", new Object[]{property, this.field_12287});
            this.getMissingOwner = ownerString;
        }
        info.setReturnValue((Object)(this.cachedFallbacks.containsKey(property) ? (Comparable)property.method_11902().cast(this.cachedFallbacks.get(property)) : (Comparable)property.method_11898().iterator().next()));
    }

    @Inject(method={"method_11657"}, cancellable=true, at={@At(value="INVOKE", target="Ljava/lang/IllegalArgumentException;<init>(Ljava/lang/String;)V")}, remap=false)
    private <T extends Comparable<T>, V extends T> void onWith(class_2769<T> property, V value, CallbackInfoReturnable<Object> info) {
        String ownerString = this.field_12287.toString();
        if (this.field_12285.get(property) == null) {
            if (!this.withMissingOwner.equals(ownerString)) {
                Statement.LOGGER.info("Cannot set property {} as it does not exist in {}", new Object[]{property, this.field_12287});
                this.withMissingOwner = ownerString;
            }
        } else if (!this.withDisallowedOwner.equals(ownerString)) {
            Statement.LOGGER.info("Cannot set property {} to {} on {}, it is not an allowed value", new Object[]{property, value, this.field_12287});
            this.withDisallowedOwner = ownerString;
        }
        info.setReturnValue((Object)this);
    }

    @Inject(at={@At(value="HEAD")}, method={"method_11571"}, remap=false)
    private void onCreateWithTable(Map<Map<class_2769<?>, Comparable<?>>, S> map, CallbackInfo info) {
        this.field_12288 = null;
    }

    @Shadow(remap=false)
    abstract void method_11571(Map<Map<class_2769<?>, Comparable<?>>, ?> var1);

    @Override
    public void statement_createWithTable(Map<Map<class_2769<?>, Comparable<?>>, ?> states) {
        this.method_11571(states);
    }

    @Shadow(remap=false)
    abstract ImmutableMap<class_2769<?>, Comparable<?>> method_11656();

    @Override
    public ImmutableMap<class_2769<?>, Comparable<?>> statement_getEntries() {
        return this.method_11656();
    }

    @Shadow
    abstract <T extends Comparable<T>, V extends T> S method_11657(class_2769<T> var1, V var2);

    @Override
    public <T extends Comparable<T>, V extends T> S statement_with(class_2769<T> property, V value) {
        return this.method_11657(property, value);
    }

    @Override
    public <V extends Comparable<V>> boolean statement_addEntry(class_2769<V> property, V value) {
        if (!this.field_12285.containsKey(property)) {
            this.statement_setEntries(ImmutableMap.builder().putAll(this.field_12285).put(property, value).build());
            return true;
        }
        return false;
    }

    @Override
    public <V extends Comparable<V>> boolean statement_removeEntry(class_2769<V> property) {
        if (this.field_12285.containsKey(property)) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : this.field_12285.entrySet()) {
                class_2769 key = (class_2769)entry.getKey();
                if (key == property) continue;
                builder.put((Object)key, (Object)((Comparable)entry.getValue()));
            }
            this.cachedFallbacks.put(property, (Comparable)this.field_12285.get(property));
            this.statement_setEntries(builder.build());
            return true;
        }
        return false;
    }

    @Override
    public void statement_setEntries(ImmutableMap<class_2769<?>, Comparable<?>> entries) {
        this.field_12285 = HydrogenCompatibility.INSTANCE.wrapEntries(entries);
    }
}

