/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.mixin.compat116plus;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2688;
import net.minecraft.class_2769;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import virtuoel.statement.Statement;
import virtuoel.statement.util.HydrogenCompatibility;
import virtuoel.statement.util.StatementStateExtensions;

@Mixin(value={class_2688.class})
public abstract class StateMixin<O, S>
implements StatementStateExtensions<S> {
    @Shadow
    @Final
    @Mutable
    protected O field_24739;
    @Shadow
    @Final
    @Mutable
    private ImmutableMap<class_2769<?>, Comparable<?>> field_24738;
    @Shadow
    private Table<class_2769<?>, Comparable<?>, S> field_24741;
    @Shadow
    @Final
    @Mutable
    MapCodec<S> field_24740;
    @Unique
    String getMissingOwner = "";
    @Unique
    String withMissingOwner = "";
    @Unique
    String withDisallowedOwner = "";
    @Unique
    final Map<class_2769<?>, Comparable<?>> cachedFallbacks = new HashMap();

    @Inject(method={"get"}, cancellable=true, at={@At(value="INVOKE", target="Ljava/lang/IllegalArgumentException;<init>(Ljava/lang/String;)V")})
    private <T extends Comparable<T>> void onGet(class_2769<T> property, CallbackInfoReturnable<T> info) {
        String ownerString = this.field_24739.toString();
        if (!this.getMissingOwner.equals(ownerString)) {
            Statement.LOGGER.info("Cannot get property {} as it does not exist in {}", new Object[]{property, this.field_24739});
            this.getMissingOwner = ownerString;
        }
        info.setReturnValue((Object)(this.cachedFallbacks.containsKey(property) ? (Comparable)property.method_11902().cast(this.cachedFallbacks.get(property)) : (Comparable)property.method_11898().iterator().next()));
    }

    @Inject(method={"with"}, cancellable=true, at={@At(value="INVOKE", target="Ljava/lang/IllegalArgumentException;<init>(Ljava/lang/String;)V")})
    private <T extends Comparable<T>, V extends T> void onWith(class_2769<T> property, V value, CallbackInfoReturnable<Object> info) {
        String ownerString = this.field_24739.toString();
        if (this.field_24738.get(property) == null) {
            if (!this.withMissingOwner.equals(ownerString)) {
                Statement.LOGGER.info("Cannot set property {} as it does not exist in {}", new Object[]{property, this.field_24739});
                this.withMissingOwner = ownerString;
            }
        } else if (!this.withDisallowedOwner.equals(ownerString)) {
            Statement.LOGGER.info("Cannot set property {} to {} on {}, it is not an allowed value", new Object[]{property, value, this.field_24739});
            this.withDisallowedOwner = ownerString;
        }
        info.setReturnValue((Object)this);
    }

    @Inject(at={@At(value="HEAD")}, method={"createWithTable"})
    private void onCreateWithTable(Map<Map<class_2769<?>, Comparable<?>>, S> map, CallbackInfo info) {
        this.field_24741 = null;
    }

    @Shadow
    abstract void method_28496(Map<Map<class_2769<?>, Comparable<?>>, ?> var1);

    @Override
    public void statement_createWithTable(Map<Map<class_2769<?>, Comparable<?>>, ?> states) {
        this.method_28496(states);
    }

    @Shadow
    abstract ImmutableMap<class_2769<?>, Comparable<?>> method_11656();

    @Override
    public ImmutableMap<class_2769<?>, Comparable<?>> statement_getEntries() {
        return this.method_11656();
    }

    @Shadow
    abstract <T extends Comparable<T>, V extends T> S method_11657(class_2769<T> var1, V var2);

    @Override
    public <T extends Comparable<T>, V extends T> S statement_with(class_2769<T> property, V value) {
        return this.method_11657(property, value);
    }

    @Override
    public <V extends Comparable<V>> boolean statement_addEntry(class_2769<V> property, V value) {
        if (!this.field_24738.containsKey(property)) {
            this.statement_setEntries(ImmutableMap.builder().putAll(this.field_24738).put(property, value).build());
            return true;
        }
        return false;
    }

    @Override
    public <V extends Comparable<V>> boolean statement_removeEntry(class_2769<V> property) {
        if (this.field_24738.containsKey(property)) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : this.field_24738.entrySet()) {
                class_2769 key = (class_2769)entry.getKey();
                if (key == property) continue;
                builder.put((Object)key, (Object)((Comparable)entry.getValue()));
            }
            this.cachedFallbacks.put(property, (Comparable)this.field_24738.get(property));
            this.statement_setEntries(builder.build());
            return true;
        }
        return false;
    }

    @Override
    public void statement_setEntries(ImmutableMap<class_2769<?>, Comparable<?>> entries) {
        this.field_24738 = HydrogenCompatibility.INSTANCE.wrapEntries(entries);
    }

    @Override
    public Object statement_getCodec() {
        return this.field_24740;
    }

    @Override
    public void statement_setCodec(Object codec) {
        this.field_24740 = (MapCodec)codec;
    }
}

