/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.util;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.netty.buffer.Unpooled;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryAttributeHolder;
import net.fabricmc.fabric.api.event.registry.RegistryIdRemapCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2248;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2361;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2688;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.MixinEnvironment;
import virtuoel.kanos_config.api.InvalidatableLazySupplier;
import virtuoel.statement.Statement;
import virtuoel.statement.api.StateRefresher;
import virtuoel.statement.util.CommandUtils;
import virtuoel.statement.util.ModLoaderUtils;
import virtuoel.statement.util.RegistryUtils;
import virtuoel.statement.util.StatementBlockStateExtensions;
import virtuoel.statement.util.StatementFluidStateExtensions;
import virtuoel.statement.util.StatementPropertyExtensions;
import virtuoel.statement.util.StatementStateExtensions;
import virtuoel.statement.util.VersionUtils;

public class FabricApiCompatibility {
    private static final BooleanSupplier NETWORKING_LOADED = () -> ((InvalidatableLazySupplier)InvalidatableLazySupplier.of(() -> ModLoaderUtils.isModLoaded("fabric-networking-api-v1"))).get();
    private static final Function<String, Object> LITERAL = class_2585::new;

    public static void registerCommands() {
        if (ModLoaderUtils.isModLoaded("fabric-command-api-v2")) {
            V2ApiClassloading.registerV2ApiCommands();
        } else if (ModLoaderUtils.isModLoaded("fabric-command-api-v1")) {
            FabricApiCompatibility.registerV1ApiCommands();
        }
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        FabricApiCompatibility.register(dispatcher);
    }

    private static void registerV1ApiCommands() {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Method staticRegister = FabricApiCompatibility.class.getDeclaredMethod("registerV1ApiCommands", CommandDispatcher.class, Boolean.TYPE);
            MethodHandle staticRegisterHandle = lookup.unreflect(staticRegister);
            MethodType staticRegisterType = staticRegisterHandle.type();
            Class<?> callbackClass = Class.forName("net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback");
            Event registerEvent = (Event)callbackClass.getField("EVENT").get(null);
            Method register = callbackClass.getDeclaredMethod("register", CommandDispatcher.class, Boolean.TYPE);
            MethodType registerType = MethodType.methodType(register.getReturnType(), register.getParameterTypes());
            MethodType factoryMethodType = MethodType.methodType(callbackClass);
            CallSite lambdaFactory = LambdaMetafactory.metafactory(lookup, "register", factoryMethodType, registerType, staticRegisterHandle, staticRegisterType);
            MethodHandle factoryInvoker = lambdaFactory.getTarget();
            Object eventLambda = factoryInvoker.asType(factoryMethodType).invokeWithArguments(Collections.emptyList());
            registerEvent.register(eventLambda);
        }
        catch (Throwable e) {
            Statement.LOGGER.catching(e);
        }
    }

    protected static void registerV1ApiCommands(CommandDispatcher<class_2168> dispatcher, boolean dedicated) {
        FabricApiCompatibility.registerCommands(dispatcher);
    }

    public static void register(CommandDispatcher<class_2168> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"statement").requires(commandSource -> commandSource.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"validate").then(FabricApiCompatibility.stateValidationArgument("block_state", Statement.BLOCK_STATE_VALIDATION_PACKET))).then(FabricApiCompatibility.stateValidationArgument("fluid_state", Statement.FLUID_STATE_VALIDATION_PACKET)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"get_id").then(FabricApiCompatibility.idGetterArgument("block_state", class_2248.field_10651, class_1922::method_8320, RegistryUtils.BLOCK_REGISTRY, s -> ((StatementBlockStateExtensions)s).statement_getBlock()))).then(FabricApiCompatibility.idGetterArgument("fluid_state", class_3611.field_15904, class_1922::method_8316, RegistryUtils.FLUID_REGISTRY, s -> ((StatementFluidStateExtensions)s).statement_getFluid()))));
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"statement").requires(commandSource -> commandSource.method_9259(2))).then(class_2170.method_9247((String)"debug").then(class_2170.method_9247((String)"run_mixin_tests").executes(context -> {
                MixinEnvironment.getCurrentEnvironment().audit();
                return 1;
            }))));
        }
    }

    private static <O, S extends class_2688<O, S>> ArgumentBuilder<class_2168, ?> idGetterArgument(String argumentName, class_2361<S> idList, BiFunction<class_3218, class_2338, S> stateFunc, class_2378<O> registry, Function<S, O> entryFunction) {
        return class_2170.method_9247((String)argumentName).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(context -> {
            class_2338 pos = class_2262.method_9696((CommandContext)context, (String)"pos");
            class_2688 state = (class_2688)stateFunc.apply(((class_2168)context.getSource()).method_9225(), pos);
            ImmutableMap<class_2769<?>, Comparable<?>> entries = ((StatementStateExtensions)state).statement_getEntries();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(RegistryUtils.getId(registry, entryFunction.apply(state)));
            if (!entries.isEmpty()) {
                stringBuilder.append('[');
                stringBuilder.append(entries.entrySet().stream().map(entry -> {
                    StatementPropertyExtensions property = (StatementPropertyExtensions)entry.getKey();
                    return property.statement_getName() + "=" + property.statement_name(entry.getValue());
                }).collect(Collectors.joining(",")));
                stringBuilder.append(']');
            }
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> FabricApiCompatibility.literal("%s (%d) @ %d, %d, %d", stringBuilder.toString(), idList.method_10206((Object)state), pos.method_10263(), pos.method_10264(), pos.method_10260()), false);
            return 1;
        }));
    }

    private static ArgumentBuilder<class_2168, ?> stateValidationArgument(String argumentName, class_2960 packetId) {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)argumentName).executes(context -> FabricApiCompatibility.executeValidation((CommandContext<class_2168>)context, packetId, ((class_2168)context.getSource()).method_9207(), 100, 0))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> FabricApiCompatibility.executeValidation((CommandContext<class_2168>)context, packetId, class_2186.method_9315((CommandContext)context, (String)"player"), 100, 0))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"rate", (ArgumentType)IntegerArgumentType.integer((int)1, (int)class_2248.field_10651.method_10204())).executes(context -> FabricApiCompatibility.executeValidation((CommandContext<class_2168>)context, packetId, class_2186.method_9315((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"rate"), 0))).then(class_2170.method_9244((String)"start_id", (ArgumentType)IntegerArgumentType.integer((int)0, (int)(class_2248.field_10651.method_10204() - 1))).executes(context -> FabricApiCompatibility.executeValidation((CommandContext<class_2168>)context, packetId, class_2186.method_9315((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"rate"), IntegerArgumentType.getInteger((CommandContext)context, (String)"start_id"))))));
    }

    private static int executeValidation(CommandContext<class_2168> context, class_2960 packetId, class_3222 player, int rate, int initialId) throws CommandSyntaxException {
        if (NETWORKING_LOADED.getAsBoolean()) {
            if (ServerPlayNetworking.canSend((class_3222)player, (class_2960)packetId)) {
                class_3222 executor = ((class_2168)context.getSource()).method_9207();
                class_2540 buffer = new class_2540(Unpooled.buffer()).method_10797(executor.method_5667()).method_10804(rate);
                for (int i = 0; i < rate; ++i) {
                    buffer.method_10804(initialId + i);
                }
                CommandUtils.sendFeedback((class_2168)context.getSource(), () -> FabricApiCompatibility.literal("Running state validation...", new Object[0]), false);
                ServerPlayNetworking.send((class_3222)player, (class_2960)packetId, (class_2540)buffer);
                return 1;
            }
            CommandUtils.sendFeedback((class_2168)context.getSource(), () -> FabricApiCompatibility.literal("Error: Target player cannot receive state validation packet.", new Object[0]), false);
            return 0;
        }
        CommandUtils.sendFeedback((class_2168)context.getSource(), () -> FabricApiCompatibility.literal("Fabric Networking not found on server.", new Object[0]), false);
        return 0;
    }

    public static void setupServerNetworking() {
        FabricApiCompatibility.setupServerStateValidation(Statement.BLOCK_STATE_VALIDATION_PACKET, class_2248.field_10651, class_2512::method_10686);
        FabricApiCompatibility.setupServerStateValidation(Statement.FLUID_STATE_VALIDATION_PACKET, class_3611.field_15904, FabricApiCompatibility::fromFluidState);
    }

    public static <S> void setupServerStateValidation(class_2960 packetId, class_2361<S> stateIdList, Function<S, class_2487> stateToNbtFunction) {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)packetId, (server, player, handler, buf, responseSender) -> {
            UUID uuid = buf.method_10790();
            int idQuantity = buf.method_10816();
            if (idQuantity == 0) {
                return;
            }
            int[] ids = new int[idQuantity];
            String[] snbts = new String[idQuantity];
            for (int i = 0; i < idQuantity; ++i) {
                ids[i] = buf.method_10816();
                snbts[i] = buf.method_10800(Short.MAX_VALUE);
            }
            server.execute(() -> {
                class_1657 executor = player.method_5770().method_18470(uuid);
                if (!executor.method_5715()) {
                    boolean idsFound = false;
                    boolean done = false;
                    for (int i = 0; i < idQuantity; ++i) {
                        Object state = stateIdList.method_10200(ids[i]);
                        try {
                            class_2487 sentData = class_2522.method_10718((String)snbts[i]);
                            String sentName = sentData.method_10558("Name");
                            StringBuilder sentStringBuilder = new StringBuilder();
                            sentStringBuilder.append(sentName);
                            if (sentData.method_10573("Properties", 10)) {
                                sentStringBuilder.append('[');
                                class_2487 properties = sentData.method_10562("Properties");
                                sentStringBuilder.append(properties.method_10541().stream().map(key -> key + "=" + properties.method_10558(key)).collect(Collectors.joining(",")));
                                sentStringBuilder.append(']');
                            }
                            if (state != null) {
                                class_2487 ownData = (class_2487)stateToNbtFunction.apply(state);
                                int total = stateIdList.method_10204();
                                float percent = (float)(ids[i] + 1) / (float)total * 100.0f;
                                if (sentData.equals((Object)ownData)) {
                                    executor.method_7353(FabricApiCompatibility.literal("ID %d matched (%d/%d: %.2f%%):\n%s", ids[i], ids[i] + 1, total, Float.valueOf(percent), sentStringBuilder.toString()), false);
                                } else {
                                    String ownName = ownData.method_10558("Name");
                                    StringBuilder ownStringBuilder = new StringBuilder();
                                    ownStringBuilder.append(ownName);
                                    if (ownData.method_10573("Properties", 10)) {
                                        ownStringBuilder.append('[');
                                        class_2487 properties = ownData.method_10562("Properties");
                                        ownStringBuilder.append(properties.method_10541().stream().map(key -> key + "=" + properties.method_10558(key)).collect(Collectors.joining(",")));
                                        ownStringBuilder.append(']');
                                    }
                                    if (sentName.equals(ownName)) {
                                        executor.method_7353(FabricApiCompatibility.literal("ID %d partially matched (%d/%d: %.2f%%):\nServer state:\n%s\nClient state:\n%s", ids[i], ids[i] + 1, total, Float.valueOf(percent), ownStringBuilder.toString(), sentStringBuilder.toString()), false);
                                    } else {
                                        executor.method_7353(FabricApiCompatibility.literal("ID %d mismatched (%d/%d: %.2f%%)!\nServer state:\n%s\nClient state:\n%s", ids[i], ids[i] + 1, total, Float.valueOf(percent), ownStringBuilder.toString(), sentStringBuilder.toString()), false);
                                    }
                                }
                                idsFound = true;
                                continue;
                            }
                            executor.method_7353(FabricApiCompatibility.literal("Received ID %d not found on server.\nClient state:\n%s", ids[i], sentStringBuilder.toString()), false);
                            continue;
                        }
                        catch (CommandSyntaxException e) {
                            if (state == null) {
                                executor.method_7353(FabricApiCompatibility.literal("Done matching after " + ids[i] + " states.", new Object[0]), false);
                                done = true;
                                break;
                            }
                            executor.method_7353(FabricApiCompatibility.literal("Failed to parse received state from SNBT:\n" + snbts[i], new Object[0]), false);
                        }
                    }
                    if (!done && idsFound) {
                        if (ServerPlayNetworking.canSend((class_3222)player, (class_2960)packetId)) {
                            class_2540 buffer = new class_2540(Unpooled.buffer()).method_10797(uuid).method_10804(idQuantity);
                            for (int i = 0; i < idQuantity; ++i) {
                                buffer.method_10804(ids[i] + idQuantity);
                            }
                            ServerPlayNetworking.send((class_3222)player, (class_2960)packetId, (class_2540)buffer);
                        } else {
                            executor.method_7353(FabricApiCompatibility.literal("Error: Target player cannot receive state validation packet.", new Object[0]), false);
                        }
                    }
                }
            });
        });
    }

    private static class_2561 literal(String value, Object ... args) {
        if (VersionUtils.MINOR < 19) {
            return (class_2561)LITERAL.apply(String.format(value, args));
        }
        return class_2561.method_43470((String)String.format(value, args));
    }

    public static void setupClientNetworking() {
        Client.setupClientStateValidation(Statement.BLOCK_STATE_VALIDATION_PACKET, class_2248.field_10651, class_2512::method_10686);
        Client.setupClientStateValidation(Statement.FLUID_STATE_VALIDATION_PACKET, class_3611.field_15904, FabricApiCompatibility::fromFluidState);
    }

    public static class_2487 fromFluidState(class_3610 state) {
        return FabricApiCompatibility.fromState(RegistryUtils.FLUID_REGISTRY, s -> ((StatementFluidStateExtensions)s).statement_getFluid(), state);
    }

    public static <S extends class_2688<?, S>, E> class_2487 fromState(class_2378<E> registry, Function<S, E> entryFunction, S state) {
        class_2487 compound = new class_2487();
        compound.method_10582("Name", RegistryUtils.getId(registry, entryFunction.apply(state)).toString());
        ImmutableMap<class_2769<?>, Comparable<?>> entries = ((StatementStateExtensions)state).statement_getEntries();
        if (!entries.isEmpty()) {
            class_2487 properties = new class_2487();
            for (Map.Entry entry : entries.entrySet()) {
                StatementPropertyExtensions property = (StatementPropertyExtensions)entry.getKey();
                String valueName = property.statement_name(entry.getValue());
                properties.method_10582(property.statement_getName(), valueName);
            }
            compound.method_10566("Properties", (class_2520)properties);
        }
        return compound;
    }

    public static void markRegistryAsModded(class_2378<?> registry) {
        if (VersionUtils.MINOR >= 16) {
            RegistryAttributeHolder.get(registry).addAttribute(RegistryAttribute.MODDED);
        }
    }

    public static void setupIdRemapCallbacks() {
        RegistryIdRemapCallback.event(RegistryUtils.BLOCK_REGISTRY).register(s -> StateRefresher.INSTANCE.reorderBlockStates());
        RegistryIdRemapCallback.event(RegistryUtils.FLUID_REGISTRY).register(s -> StateRefresher.INSTANCE.reorderFluidStates());
    }

    private static class V2ApiClassloading {
        private V2ApiClassloading() {
        }

        private static void registerV2ApiCommands() {
            CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, dedicated) -> FabricApiCompatibility.registerCommands((CommandDispatcher<class_2168>)dispatcher));
        }
    }

    private static class Client {
        private Client() {
        }

        public static <S> void setupClientStateValidation(class_2960 packetId, class_2361<S> stateIdList, Function<S, class_2487> stateToNbtFunction) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)packetId, (client, handler, buf, responseSender) -> {
                class_746 player = client.field_1724;
                UUID uuid = buf.method_10790();
                int idQuantity = buf.method_10816();
                if (idQuantity == 0) {
                    return;
                }
                int[] ids = new int[idQuantity];
                for (int i = 0; i < idQuantity; ++i) {
                    ids[i] = buf.method_10816();
                }
                client.execute(() -> {
                    if (!player.method_5715()) {
                        class_2540 buffer = new class_2540(Unpooled.buffer()).method_10797(uuid).method_10804(idQuantity);
                        for (int i = 0; i < idQuantity; ++i) {
                            Object state = stateIdList.method_10200(ids[i]);
                            String snbt = state == null ? "No state found on client for ID " + ids[i] : ((class_2487)stateToNbtFunction.apply(state)).toString();
                            buffer.method_10804(ids[i]).method_10814(snbt);
                        }
                        ClientPlayNetworking.send((class_2960)packetId, (class_2540)buffer);
                    }
                });
            });
        }
    }
}

