/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2688;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;
import virtuoel.statement.api.compatibility.FoamFixCompatibility;
import virtuoel.statement.util.ModLoaderUtils;

public class FoamFixCompatibilityImpl
implements FoamFixCompatibility {
    private static final boolean FOAMFIX_LOADED = ModLoaderUtils.isModLoaded("foamfix");
    private final Optional<Class<?>> orderingClass;
    private final Optional<Class<?>> factoryClass;
    private final Optional<Class<?>> stateClass;
    private final Optional<Class<?>> valueMapperClass;
    private final Optional<Map<class_2769<?>, ?>> propertyEntryMap;
    private final Optional<Field> factoryMapper;
    private final Optional<Field> stateOwner;
    private boolean enabled = FOAMFIX_LOADED;

    public FoamFixCompatibilityImpl() {
        if (this.enabled) {
            this.orderingClass = FoamFixCompatibilityImpl.getClass("pl.asie.foamfix.state.PropertyOrdering");
            this.factoryClass = FoamFixCompatibilityImpl.getClass("pl.asie.foamfix.state.FoamyStateFactory$Factory");
            this.stateClass = FoamFixCompatibilityImpl.getClass("pl.asie.foamfix.state.FoamyBlockStateMapped");
            this.valueMapperClass = FoamFixCompatibilityImpl.getClass("pl.asie.foamfix.state.PropertyValueMapperImpl");
            this.propertyEntryMap = FoamFixCompatibilityImpl.getField(this.orderingClass, "entryMap").map(f -> {
                try {
                    Map map = (Map)f.get(null);
                    return map;
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    return null;
                }
            });
            this.factoryMapper = FoamFixCompatibilityImpl.getField(this.factoryClass, "mapper");
            this.stateOwner = FoamFixCompatibilityImpl.getField(this.stateClass, "owner");
        } else {
            this.orderingClass = Optional.empty();
            this.factoryClass = Optional.empty();
            this.stateClass = Optional.empty();
            this.valueMapperClass = Optional.empty();
            this.propertyEntryMap = Optional.empty();
            this.factoryMapper = Optional.empty();
            this.stateOwner = Optional.empty();
        }
    }

    @Override
    public void enable() {
        this.enabled = FOAMFIX_LOADED;
    }

    @Override
    public void disable() {
        this.enabled = false;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void removePropertyFromEntryMap(class_2769<?> property) {
        if (this.isEnabled()) {
            this.propertyEntryMap.ifPresent(map -> map.remove(property));
        }
    }

    @Override
    public Optional<Object> constructPropertyValueMapper(Collection<class_2769<?>> properties) {
        if (this.isEnabled()) {
            return this.valueMapperClass.map(c -> FoamFixCompatibilityImpl.constructPropertyValueMapper(c, properties));
        }
        return Optional.empty();
    }

    @Nullable
    private static Object constructPropertyValueMapper(Class<?> clazz, Collection<class_2769<?>> properties) {
        try {
            return clazz.getConstructor(Collection.class).newInstance(properties);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return null;
        }
    }

    @Override
    public void setFactoryMapper(Optional<?> factory, Optional<?> mapper) {
        if (this.isEnabled()) {
            mapper.ifPresent(m -> factory.ifPresent(f -> this.factoryClass.filter(c -> c.isInstance(f)).flatMap(c -> this.factoryMapper).ifPresent(field -> {
                try {
                    field.set(f, m);
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    // empty catch block
                }
            })));
        }
    }

    @Override
    public void setStateOwner(class_2688<?, ?> state, Optional<?> owner) {
        if (this.isEnabled()) {
            owner.ifPresent(o -> this.stateClass.filter(c -> c.isInstance(state)).flatMap(c -> this.stateOwner).ifPresent(f -> {
                try {
                    f.set(state, o);
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    // empty catch block
                }
            }));
        }
    }

    private static Optional<Field> getField(Optional<Class<?>> classObj, String fieldName) {
        return classObj.map(c -> {
            try {
                Field f = c.getDeclaredField(fieldName);
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException | SecurityException exception) {
                return null;
            }
        });
    }

    private static Optional<Class<?>> getClass(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Optional.empty();
        }
    }
}

