/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.util;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import virtuoel.statement.util.ModLoaderUtils;

public class HydrogenCompatibility {
    private static final boolean HYDROGEN_LOADED = ModLoaderUtils.isModLoaded("hydrogen");
    public static final HydrogenCompatibility INSTANCE = new HydrogenCompatibility();
    private final Optional<Class<?>> classConstructorsClass;
    private final Optional<Method> createFastImmutableMap;
    private boolean enabled = HYDROGEN_LOADED;

    public HydrogenCompatibility() {
        if (this.enabled) {
            this.classConstructorsClass = HydrogenCompatibility.getClass("me.jellysquid.mods.hydrogen.common.jvm.ClassConstructors");
            this.createFastImmutableMap = HydrogenCompatibility.getMethod(this.classConstructorsClass, "createFastImmutableMap", new Class[0]);
        } else {
            this.classConstructorsClass = Optional.empty();
            this.createFastImmutableMap = Optional.empty();
        }
    }

    public <K, V> ImmutableMap<K, V> wrapEntries(ImmutableMap<K, V> entries) {
        if (this.enabled) {
            return this.createFastImmutableMap.map(m -> {
                try {
                    return (ImmutableMap)m.invoke(null, entries);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    return null;
                }
            }).orElse(entries);
        }
        return entries;
    }

    private static Optional<Method> getMethod(Optional<Class<?>> classObj, String methodName, Class<?> ... args) {
        return classObj.map(c -> {
            try {
                Method m = c.getMethod(methodName, args);
                m.setAccessible(true);
                return m;
            }
            catch (NoSuchMethodException | SecurityException exception) {
                return null;
            }
        });
    }

    private static Optional<Class<?>> getClass(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Optional.empty();
        }
    }
}

