/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;

public final class ReflectionUtils {
    public static Optional<Field> getField(Optional<Class<?>> classObj, String fieldName) {
        return classObj.map(c -> {
            try {
                Field f = c.getDeclaredField(fieldName);
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException | SecurityException e) {
                return null;
            }
        });
    }

    public static <T> T getFieldValue(Optional<Class<?>> classObj, String fieldName, Object object, T defaultValue) {
        return ReflectionUtils.getField(classObj, fieldName).map(f -> {
            try {
                return f.get(object);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                return defaultValue;
            }
        }).orElse(null);
    }

    public static void setField(Optional<Class<?>> classObj, String fieldName, Object object, Object value) {
        ReflectionUtils.getField(classObj, fieldName).ifPresent(f -> {
            try {
                f.set(object, value);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        });
    }

    public static Optional<Method> getMethod(Optional<Class<?>> classObj, String methodName, Class<?> ... args) {
        return classObj.map(c -> {
            try {
                Method m = c.getMethod(methodName, args);
                m.setAccessible(true);
                return m;
            }
            catch (NoSuchMethodException | SecurityException e) {
                return null;
            }
        });
    }

    public static Optional<Class<?>> getClass(String className, String ... classNames) {
        Optional<Class<?>> ret = ReflectionUtils.getClass(className);
        for (String name : classNames) {
            if (ret.isPresent()) {
                return ret;
            }
            ret = ReflectionUtils.getClass(name);
        }
        return ret;
    }

    public static Optional<Class<?>> getClass(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    private ReflectionUtils() {
    }
}

