/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2348;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_7922;
import virtuoel.statement.Statement;
import virtuoel.statement.util.VersionUtils;

public class RegistryUtils {
    public static final MethodHandle REGISTER;
    public static final MethodHandle GET;
    public static final MethodHandle GET_ID;
    public static final MethodHandle GET_RAW_ID;
    public static final MethodHandle GET_OR_EMPTY;
    public static final MethodHandle GET_DEFAULT_ID;
    public static final class_2378<class_2248> BLOCK_REGISTRY;
    public static final class_2378<class_1792> ITEM_REGISTRY;
    public static final class_2378<class_3611> FLUID_REGISTRY;

    private static <T> class_2378<T> castRegistry(Object obj) {
        return (class_2378)obj;
    }

    public static <V, T extends V> T register(class_2378<V> registry, class_2960 id, T entry) {
        try {
            return (T)REGISTER.invoke(registry, id, entry);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <V> V get(class_2378<V> registry, class_2960 id) {
        try {
            return (V)GET.invoke(registry, id);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <V> class_2960 getId(class_2378<V> registry, V entry) {
        try {
            return GET_ID.invoke(registry, entry);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <V> int getRawId(class_2378<V> registry, V entry) {
        try {
            if (VersionUtils.MINOR <= 15) {
                return GET_RAW_ID.invoke(registry, entry);
            }
            return GET_RAW_ID.invoke((class_2359)registry, entry);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <V> Optional<V> getOrEmpty(class_2378<V> registry, class_2960 id) {
        try {
            return GET_OR_EMPTY.invoke(registry, id);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <V> class_2960 getDefaultId(class_2378<V> registry) {
        try {
            if (VersionUtils.MINOR < 19 || VersionUtils.MINOR == 19 && VersionUtils.PATCH <= 2) {
                if (registry instanceof class_2348) {
                    return GET_DEFAULT_ID.invoke((class_2348)registry);
                }
            } else if (registry instanceof class_7922) {
                return GET_DEFAULT_ID.invoke((class_7922)registry);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    static {
        MappingResolver mappingResolver = FabricLoader.getInstance().getMappingResolver();
        Int2ObjectArrayMap h = new Int2ObjectArrayMap();
        Object rB = null;
        Object rI = null;
        Object rF = null;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        String mapped = "unset";
        try {
            boolean is115Minus = VersionUtils.MINOR <= 15;
            boolean is1192Minus = VersionUtils.MINOR < 19 || VersionUtils.MINOR == 19 && VersionUtils.PATCH <= 2;
            String registrar = "net.minecraft.class_" + (is1192Minus ? "2378" : "7923");
            mapped = mappingResolver.mapClassName("intermediary", registrar);
            Class<?> clazz = Class.forName(mapped);
            mapped = mappingResolver.mapFieldName("intermediary", registrar, "field_" + (is1192Minus ? "11146" : "41175"), "Lnet/minecraft/class_" + (is1192Minus ? "2348;" : "7922;"));
            Field f = clazz.getField(mapped);
            rB = f.get(null);
            mapped = mappingResolver.mapFieldName("intermediary", registrar, "field_" + (is1192Minus ? "11142" : "41178"), "Lnet/minecraft/class_" + (is1192Minus ? "2348;" : "7922;"));
            f = clazz.getField(mapped);
            rI = f.get(null);
            mapped = mappingResolver.mapFieldName("intermediary", registrar, "field_" + (is1192Minus ? "11154" : "41173"), "Lnet/minecraft/class_" + (is1192Minus ? "2348;" : "7922;"));
            f = clazz.getField(mapped);
            rF = f.get(null);
            mapped = mappingResolver.mapMethodName("intermediary", "net.minecraft.class_2378", "method_10230", "(Lnet/minecraft/class_2378;Lnet/minecraft/class_2960;Ljava/lang/Object;)Ljava/lang/Object;");
            Method m = class_2378.class.getMethod(mapped, class_2378.class, class_2960.class, Object.class);
            h.put(0, (Object)lookup.unreflect(m));
            mapped = mappingResolver.mapMethodName("intermediary", "net.minecraft.class_2378", "method_10223", "(Lnet/minecraft/class_2960;)Ljava/lang/Object;");
            m = class_2378.class.getMethod(mapped, class_2960.class);
            h.put(1, (Object)lookup.unreflect(m));
            mapped = mappingResolver.mapMethodName("intermediary", "net.minecraft.class_2378", "method_10221", "(Ljava/lang/Object;)Lnet/minecraft/class_2960;");
            m = class_2378.class.getMethod(mapped, Object.class);
            h.put(2, (Object)lookup.unreflect(m));
            mapped = mappingResolver.mapMethodName("intermediary", is115Minus ? "net.minecraft.class_2378" : "net.minecraft.class_2359", is115Minus ? "method_10249" : "method_10206", "(Ljava/lang/Object;)I");
            m = (is115Minus ? class_2378.class : class_2359.class).getMethod(mapped, Object.class);
            h.put(3, (Object)lookup.unreflect(m));
            mapped = mappingResolver.mapMethodName("intermediary", "net.minecraft.class_2378", "method_17966", "(Lnet/minecraft/class_2960;)Ljava/util/Optional;");
            m = class_2378.class.getMethod(mapped, class_2960.class);
            h.put(4, (Object)lookup.unreflect(m));
            mapped = mappingResolver.mapMethodName("intermediary", is1192Minus ? "net.minecraft.class_2348" : "net.minecraft.class_7922", "method_10137", "()Lnet/minecraft/class_2960;");
            m = (is1192Minus ? class_2348.class : class_7922.class).getMethod(mapped, new Class[0]);
            h.put(5, (Object)lookup.unreflect(m));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            Statement.LOGGER.error("Current name lookup: {}", new Object[]{mapped});
            Statement.LOGGER.catching((Throwable)e);
        }
        REGISTER = (MethodHandle)h.get(0);
        GET = (MethodHandle)h.get(1);
        GET_ID = (MethodHandle)h.get(2);
        GET_RAW_ID = (MethodHandle)h.get(3);
        GET_OR_EMPTY = (MethodHandle)h.get(4);
        GET_DEFAULT_ID = (MethodHandle)h.get(5);
        BLOCK_REGISTRY = RegistryUtils.castRegistry(rB);
        ITEM_REGISTRY = RegistryUtils.castRegistry(rI);
        FLUID_REGISTRY = RegistryUtils.castRegistry(rF);
    }
}

