/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.statement.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2248;
import net.minecraft.class_2361;
import net.minecraft.class_2378;
import net.minecraft.class_2688;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3611;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.service.MixinService;
import virtuoel.statement.Statement;
import virtuoel.statement.api.ClearableIdList;
import virtuoel.statement.api.RefreshableStateManager;
import virtuoel.statement.api.StateRefresher;
import virtuoel.statement.api.StatementConfig;
import virtuoel.statement.api.compatibility.FoamFixCompatibility;
import virtuoel.statement.api.property.MutableProperty;
import virtuoel.statement.util.ModLoaderUtils;
import virtuoel.statement.util.RegistryUtils;
import virtuoel.statement.util.StatementBlockStateExtensions;
import virtuoel.statement.util.StatementPropertyExtensions;
import virtuoel.statement.util.StatementStateExtensions;

public class StateRefresherImpl
implements StateRefresher {
    private static final ILogger LOGGER = MixinService.getService().getLogger("statement");
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private Boolean parallel = null;

    @Override
    public <O, S extends class_2688<O, S>, V extends Comparable<V>> Collection<S> addProperty(Supplier<class_2689<O, S>> stateManagerGetter, class_2361<S> idList, class_2769<V> property, V defaultValue) {
        RefreshableStateManager manager = (RefreshableStateManager)stateManagerGetter.get();
        manager.statement_addProperty(property, defaultValue);
        StatementPropertyExtensions p = (StatementPropertyExtensions)property;
        List nonDefaultValues = p.statement_getValues().stream().filter(v -> v != defaultValue).collect(Collectors.toList());
        Collection states = manager.statement_reconstructStateList(Collections.singletonMap(property, nonDefaultValues));
        for (class_2688 s : states) {
            idList.method_10205((Object)s);
            ((StatementStateExtensions)s).statement_initShapeCache();
        }
        return states;
    }

    @Override
    public <O, S extends class_2688<O, S>, V extends Comparable<V>> Collection<S> removeProperty(Supplier<class_2689<O, S>> stateManagerGetter, Supplier<S> defaultStateGetter, class_2769<V> property) {
        class_2688 defaultState;
        class_2689<O, S> stateManager = stateManagerGetter.get();
        RefreshableStateManager manager = (RefreshableStateManager)stateManager;
        class_2769 named = stateManager.method_11663(((StatementPropertyExtensions)property).statement_getName());
        if (named != null && (defaultState = (class_2688)defaultStateGetter.get()).method_11656().containsKey((Object)named)) {
            Comparable defaultValue = defaultState.method_11654(named);
            Collection states = stateManager.method_11662().stream().filter(s -> s.method_11654(named) != defaultValue).collect(Collectors.toList());
            if (manager.statement_removeProperty(named)) {
                manager.statement_reconstructStateList(Collections.emptyMap());
            }
            return states;
        }
        return Collections.emptyList();
    }

    @Override
    public <V extends Comparable<V>> void refreshBlockStates(class_2769<V> property, Collection<V> addedValues, Collection<V> removedValues) {
        this.refreshStates((Iterable)RegistryUtils.BLOCK_REGISTRY, (class_2361)class_2248.field_10651, property, addedValues, removedValues, (Function)class_2248::method_9564, (Function)class_2248::method_9595, (Consumer)s -> ((StatementBlockStateExtensions)s).statement_initShapeCache());
        Statement.markRegistryAsModded(RegistryUtils.BLOCK_REGISTRY);
    }

    @Override
    public <V extends Comparable<V>> void refreshFluidStates(class_2769<V> property, Collection<V> addedValues, Collection<V> removedValues) {
        this.refreshStates((Iterable)RegistryUtils.FLUID_REGISTRY, (class_2361)class_3611.field_15904, property, addedValues, removedValues, (Function)class_3611::method_15785, (Function)class_3611::method_15783, (Consumer)f -> {});
        Statement.markRegistryAsModded(RegistryUtils.FLUID_REGISTRY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <O, V extends Comparable<V>, S extends class_2688<O, S>> void refreshStates(Iterable<O> registry, class_2361<S> stateIdList, class_2769<V> property, Collection<V> addedValues, Collection<V> removedValues, Function<O, S> defaultStateGetter, Function<O, class_2689<O, S>> stateManagerGetter, Consumer<S> newStateConsumer) {
        boolean noRemovedValues;
        Statement.invalidateCustomStateData(stateIdList);
        long startTime = System.nanoTime();
        LinkedList<RefreshableStateManager> managersToRefresh = new LinkedList<RefreshableStateManager>();
        for (O entry : registry) {
            if (!((StatementStateExtensions)defaultStateGetter.apply(entry)).statement_getEntries().containsKey(property)) continue;
            RefreshableStateManager manager = (RefreshableStateManager)stateManagerGetter.apply(entry);
            managersToRefresh.add(manager);
        }
        HashMap addedValueMap = new HashMap();
        ConcurrentLinkedQueue addedStates = new ConcurrentLinkedQueue();
        ConcurrentLinkedQueue removedStates = new ConcurrentLinkedQueue();
        LinkedList<CompletionStage> allFutures = new LinkedList<CompletionStage>();
        int entryQuantity = managersToRefresh.size();
        int addedValueQuantity = addedValues.size();
        int removedValueQuantity = removedValues.size();
        boolean noAddedValues = addedValueQuantity == 0;
        boolean bl = noRemovedValues = removedValueQuantity == 0;
        if (noAddedValues && noRemovedValues) {
            LOGGER.debug("Refreshing states of {} entries after {} ns of setup.", new Object[]{entryQuantity, System.nanoTime() - startTime});
        } else if (noAddedValues || noRemovedValues) {
            LOGGER.debug("Refreshing states of {} entries for {} values(s) {} after {} ns of setup.", new Object[]{entryQuantity, noRemovedValues ? "new" : "removed", noRemovedValues ? addedValues : removedValues, System.nanoTime() - startTime});
        } else {
            LOGGER.debug("Refreshing states of {} entries for new values(s) {} and removed value(s) {} after {} ns of setup.", new Object[]{entryQuantity, addedValues, removedValues, System.nanoTime() - startTime});
        }
        class_2769 class_27692 = property;
        synchronized (class_27692) {
            MutableProperty.of(property).ifPresent(mutableProperty -> {
                addedValueMap.put(property, addedValues);
                StatementPropertyExtensions p = (StatementPropertyExtensions)((Object)mutableProperty);
                Collection values = p.statement_getValues();
                values.addAll(addedValues);
                values.removeAll(removedValues);
                FoamFixCompatibility.INSTANCE.removePropertyFromEntryMap(property);
            });
        }
        class_27692 = stateIdList;
        synchronized (class_27692) {
            for (RefreshableStateManager manager : managersToRefresh) {
                allFutures.add(CompletableFuture.supplyAsync(() -> {
                    if (!noRemovedValues) {
                        class_2689 f = (class_2689)manager;
                        f.method_11662().parallelStream().filter(state -> state.method_11656().containsKey((Object)property) && removedValues.contains(state.method_11654(property))).forEach(removedStates::add);
                    }
                    return manager.statement_reconstructStateList(addedValueMap);
                }, EXECUTOR).thenAccept(addedStates::addAll));
            }
            ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])allFutures.stream().toArray(CompletableFuture[]::new)).thenAccept(v -> {
                boolean noRemovals;
                addedStates.forEach(state -> {
                    newStateConsumer.accept(state);
                    stateIdList.method_10205(state);
                });
                int addedStateQuantity = addedStates.size();
                int removedStateQuantity = removedStates.size();
                boolean noAdditions = addedStateQuantity == 0;
                boolean bl = noRemovals = removedStateQuantity == 0;
                if (noAdditions && noRemovals) {
                    LOGGER.debug("Refreshed states with no additions or removals after {} ms.", new Object[]{System.nanoTime() - startTime});
                } else if (noAdditions || noRemovals) {
                    LOGGER.debug("{} {} state(s) for {} values(s) {} after {} ms.", new Object[]{noRemovals ? "Added" : "Removed", noRemovals ? addedStateQuantity : removedStateQuantity, noRemovals ? "new" : "old", noRemovals ? addedValues : removedValues, (System.nanoTime() - startTime) / 1000000L});
                } else {
                    LOGGER.debug("Added {} state(s) for new values(s) {} and removed {} states for old value(s) {} after {} ms.", new Object[]{addedStateQuantity, addedValues, removedStateQuantity, removedValues, (System.nanoTime() - startTime) / 1000000L});
                }
            })).join();
        }
    }

    @Override
    public <O, V extends Comparable<V>, S extends class_2688<O, S>> void reorderStates(Iterable<O> registry, class_2361<S> stateIdList, Function<O, class_2689<O, S>> stateManagerGetter) {
        ObjectCollection entries;
        if (registry instanceof class_2378) {
            Int2ObjectRBTreeMap sortedEntries = new Int2ObjectRBTreeMap();
            for (O entry : registry) {
                sortedEntries.put(RegistryUtils.getRawId((class_2378)registry, entry), entry);
            }
            entries = sortedEntries.values();
        } else {
            entries = registry;
        }
        LinkedList<class_2688> initialStates = new LinkedList<class_2688>();
        LinkedList<class_2688> deferredStates = new LinkedList<class_2688>();
        for (O entry : entries) {
            for (class_2688 state : stateManagerGetter.apply(entry).method_11662()) {
                if (Statement.shouldStateBeDeferred(stateIdList, state)) {
                    deferredStates.add(state);
                    continue;
                }
                initialStates.add(state);
            }
        }
        ((ClearableIdList)stateIdList).statement_clear();
        initialStates.forEach(arg_0 -> stateIdList.method_10205(arg_0));
        deferredStates.forEach(arg_0 -> stateIdList.method_10205(arg_0));
    }

    @Override
    public boolean isParallel() {
        if (this.parallel == null) {
            boolean forceParallelMode = StatementConfig.COMMON.forceParallelMode.get();
            boolean ferriteCoreLoaded = ModLoaderUtils.isModLoaded("ferritecore");
            this.parallel = forceParallelMode || !ferriteCoreLoaded;
        }
        return this.parallel;
    }
}

