/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.aquamirae;

import com.obscuria.aquamirae.AquamiraeUtils;
import com.obscuria.aquamirae.common.DelayedEvents;
import com.obscuria.aquamirae.common.items.RuneOfTheStormItem;
import com.obscuria.aquamirae.common.items.armor.AbyssalArmorItem;
import com.obscuria.aquamirae.common.items.armor.TerribleArmorItem;
import com.obscuria.aquamirae.common.items.weapon.CoralLanceItem;
import com.obscuria.aquamirae.common.items.weapon.FinCutterItem;
import com.obscuria.aquamirae.common.items.weapon.RemnantsSaberItem;
import com.obscuria.aquamirae.registry.AquamiraeBlocks;
import com.obscuria.aquamirae.registry.AquamiraeEffects;
import com.obscuria.aquamirae.registry.AquamiraeEntities;
import com.obscuria.aquamirae.registry.AquamiraeFeatures;
import com.obscuria.aquamirae.registry.AquamiraeItems;
import com.obscuria.aquamirae.registry.AquamiraeParticles;
import com.obscuria.aquamirae.registry.AquamiraePotions;
import com.obscuria.aquamirae.registry.AquamiraeSounds;
import com.obscuria.obscureapi.api.ClassRegistry;
import com.obscuria.obscureapi.api.utils.ItemUtils;
import com.obscuria.obscureapi.common.classes.GameClass;
import com.obscuria.obscureapi.registry.ObscureAPIAttributes;
import com.obscuria.obscureapi.registry.ObscureAPIEnchantments;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.networking.v1.EntityTrackingEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1604;
import net.minecraft.class_1632;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public final class Aquamirae
implements ModInitializer {
    public static final String MODID = "aquamirae";
    public static final String SEA_WOLF_ID = "aquamirae:sea_wolf";
    public static final GameClass SEA_WOLF = ClassRegistry.register((String)"aquamirae", (String)"sea_wolf");
    public static final class_6862<class_1959> ICE_MAZE = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)Aquamirae.key("ice_maze"));
    public static final class_6862<class_3195> SHIP = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)Aquamirae.key("ship"));
    public static final class_6862<class_3195> OUTPOST = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)Aquamirae.key("outpost"));
    public static final class_6862<class_3195> SHELTER = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)Aquamirae.key("shelter"));
    public static final class_6862<class_2248> EEL_MOVE = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)Aquamirae.key("eel_move"));
    public static final class_6862<class_2248> MAZE_MOTHER_DESTROY = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)Aquamirae.key("maze_mother_destroy"));
    public static final class_6862<class_2248> SCROLL_DESTROY = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)Aquamirae.key("scroll_destroy"));

    public void onInitialize() {
        AquamiraeBlocks.register();
        AquamiraeItems.register();
        AquamiraeEntities.register();
        AquamiraeSounds.register();
        AquamiraeFeatures.register();
        AquamiraeParticles.register();
        AquamiraeEffects.register();
        AquamiraePotions.register();
        DelayedEvents.register();
        ObscureAPIEnchantments.registerDistance();
        ObscureAPIEnchantments.registerMirror();
        ObscureAPIEnchantments.registerFastSpin();
        ItemUtils.addLore((String)"aquamirae:sea_casserole");
        ItemUtils.addLore((String)"aquamirae:sea_stew");
        ItemUtils.addLore((String)"aquamirae:poseidons_breakfast");
        ItemUtils.addLore((String)"aquamirae:ship_graveyard_echo");
        ItemUtils.addLore((String)"aquamirae:pirate_pouch");
        ItemUtils.addLore((String)"aquamirae:treasure_pouch");
        ItemUtils.addLore((String)"aquamirae:luminescent_bubble");
        ItemUtils.addLore((String)"aquamirae:luminescent_lamp");
        ItemUtils.addLore((String)"aquamirae:shell_horn");
        ItemUtils.addLore((String)"aquamirae:dead_sea_scroll");
        ItemUtils.addLore((String)"aquamirae:frozen_key");
        ItemUtils.addLore((String)"aquamirae:wisteria_niveis");
        ItemUtils.addLore((String)"aquamirae:golden_moth_in_a_jar");
        ItemUtils.addLore((String)"aquamirae:rune_of_the_storm");
        ItemUtils.addLore((String)"aquamirae:oxygelium");
        EntityTrackingEvents.START_TRACKING.register((entity, player) -> {
            if (entity instanceof class_1604) {
                class_1604 pillager = (class_1604)entity;
                Aquamirae.modifyLootTable((class_1308)pillager, "entities/maze_pillager");
            }
            if (entity instanceof class_1632) {
                class_1632 vindicator = (class_1632)entity;
                Aquamirae.modifyLootTable((class_1308)vindicator, "entities/maze_vindicator");
            }
        });
        ServerLivingEntityEvents.ALLOW_DEATH.register((entity, source, damage) -> ItemUtils.countArmorPieces((class_1309)entity, (Class[])new Class[]{AbyssalArmorItem.class}) < 4 || !AbyssalArmorItem.tryAvoidDeath(entity));
    }

    public static class_2960 key(String key) {
        return new class_2960(MODID, key);
    }

    public static class_1799 createStructureMap(class_6862<class_3195> tag, class_3218 server, class_1297 source) {
        class_2338 pos = server.method_8487(tag, source.method_24515(), 100, false);
        if (pos != null) {
            class_5250 name = tag == SHIP ? class_2561.method_43471((String)"filled_map.aquamirae.ship") : (tag == OUTPOST ? class_2561.method_43471((String)"filled_map.aquamirae.outpost") : (tag == SHELTER ? class_2561.method_43471((String)"filled_map.aquamirae.shelter") : class_2561.method_43471((String)"filled_map.buried_treasure")));
            class_1799 map = class_1806.method_8005((class_1937)server, (int)pos.method_10263(), (int)pos.method_10260(), (byte)2, (boolean)true, (boolean)true);
            class_1806.method_8002((class_3218)server, (class_1799)map);
            class_22.method_110((class_1799)map, (class_2338)pos, (String)"+", (class_20.class_21)class_20.class_21.field_110);
            map.method_7977((class_2561)name);
            class_2487 display = map.method_7948().method_10562("display");
            class_2499 lore = new class_2499();
            lore.add((Object)class_2519.method_23256((String)("{\"text\":\"\u00a77x: " + pos.method_10263() + "\"}")));
            lore.add((Object)class_2519.method_23256((String)("{\"text\":\"\u00a77z: " + pos.method_10260() + "\"}")));
            display.method_10566("Lore", (class_2520)lore);
            map.method_7959("display", (class_2520)display);
            return map;
        }
        return class_1799.field_8037;
    }

    public static boolean isWinterEvent() {
        return Calendar.getInstance().get(2) == 11 || Calendar.getInstance().get(2) == 0;
    }

    public static void modifyLootTable(class_1308 mob, String loot) {
        if (!AquamiraeUtils.isInIceMaze((class_1297)mob) || mob.method_5989().toString().endsWith("captain")) {
            return;
        }
        class_2487 data = new class_2487();
        mob.method_5652(data);
        data.method_10582("DeathLootTable", "aquamirae:" + loot);
        mob.method_5749(data);
    }

    public static void onEntityDamage(class_1309 entity, class_1282 source) {
        int pieces = ItemUtils.countArmorPieces((class_1309)entity, (Class[])new Class[]{TerribleArmorItem.class});
        if (pieces >= 2) {
            TerribleArmorItem.halfSetEffect(entity);
        }
        if (pieces >= 4) {
            TerribleArmorItem.fullSetEffect(entity, source);
        }
    }

    public static float modifyDamage(class_1309 entity, class_1282 source, float amount) {
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1309) {
            class_1309 attacker = (class_1309)class_12972;
            class_1792 item = attacker.method_6047().method_7909();
            if (ItemUtils.hasPerk((class_1799)attacker.method_6047(), (class_2960)Aquamirae.key("rune_of_the_storm"))) {
                amount += RuneOfTheStormItem.calculateDamageBonus(attacker, amount);
            }
            if (item instanceof FinCutterItem) {
                amount += FinCutterItem.calculateDamageBonus(attacker, amount);
            }
            if (item instanceof RemnantsSaberItem) {
                amount += RemnantsSaberItem.calculateDamageBonus(attacker, amount);
            }
            if (item instanceof CoralLanceItem) {
                amount += CoralLanceItem.calculateDamageBonus(attacker, (class_1297)entity, amount);
            }
        }
        return amount;
    }

    public static class SetBuilder {
        @NotNull
        public static List<class_1799> common() {
            int c1 = SetBuilder.getColor(10, 220, 160);
            int c2 = SetBuilder.getColor(10, 190, 220);
            int c3 = SetBuilder.getColor(10, 130, 220);
            ArrayList<class_1799> list = new ArrayList<class_1799>();
            SetBuilder.add(list, class_1802.field_8267, class_1304.field_6169, 1, 1, c1, "dead_sea_hat", class_5134.field_23721);
            SetBuilder.add(list, class_1802.field_8267, class_1304.field_6169, 1, 1, c2, "twilight_grotto_hat", ObscureAPIAttributes.PENETRATION);
            SetBuilder.add(list, class_1802.field_8267, class_1304.field_6169, 1, 1, c3, "sea_tramps_hat", ObscureAPIAttributes.CRITICAL_HIT);
            SetBuilder.add(list, class_1802.field_8577, class_1304.field_6174, 1, 3, c1, "dead_sea_doublet", class_5134.field_23721);
            SetBuilder.add(list, class_1802.field_8577, class_1304.field_6174, 1, 3, c2, "twilight_grotto_doublet", ObscureAPIAttributes.PENETRATION);
            SetBuilder.add(list, class_1802.field_8577, class_1304.field_6174, 1, 3, c3, "sea_tramps_doublet", ObscureAPIAttributes.CRITICAL_HIT);
            SetBuilder.add(list, class_1802.field_8570, class_1304.field_6172, 1, 2, c1, "dead_sea_pants", class_5134.field_23721);
            SetBuilder.add(list, class_1802.field_8570, class_1304.field_6172, 1, 2, c2, "twilight_grotto_pants", ObscureAPIAttributes.PENETRATION);
            SetBuilder.add(list, class_1802.field_8570, class_1304.field_6172, 1, 2, c3, "sea_tramps_pants", ObscureAPIAttributes.CRITICAL_HIT);
            SetBuilder.add(list, class_1802.field_8370, class_1304.field_6166, 1, 1, c1, "dead_sea_boots", class_5134.field_23721);
            SetBuilder.add(list, class_1802.field_8370, class_1304.field_6166, 1, 1, c2, "twilight_grotto_boots", ObscureAPIAttributes.PENETRATION);
            SetBuilder.add(list, class_1802.field_8370, class_1304.field_6166, 1, 1, c3, "sea_tramps_boots", ObscureAPIAttributes.CRITICAL_HIT);
            return list;
        }

        public static List<class_1799> rare() {
            ArrayList<class_1799> list = new ArrayList<class_1799>();
            SetBuilder.add(list, class_1802.field_8743, class_1304.field_6169, 2, 2, 0, "dead_sea_helmet", class_5134.field_23721);
            SetBuilder.add(list, class_1802.field_8743, class_1304.field_6169, 2, 2, 0, "twilight_grotto_helmet", ObscureAPIAttributes.PENETRATION);
            SetBuilder.add(list, class_1802.field_8743, class_1304.field_6169, 2, 2, 0, "sea_tramps_helmet", ObscureAPIAttributes.CRITICAL_HIT);
            SetBuilder.add(list, class_1802.field_8523, class_1304.field_6174, 2, 6, 0, "dead_sea_chestplate", class_5134.field_23721);
            SetBuilder.add(list, class_1802.field_8523, class_1304.field_6174, 2, 6, 0, "twilight_grotto_chestplate", ObscureAPIAttributes.PENETRATION);
            SetBuilder.add(list, class_1802.field_8523, class_1304.field_6174, 2, 6, 0, "sea_tramps_chestplate", ObscureAPIAttributes.CRITICAL_HIT);
            SetBuilder.add(list, class_1802.field_8396, class_1304.field_6172, 2, 5, 0, "dead_sea_leggings", class_5134.field_23721);
            SetBuilder.add(list, class_1802.field_8396, class_1304.field_6172, 2, 5, 0, "twilight_grotto_leggings", ObscureAPIAttributes.PENETRATION);
            SetBuilder.add(list, class_1802.field_8396, class_1304.field_6172, 2, 5, 0, "sea_tramps_leggings", ObscureAPIAttributes.CRITICAL_HIT);
            SetBuilder.add(list, class_1802.field_8660, class_1304.field_6166, 2, 2, 0, "dead_sea_boots", class_5134.field_23721);
            SetBuilder.add(list, class_1802.field_8660, class_1304.field_6166, 2, 2, 0, "twilight_grotto_boots", ObscureAPIAttributes.PENETRATION);
            SetBuilder.add(list, class_1802.field_8660, class_1304.field_6166, 2, 2, 0, "sea_tramps_boots", ObscureAPIAttributes.CRITICAL_HIT);
            return list;
        }

        public static void add(List<class_1799> list, class_1792 item, class_1304 slot, int mod, int armor, int color, String name, class_1320 attribute) {
            for (int i = 1; i <= 5; ++i) {
                class_1799 stack = new class_1799((class_1935)item);
                stack.method_7916(class_5134.field_23724, new class_1322("base_armor", (double)armor, class_1322.class_1323.field_6328), slot);
                stack.method_7916(attribute, new class_1322("base_bonus", (double)(mod * i) * 0.01, class_1322.class_1323.field_6331), slot);
                stack.method_7977((class_2561)class_2561.method_43471((String)("set.aquamirae." + name)));
                if (i == 5) {
                    stack.method_7978(class_1893.field_9119, mod);
                }
                if (color > 0) {
                    stack.method_7911("display").method_10569("color", color);
                }
                list.add(stack);
            }
        }

        public static int getColor(int r, int g, int b) {
            return r * 65536 + g * 256 + b;
        }
    }
}

