/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.chisel;

import com.matthewperiut.chisel.Chisel;
import com.matthewperiut.chisel.block.ChiselGroupLookup;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

@EmiEntrypoint
public class ChiselEMI
implements EmiPlugin {
    private static final ChiselCategory CHISEL_CATEGORY = new ChiselCategory();

    public void register(EmiRegistry registry) {
        registry.addCategory((EmiRecipeCategory)CHISEL_CATEGORY);
        registry.addWorkstation((EmiRecipeCategory)CHISEL_CATEGORY, (EmiIngredient)EmiStack.of((class_1935)((class_1935)Chisel.chiselSupplier.get())));
        Iterator<String> chiselGroupNames = ChiselGroupLookup.getGroupNameIterator();
        while (chiselGroupNames.hasNext()) {
            registry.addRecipe((EmiRecipe)new ChiselEmiRecipe(chiselGroupNames.next()));
        }
    }

    public static class ChiselCategory
    extends EmiRecipeCategory {
        public ChiselCategory() {
            super(new class_2960("chisel", "chisel_recipes_category"), (EmiRenderable)EmiStack.of((class_1935)((class_1935)Chisel.chiselSupplier.get())));
        }

        public class_2561 getName() {
            return class_2561.method_30163((String)class_1074.method_4662((String)"rei.chisel.category", (Object[])new Object[0]));
        }
    }

    public static class ChiselEmiRecipe
    implements EmiRecipe {
        private static final class_2960 TEXTURE = new class_2960("chisel", "textures/rei_recipes.png");
        private final class_2960 id;
        private final List<EmiIngredient> input;
        private final List<EmiStack> output;

        public ChiselEmiRecipe(String chiselGroup) {
            this.id = new class_2960("chisel", chiselGroup);
            this.input = new ArrayList<EmiIngredient>();
            this.output = new ArrayList<EmiStack>();
            for (class_1792 item : ChiselGroupLookup.getBlocksInGroup(chiselGroup)) {
                this.input.add((EmiIngredient)EmiStack.of((class_1935)item));
                this.output.add(EmiStack.of((class_1935)item));
            }
        }

        public EmiRecipeCategory getCategory() {
            return CHISEL_CATEGORY;
        }

        @Nullable
        public class_2960 getId() {
            return this.id;
        }

        public List<EmiIngredient> getInputs() {
            return this.input;
        }

        public List<EmiStack> getOutputs() {
            return this.output;
        }

        public int getDisplayHeight() {
            return 200;
        }

        public int getDisplayWidth() {
            return 150;
        }

        public void addWidgets(WidgetHolder widgets) {
            int startX = 20;
            int startY = 4;
            int j = this.output.size();
            int rows = (int)Math.ceil((double)j / 6.0);
            widgets.addTexture(TEXTURE, 21, 15, 108, 236 - (18 * (10 - rows) + 11), 0, 10);
            widgets.addSlot(this.input.get(0), startX + 46, startY + 17).drawBack(false);
            for (int x = 0; x < 6; ++x) {
                for (int y = 0; y < rows && 6 * y + x < j; ++y) {
                    widgets.addSlot((EmiIngredient)this.output.get(6 * y + x), startX + 1 + 18 * x, startY + 56 + 18 * y).drawBack(false).recipeContext((EmiRecipe)this);
                }
            }
        }
    }
}

