/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.chisel.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ChiselGroupLookup {
    private static final Map<String, ChiselGroup> CHISEL_GROUPS = new HashMap<String, ChiselGroup>();

    private ChiselGroupLookup() {
    }

    public static Iterator<String> getGroupNameIterator() {
        return CHISEL_GROUPS.keySet().iterator();
    }

    public static void addGroup(String name) {
        if (!CHISEL_GROUPS.keySet().contains(name)) {
            CHISEL_GROUPS.put(name, new ChiselGroup());
        }
    }

    public static void addItemToGroup(String name, class_2960 id) {
        if (!CHISEL_GROUPS.keySet().contains(name)) {
            ChiselGroupLookup.addGroup(name);
        }
        CHISEL_GROUPS.get(name).addItem(id);
    }

    public static void addItemToGroup(String name, List<class_2960> id) {
        if (!CHISEL_GROUPS.keySet().contains(name)) {
            ChiselGroupLookup.addGroup(name);
        }
        for (int i = 0; i < id.size(); ++i) {
            CHISEL_GROUPS.get(name).addItem(id.get(i));
        }
    }

    public static void addTagToGroup(String name, class_2960 id) {
        if (!CHISEL_GROUPS.keySet().contains(name)) {
            ChiselGroupLookup.addGroup(name);
        }
        CHISEL_GROUPS.get(name).addTag(id);
    }

    public static void addTagToGroup(String name, List<class_2960> id) {
        if (!CHISEL_GROUPS.keySet().contains(name)) {
            ChiselGroupLookup.addGroup(name);
        }
        for (int i = 0; i < id.size(); ++i) {
            CHISEL_GROUPS.get(name).addTag(id.get(i));
        }
    }

    public static ChiselGroup getGroup(class_1792 item) {
        Iterator<ChiselGroup> chiselGroupIterator = CHISEL_GROUPS.values().iterator();
        class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
        while (chiselGroupIterator.hasNext()) {
            ChiselGroup group = chiselGroupIterator.next();
            if (!group.containsItem(itemId)) continue;
            return group;
        }
        return null;
    }

    public static List<class_1792> getBlocksInGroup(String name) {
        ChiselGroup group = CHISEL_GROUPS.get(name);
        if (group != null) {
            return ChiselGroupLookup.getBlocksInGroup(group);
        }
        return new ArrayList<class_1792>();
    }

    public static List<class_1792> getBlocksInGroup(class_1792 item) {
        ChiselGroup group = ChiselGroupLookup.getGroup(item);
        if (group != null) {
            return ChiselGroupLookup.getBlocksInGroup(group);
        }
        return new ArrayList<class_1792>();
    }

    public static List<class_1792> getBlocksInGroup(ChiselGroup group) {
        ArrayList<class_1792> groupItems = new ArrayList<class_1792>();
        groupItems.addAll(group.getItems());
        return groupItems;
    }

    public static List<class_2960> getTagsFor(class_1792 item) {
        ArrayList<class_2960> tags = new ArrayList<class_2960>();
        return tags;
    }

    public static class ChiselGroup {
        private final List<class_2960> items = new ArrayList<class_2960>();
        private final List<class_2960> tags = new ArrayList<class_2960>();

        public void addItem(class_2960 item) {
            this.items.add(item);
        }

        public void addTag(class_2960 tag) {
            this.tags.add(tag);
        }

        public boolean containsItem(class_2960 item) {
            return this.inItems(item) || this.inTags(item);
        }

        public boolean inItems(class_2960 item) {
            return this.items.contains(item);
        }

        public boolean inTags(class_2960 id) {
            return false;
        }

        public List<class_1792> getItems() {
            ArrayList<class_1792> itemsInGroup = new ArrayList<class_1792>();
            for (int i = 0; i < this.items.size(); ++i) {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(this.items.get(i));
                if (item.equals(class_1802.field_8162)) continue;
                itemsInGroup.add(item);
            }
            ArrayList<class_1792> itemsInGroupNoDupes = new ArrayList<class_1792>();
            for (int i = 0; i < itemsInGroup.size(); ++i) {
                class_1792 item = (class_1792)itemsInGroup.get(i);
                if (itemsInGroupNoDupes.contains(item)) continue;
                itemsInGroupNoDupes.add(item);
            }
            return itemsInGroupNoDupes;
        }
    }
}

