/*
 * Decompiled with CFR 0.152.
 */
package io.toadlabs.numeralping.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.toadlabs.numeralping.NumeralPingMod;
import io.toadlabs.numeralping.config.ColorAdapter;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public final class NumeralConfig {
    public static final NumeralConfig DEFAULTS = new NumeralConfig();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Color.class, (Object)ColorAdapter.INSTANCE).create();
    public boolean playerList = true;
    public boolean serverList = false;
    public boolean smallPing = true;
    public Color defaultPingColour = new Color(65280);
    public Color levelOnePingColour = new Color(0xFFFF00);
    public Color levelTwoPingColour = new Color(16750080);
    public Color levelThreePingColour = new Color(16737280);
    public Color levelFourPingColour;
    public Color levelFivePingColour = this.levelFourPingColour = new Color(0xFF0000);
    public int defaultPingThreshold = 150;
    public int levelOnePingThreshold = 300;
    public int levelTwoPingThreshold = 600;
    public int levelThreePingThreshold = 1000;

    public static NumeralConfig instance() {
        return NumeralPingMod.instance().getConfig();
    }

    public static NumeralConfig read(Path file) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(file, new OpenOption[0]), StandardCharsets.UTF_8);){
            NumeralConfig numeralConfig = (NumeralConfig)GSON.fromJson((Reader)reader, NumeralConfig.class);
            return numeralConfig;
        }
    }

    public void save(Path file) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file, new OpenOption[0]), StandardCharsets.UTF_8);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
    }

    public String shiftPing(String string) {
        if (this.smallPing) {
            char[] characters = new char[string.length()];
            for (int index = 0; index < string.length(); ++index) {
                characters[index] = string.charAt(index);
                if (!Character.isDigit(characters[index])) continue;
                int n = index;
                characters[n] = (char)(characters[n] + 8272);
            }
            return String.valueOf(characters);
        }
        return string;
    }
}

