/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.bases;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.api.util.RarityHelper;
import chronosacaria.mcdw.bases.McdwCustomWeaponBase;
import chronosacaria.mcdw.configs.CompatibilityFlags;
import chronosacaria.mcdw.enums.SpearsID;
import chronosacaria.mcdw.registries.EntityAttributesRegistry;
import chronosacaria.mcdw.registries.ItemGroupRegistry;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.jamieswhiteshirt.reachentityattributes.ReachEntityAttributes;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_5134;
import net.minecraft.class_5150;

public class McdwSpear
extends McdwCustomWeaponBase
implements class_5150,
IInnateEnchantment {
    private final Multimap<class_1320, class_1322> attributeModifiers;
    private final class_1832 material;
    private final float attackDamage;
    String[] repairIngredient;
    SpearsID spearsEnum;

    public McdwSpear(SpearsID spearsEnum, class_1832 material, int attackDamage, float attackSpeed, String[] repairIngredient) {
        super(material, attackDamage, attackSpeed, new class_1792.class_1793().method_7894(RarityHelper.fromToolMaterial(material)));
        ItemGroupEvents.modifyEntriesEvent(ItemGroupRegistry.MELEE).register(entries -> entries.method_45420(this.method_7854()));
        this.spearsEnum = spearsEnum;
        this.material = material;
        this.attackDamage = (float)attackDamage + material.method_8028();
        this.repairIngredient = repairIngredient;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Tool modifier", (double)this.attackDamage, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Tool modifier", (double)attackSpeed, class_1322.class_1323.field_6328));
        if (FabricLoader.getInstance().isModLoaded("reach-entity-attributes") && CompatibilityFlags.isReachExtensionEnabled) {
            Objects.requireNonNull(Mcdw.CONFIG.mcdwNewStatsConfig);
            builder.put((Object)ReachEntityAttributes.REACH, (Object)new class_1322("Attack range", 1.0, class_1322.class_1323.field_6328));
            Objects.requireNonNull(Mcdw.CONFIG.mcdwNewStatsConfig);
            builder.put((Object)ReachEntityAttributes.ATTACK_RANGE, (Object)new class_1322("Attack range", 1.0, class_1322.class_1323.field_6328));
        } else if (CompatibilityFlags.isReachExtensionEnabled) {
            Objects.requireNonNull(Mcdw.CONFIG.mcdwNewStatsConfig);
            builder.put((Object)EntityAttributesRegistry.ATTACK_RANGE, (Object)new class_1322("Attack range", 1.0, class_1322.class_1323.field_6328));
        }
        this.attributeModifiers = builder.build();
    }

    public class_1832 method_8022() {
        return this.material;
    }

    public int method_7837() {
        return this.material.method_8026();
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return CleanlinessHelper.canRepairCheck(this.repairIngredient, ingredient);
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        return !miner.method_7337();
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        stack.method_7956(1, attacker, entity -> entity.method_20235(class_1304.field_6173));
        return true;
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        if (state.method_26214((class_1922)world, pos) != 0.0f) {
            stack.method_7956(2, miner, entity -> entity.method_20235(class_1304.field_6173));
        }
        return true;
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 equipmentSlot) {
        return equipmentSlot == class_1304.field_6173 ? this.attributeModifiers : super.method_7844(equipmentSlot);
    }

    public class_1799 method_7854() {
        return this.getInnateEnchantedStack((class_1792)this);
    }

    @Override
    public Map<class_1887, Integer> getInnateEnchantments() {
        return this.spearsEnum.getInnateEnchantments();
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        super.method_7851(stack, world, tooltip, tooltipContext);
        CleanlinessHelper.mcdw$tooltipHelper(stack, tooltip, 16);
    }
}

