/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.bases.McdwScythe;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.registries.EnchantsRegistry;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1887;
import org.jetbrains.annotations.NotNull;

public enum ScythesID implements IMeleeWeaponID,
IInnateEnchantment
{
    SCYTHE_FROST_SCYTHE((class_1832)class_1834.field_8930, 4, -2.9f, "minecraft:diamond"),
    SCYTHE_JAILORS_SCYTHE((class_1832)class_1834.field_8923, 4, -2.9f, "minecraft:iron_ingot"),
    SCYTHE_SKULL_SCYTHE((class_1832)class_1834.field_8930, 4, -2.9f, "minecraft:diamond"),
    SCYTHE_SOUL_SCYTHE((class_1832)class_1834.field_8930, 3, -2.9f, "minecraft:diamond");

    private final class_1832 material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private ScythesID(class_1832 material, int damage, float attackSpeed, String ... repairIngredient) {
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static HashMap<ScythesID, Boolean> getEnabledItems() {
        return Mcdw.CONFIG.mcdwEnableItemsConfig.SCYTHES_ENABLED;
    }

    public static EnumMap<ScythesID, McdwScythe> getItemsEnum() {
        return ItemsRegistry.SCYTHE_ITEMS;
    }

    public static HashMap<ScythesID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.SCYTHE_SPAWN_RATES;
    }

    public static HashMap<ScythesID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.scytheStats;
    }

    @Override
    public Boolean isEnabled() {
        return ScythesID.getEnabledItems().get(this);
    }

    public McdwScythe getItem() {
        return ScythesID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return ScythesID.getSpawnRates().get(this);
    }

    public HashMap<ScythesID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.scytheStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return ScythesID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.scytheStats.get(this);
    }

    @Override
    public class_1832 getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    @Override
    public Map<class_1887, Integer> getInnateEnchantments() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case SCYTHE_FROST_SCYTHE, SCYTHE_SKULL_SCYTHE -> Map.of(EnchantsRegistry.FREEZING, 1);
            case SCYTHE_JAILORS_SCYTHE -> Map.of(EnchantsRegistry.CHAINS, 1);
            case SCYTHE_SOUL_SCYTHE -> Map.of(EnchantsRegistry.SOUL_DEVOURER, 1);
        };
    }

    @Override
    @NotNull
    public class_1799 getInnateEnchantedStack(class_1792 item) {
        return item.method_7854();
    }

    public McdwScythe makeWeapon() {
        McdwScythe mcdwScythe = new McdwScythe(this, ItemsRegistry.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        ScythesID.getItemsEnum().put(this, mcdwScythe);
        return mcdwScythe;
    }
}

