/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.bases.McdwStaff;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.registries.EnchantsRegistry;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1887;
import org.jetbrains.annotations.NotNull;

public enum StavesID implements IMeleeWeaponID,
IInnateEnchantment
{
    STAFF_BATTLESTAFF((class_1832)class_1834.field_8922, 2, -2.6f, "minecraft:planks"),
    STAFF_BATTLESTAFF_OF_TERROR((class_1832)class_1834.field_8923, 5, -2.6f, "minecraft:iron_ingot"),
    STAFF_GROWING_STAFF((class_1832)class_1834.field_8923, 5, -2.6f, "minecraft:iron_ingot");

    private final class_1832 material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private StavesID(class_1832 material, int damage, float attackSpeed, String ... repairIngredient) {
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static HashMap<StavesID, Boolean> getEnabledItems() {
        return Mcdw.CONFIG.mcdwEnableItemsConfig.STAVES_ENABLED;
    }

    public static EnumMap<StavesID, McdwStaff> getItemsEnum() {
        return ItemsRegistry.STAFF_ITEMS;
    }

    public static HashMap<StavesID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.STAFF_SPAWN_RATES;
    }

    public static HashMap<StavesID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.staffStats;
    }

    @Override
    public Boolean isEnabled() {
        return StavesID.getEnabledItems().get(this);
    }

    public McdwStaff getItem() {
        return StavesID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return StavesID.getSpawnRates().get(this);
    }

    public HashMap<StavesID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.staffStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return StavesID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.staffStats.get(this);
    }

    @Override
    public class_1832 getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    @Override
    public Map<class_1887, Integer> getInnateEnchantments() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case STAFF_BATTLESTAFF -> null;
            case STAFF_BATTLESTAFF_OF_TERROR -> Map.of(EnchantsRegistry.EXPLODING, 1);
            case STAFF_GROWING_STAFF -> Map.of(EnchantsRegistry.COMMITTED, 1);
        };
    }

    @Override
    @NotNull
    public class_1799 getInnateEnchantedStack(class_1792 item) {
        return item.method_7854();
    }

    public McdwStaff makeWeapon() {
        McdwStaff mcdwStaff = new McdwStaff(this, ItemsRegistry.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        StavesID.getItemsEnum().put(this, mcdwStaff);
        return mcdwStaff;
    }
}

