/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.registries;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.enums.AxesID;
import chronosacaria.mcdw.enums.BowsID;
import chronosacaria.mcdw.enums.CrossbowsID;
import chronosacaria.mcdw.enums.DaggersID;
import chronosacaria.mcdw.enums.DoubleAxesID;
import chronosacaria.mcdw.enums.GauntletsID;
import chronosacaria.mcdw.enums.GlaivesID;
import chronosacaria.mcdw.enums.HammersID;
import chronosacaria.mcdw.enums.IMcdwWeaponID;
import chronosacaria.mcdw.enums.ItemsID;
import chronosacaria.mcdw.enums.LongbowsID;
import chronosacaria.mcdw.enums.PicksID;
import chronosacaria.mcdw.enums.ScythesID;
import chronosacaria.mcdw.enums.SettingsID;
import chronosacaria.mcdw.enums.ShieldsID;
import chronosacaria.mcdw.enums.ShortbowsID;
import chronosacaria.mcdw.enums.SicklesID;
import chronosacaria.mcdw.enums.SoulDaggersID;
import chronosacaria.mcdw.enums.SpearsID;
import chronosacaria.mcdw.enums.StavesID;
import chronosacaria.mcdw.enums.SwordsID;
import chronosacaria.mcdw.enums.WhipsID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_219;
import net.minecraft.class_44;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_77;
import net.minecraft.class_79;

public class LootTablesRegistry {
    public static final ArrayList<String> COMMON_LOOT_TABLES = new ArrayList<String>(List.of(Mcdw.CONFIG.mcdwNewlootConfig.COMMON_LOOT_TABLES.get((Object)SettingsID.COMMON_LOOT_TABLES)));
    public static final ArrayList<String> UNCOMMON_LOOT_TABLES = new ArrayList<String>(List.of(Mcdw.CONFIG.mcdwNewlootConfig.UNCOMMON_LOOT_TABLES.get((Object)SettingsID.UNCOMMON_LOOT_TABLES)));
    public static final ArrayList<String> RARE_LOOT_TABLES = new ArrayList<String>(List.of(Mcdw.CONFIG.mcdwNewlootConfig.RARE_LOOT_TABLES.get((Object)SettingsID.RARE_LOOT_TABLES)));
    public static final ArrayList<String> EPIC_LOOT_TABLES = new ArrayList<String>(List.of(Mcdw.CONFIG.mcdwNewlootConfig.EPIC_LOOT_TABLES.get((Object)SettingsID.EPIC_LOOT_TABLES)));
    public static final ArrayList<String> NETHER_TABLES = new ArrayList<String>(List.of("minecraft:chests/nether_bridge", "minecraft:chests/bastion_bridge", "minecraft:chests/bastion_other", "minecraft:chests/bastion_treasure"));
    static final List<IMcdwWeaponID> COMMON_LOOT_POOL = List.of(AxesID.AXE_ANCHOR, AxesID.AXE_AXE, DaggersID.DAGGER_DAGGER, DoubleAxesID.DOUBLE_AXE_DOUBLE, GauntletsID.GAUNTLET_GAUNTLET, GlaivesID.GLAIVE_GLAIVE, HammersID.HAMMER_GREAT_HAMMER, HammersID.HAMMER_MACE, LongbowsID.BOW_LONGBOW, PicksID.PICK_HOWLING_PICK, PicksID.PICK_MOUNTAINEER_PICK, ShortbowsID.BOW_SHORTBOW, SicklesID.SICKLE_SICKLE, SpearsID.SPEAR_SPEAR, StavesID.STAFF_BATTLESTAFF, SwordsID.SWORD_CUTLASS, SwordsID.SWORD_IRON_SWORD_VAR, SwordsID.SWORD_KATANA, SwordsID.SWORD_RAPIER);
    static final List<IMcdwWeaponID> UNCOMMON_LOOT_POOL = List.of(BowsID.BOW_BONEBOW, BowsID.BOW_BUBBLE_BOW, BowsID.BOW_HUNTERS_PROMISE, BowsID.BOW_HUNTING_BOW, BowsID.BOW_MASTERS_BOW, BowsID.BOW_POWER_BOW, BowsID.BOW_SNOW_BOW, BowsID.BOW_SOUL_BOW, BowsID.BOW_TWISTING_VINE_BOW, BowsID.BOW_WEEPING_VINE_BOW, BowsID.BOW_WIND_BOW, CrossbowsID.CROSSBOW_AUTO_CROSSBOW, CrossbowsID.CROSSBOW_AZURE_SEEKER, CrossbowsID.CROSSBOW_BURST_CROSSBOW, CrossbowsID.CROSSBOW_BUTTERFLY_CROSSBOW, CrossbowsID.CROSSBOW_DUAL_CROSSBOW, CrossbowsID.CROSSBOW_EXPLODING_CROSSBOW, CrossbowsID.CROSSBOW_FIREBOLT_THROWER, CrossbowsID.CROSSBOW_HARPOON_CROSSBOW, CrossbowsID.CROSSBOW_HARP_CROSSBOW, CrossbowsID.CROSSBOW_HEAVY_CROSSBOW, CrossbowsID.CROSSBOW_IMPLODING_CROSSBOW, CrossbowsID.CROSSBOW_RAPID_CROSSBOW, CrossbowsID.CROSSBOW_SCATTER_CROSSBOW, CrossbowsID.CROSSBOW_SOUL_CROSSBOW, CrossbowsID.CROSSBOW_THE_SLICER, DoubleAxesID.DOUBLE_AXE_CURSED, HammersID.HAMMER_BONECLUB, HammersID.HAMMER_BONE_CUDGEL, PicksID.PICK_HOWLING_PICK, ScythesID.SCYTHE_JAILORS_SCYTHE, ScythesID.SCYTHE_SKULL_SCYTHE, SicklesID.SICKLE_NIGHTMARES_BITE, SwordsID.SWORD_BROADSWORD, SwordsID.SWORD_BROKEN_SAWBLADE, SwordsID.SWORD_CLAYMORE, SwordsID.SWORD_DIAMOND_SWORD_VAR, SwordsID.SWORD_MECHANIZED_SAWBLADE, SwordsID.SWORD_NAMELESS_BLADE, SwordsID.SWORD_SINISTER, WhipsID.WHIP_VINE_WHIP, WhipsID.WHIP_WHIP);
    static final List<IMcdwWeaponID> RARE_LOOT_POOL = List.of(AxesID.AXE_ENCRUSTED_ANCHOR, AxesID.AXE_FIREBRAND, AxesID.AXE_HIGHLAND, BowsID.BOW_BUBBLE_BURSTER, BowsID.BOW_BURST_GALE_BOW, BowsID.BOW_CALL_OF_THE_VOID, BowsID.BOW_ECHO_OF_THE_VALLEY, BowsID.BOW_ELITE_POWER_BOW, BowsID.BOW_GREEN_MENACE, BowsID.BOW_NOCTURNAL_BOW, BowsID.BOW_PHANTOM_BOW, BowsID.BOW_PINK_SCOUNDREL, BowsID.BOW_SABREWING, BowsID.BOW_SHIVERING_BOW, BowsID.BOW_TRICKBOW, BowsID.BOW_TWIN_BOW, BowsID.BOW_VOID_BOW, BowsID.BOW_WEB_BOW, BowsID.BOW_WINTERS_TOUCH, CrossbowsID.CROSSBOW_BABY_CROSSBOW, CrossbowsID.CROSSBOW_COG_CROSSBOW, CrossbowsID.CROSSBOW_FERAL_SOUL_CROSSBOW, CrossbowsID.CROSSBOW_LIGHTNING_HARP_CROSSBOW, CrossbowsID.CROSSBOW_NAUTICAL_CROSSBOW, CrossbowsID.CROSSBOW_SHADOW_CROSSBOW, CrossbowsID.CROSSBOW_SLAYER_CROSSBOW, CrossbowsID.CROSSBOW_SOUL_HUNTER_CROSSBOW, CrossbowsID.CROSSBOW_SPELLBOUND_CROSSBOW, CrossbowsID.CROSSBOW_VEILED_CROSSBOW, CrossbowsID.CROSSBOW_VOIDCALLER_CROSSBOW, DaggersID.DAGGER_CHILL_GALE_KNIFE, DaggersID.DAGGER_FANGS_OF_FROST, DaggersID.DAGGER_RESOLUTE_TEMPEST_KNIFE, DaggersID.DAGGER_SHEAR_DAGGER, DaggersID.DAGGER_TEMPEST_KNIFE, DoubleAxesID.DOUBLE_AXE_WHIRLWIND, GauntletsID.GAUNTLET_MAULERS, GlaivesID.GLAIVE_GRAVE_BANE, GlaivesID.GLAIVE_VENOM_GLAIVE, HammersID.HAMMER_FLAIL, LongbowsID.BOW_GUARDIAN_BOW, LongbowsID.BOW_RED_SNAKE, PicksID.PICK_DIAMOND_PICKAXE_VAR, PicksID.PICK_HAILING_PINNACLE, ScythesID.SCYTHE_FROST_SCYTHE, ShieldsID.SHIELD_ROYAL_GUARD, ShieldsID.SHIELD_VANGUARD, ShortbowsID.BOW_LOVE_SPELL_BOW, ShortbowsID.BOW_MECHANICAL_SHORTBOW, ShortbowsID.BOW_PURPLE_STORM, SicklesID.SICKLE_LAST_LAUGH_GOLD, SicklesID.SICKLE_LAST_LAUGH_GOLD, SicklesID.SICKLE_LAST_LAUGH_SILVER, SpearsID.SPEAR_FORTUNE, SpearsID.SPEAR_WHISPERING_SPEAR, StavesID.STAFF_BATTLESTAFF_OF_TERROR, StavesID.STAFF_GROWING_STAFF, SwordsID.SWORD_BEESTINGER, SwordsID.SWORD_CORAL_BLADE, SwordsID.SWORD_DANCERS_SWORD, SwordsID.SWORD_FREEZING_FOIL, SwordsID.SWORD_FROST_SLAYER, SwordsID.SWORD_GREAT_AXEBLADE, SwordsID.SWORD_HAWKBRAND, SwordsID.SWORD_HEARTSTEALER, SwordsID.SWORD_MASTERS_KATANA, SwordsID.SWORD_SPONGE_STRIKER);
    static final List<IMcdwWeaponID> EPIC_LOOT_POOL = List.of(BowsID.BOW_ANCIENT_BOW, BowsID.BOW_HAUNTED_BOW, BowsID.BOW_LOST_SOULS, CrossbowsID.CROSSBOW_CORRUPTED_CROSSBOW, CrossbowsID.CROSSBOW_DOOM_CROSSBOW, CrossbowsID.CROSSBOW_PRIDE_OF_THE_PIGLINS, DaggersID.DAGGER_BACKSTABBER, DaggersID.DAGGER_SWIFT_STRIKER, DaggersID.DAGGER_THE_BEGINNING, DaggersID.DAGGER_THE_END, DaggersID.DAGGER_VOID_TOUCHED_BLADE, GauntletsID.GAUNTLET_SOUL_FISTS, HammersID.HAMMER_GRAVITY, HammersID.HAMMER_STORMLANDER, HammersID.HAMMER_SUNS_GRACE, ScythesID.SCYTHE_SOUL_SCYTHE, SoulDaggersID.SOUL_DAGGER_ETERNAL_KNIFE, SoulDaggersID.SOUL_DAGGER_SOUL_KNIFE, SoulDaggersID.SOUL_DAGGER_TRUTHSEEKER, SwordsID.SWORD_DARK_KATANA, SwordsID.SWORD_OBSIDIAN_CLAYMORE, SwordsID.SWORD_THE_STARLESS_NIGHT);

    public static void register() {
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> {
            class_55.class_56 lootPoolBuilder;
            if (class_1299.field_20346.method_16351().equals((Object)id) && source.isBuiltin() && Mcdw.CONFIG.mcdwEnableItemsConfig.ITEMS_ENABLED.get((Object)ItemsID.ITEM_BEE_STINGER).booleanValue()) {
                lootPoolBuilder = class_55.method_347();
                LootTablesRegistry.addItemDrop(lootPoolBuilder, ItemsRegistry.MCDW_ITEMS.get((Object)ItemsID.ITEM_BEE_STINGER), 1, 1.0f);
                tableBuilder.pool(lootPoolBuilder.method_355());
            }
            if (class_1299.field_6145.method_16351().equals((Object)id) && source.isBuiltin() && GlaivesID.GLAIVE_CACKLING_BROOM.isEnabled().booleanValue()) {
                lootPoolBuilder = class_55.method_347();
                LootTablesRegistry.addItemDrop(lootPoolBuilder, (class_1792)GlaivesID.GLAIVE_CACKLING_BROOM.getItem(), 1, 0.2f);
                tableBuilder.pool(lootPoolBuilder.method_355());
            }
            if (class_1299.field_6119.method_16351().equals((Object)id) && source.isBuiltin() && BowsID.BOW_ANCIENT_BOW.isEnabled().booleanValue()) {
                lootPoolBuilder = class_55.method_347();
                LootTablesRegistry.addItemDrop(lootPoolBuilder, (class_1792)BowsID.BOW_ANCIENT_BOW.getItem(), 1, 0.1f);
                tableBuilder.pool(lootPoolBuilder.method_355());
            }
            if (Mcdw.CONFIG.mcdwNewlootConfig.WEAPONS_ENABLED_IN_LOOTTABLES.get((Object)SettingsID.ENABLE_WEAPONS_IN_LOOTTABLES).booleanValue()) {
                lootPoolBuilder = class_55.method_347();
                lootPoolBuilder.method_352((class_5658)class_44.method_32448((float)1.0f));
                lootPoolBuilder.method_356(class_219.method_932((float)Mcdw.CONFIG.mcdwNewlootConfig.findWeaponChance.floatValue()));
                lootPoolBuilder.method_35509((class_5658)class_44.method_32448((float)Mcdw.CONFIG.mcdwNewlootConfig.bonusRollsWithLuck.floatValue()));
                if (COMMON_LOOT_TABLES.contains(id.toString())) {
                    COMMON_LOOT_POOL.forEach(lootId -> LootTablesRegistry.addWeaponById(lootPoolBuilder, lootId));
                }
                if (UNCOMMON_LOOT_TABLES.contains(id.toString())) {
                    UNCOMMON_LOOT_POOL.forEach(lootId -> LootTablesRegistry.addWeaponById(lootPoolBuilder, lootId));
                }
                if (RARE_LOOT_TABLES.contains(id.toString())) {
                    RARE_LOOT_POOL.forEach(lootID -> LootTablesRegistry.addWeaponById(lootPoolBuilder, lootID));
                }
                if (EPIC_LOOT_TABLES.contains(id.toString())) {
                    EPIC_LOOT_POOL.forEach(lootID -> LootTablesRegistry.addWeaponById(lootPoolBuilder, lootID));
                }
                if (NETHER_TABLES.contains(id.toString()) && Arrays.stream(lootPoolBuilder.method_355().field_953).noneMatch(lootPoolEntry -> lootPoolEntry.equals(class_77.method_411((class_1935)CrossbowsID.CROSSBOW_PRIDE_OF_THE_PIGLINS.getItem()).method_437(CrossbowsID.CROSSBOW_PRIDE_OF_THE_PIGLINS.getItemSpawnRate().intValue()).method_419()))) {
                    LootTablesRegistry.addWeaponById(lootPoolBuilder, CrossbowsID.CROSSBOW_PRIDE_OF_THE_PIGLINS);
                }
                tableBuilder.pool(lootPoolBuilder.method_355());
            }
        });
    }

    public static void addWeapon(class_55.class_56 poolBuilder, class_1792 weapon, int weight) {
        poolBuilder.method_351((class_79.class_80)class_77.method_411((class_1935)weapon).method_437(weight));
    }

    public static void addWeaponById(class_55.class_56 poolBuilder, IMcdwWeaponID mcdwWeaponID) {
        if (mcdwWeaponID.isEnabled().booleanValue()) {
            LootTablesRegistry.addWeapon(poolBuilder, mcdwWeaponID.getItem(), mcdwWeaponID.getItemSpawnRate());
        }
    }

    public static void addItemDrop(class_55.class_56 poolBuilder, class_1792 item, int n, float p) {
        poolBuilder.method_352((class_5658)class_44.method_32448((float)n));
        poolBuilder.method_356(class_219.method_932((float)p));
        poolBuilder.method_351((class_79.class_80)class_77.method_411((class_1935)item));
    }
}

