/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.helper;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalDouble;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4668;
import net.minecraft.class_4696;
import net.minecraft.class_4722;
import net.minecraft.class_5348;
import net.minecraft.class_5819;
import net.minecraft.class_757;
import net.minecraft.class_777;
import net.minecraft.class_811;
import net.minecraft.class_840;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.CoreShaders;
import vazkii.botania.client.core.helper.DelegatedVertexConsumer;
import vazkii.botania.client.render.block_entity.PylonBlockEntityRenderer;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.equipment.bauble.FlugelTiaraItem;
import vazkii.botania.mixin.client.ItemRendererAccessor;
import vazkii.botania.mixin.client.RenderTypeAccessor;

public final class RenderHelper
extends class_1921 {
    private static final class_1921 STAR;
    public static final class_1921 RECTANGLE;
    public static final class_1921 CIRCLE;
    public static final class_1921 RED_STRING;
    public static final class_1921 LINE_1_NO_DEPTH;
    public static final class_1921 LINE_4_NO_DEPTH;
    public static final class_1921 LINE_5_NO_DEPTH;
    public static final class_1921 LINE_8_NO_DEPTH;
    public static final class_1921 SPARK;
    public static final class_1921 LIGHT_RELAY;
    public static final class_1921 ICON_OVERLAY;
    public static final class_1921 BABYLON_ICON;
    public static final class_1921 MANA_POOL_WATER;
    public static final class_1921 TERRA_PLATE;
    public static final class_1921 ENCHANTER;
    public static final class_1921 HALO;
    public static final class_1921 MANA_PYLON_GLOW;
    public static final class_1921 NATURA_PYLON_GLOW;
    public static final class_1921 GAIA_PYLON_GLOW;
    public static final class_1921 MANA_PYLON_GLOW_DIRECT;
    public static final class_1921 NATURA_PYLON_GLOW_DIRECT;
    public static final class_1921 GAIA_PYLON_GLOW_DIRECT;
    public static final class_1921 ASTROLABE_PREVIEW;
    public static final class_1921 STARFIELD;
    public static final class_1921 LIGHTNING;
    public static final class_1921 TRANSLUCENT;
    private static final int ITEM_AND_PADDING_WIDTH = 20;
    private static final double INITIAL_OFFSET = 0.005;
    private static final double OFFSET_INCREMENT = 0.001;
    private static double offY;
    private static final Function<class_2960, class_1921> DOPPLEGANGER;

    public static double getOffY() {
        return offY;
    }

    public static void incrementOffY() {
        offY += 0.001;
    }

    public static void onWorldRenderLast() {
        offY = 0.005;
    }

    private static class_1921 makeLayer(String name, class_293 format, class_293.class_5596 mode, int bufSize, boolean hasCrumbling, boolean sortOnUpload, class_1921.class_4688 glState) {
        return RenderTypeAccessor.create(name, format, mode, bufSize, hasCrumbling, sortOnUpload, glState);
    }

    private static class_1921 makeLayer(String name, class_293 format, class_293.class_5596 mode, int bufSize, class_1921.class_4688 glState) {
        return RenderHelper.makeLayer(name, format, mode, bufSize, false, false, glState);
    }

    private RenderHelper(String string, class_293 vertexFormat, class_293.class_5596 mode, int i, boolean bl, boolean bl2, Runnable runnable, Runnable runnable2) {
        super(string, vertexFormat, mode, i, bl, bl2, runnable, runnable2);
        throw new UnsupportedOperationException("Should not be instantiated");
    }

    private static class_1921 getPylonGlowDirect(String name, class_2960 texture) {
        return RenderHelper.getPylonGlow(name, texture, true);
    }

    private static class_1921 getPylonGlow(String name, class_2960 texture) {
        return RenderHelper.getPylonGlow(name, texture, false);
    }

    private static class_1921 getPylonGlow(String name, class_2960 texture, boolean direct) {
        class_1921.class_4688.class_4689 glState = class_1921.class_4688.method_23598().method_34578(new class_4668.class_5942(CoreShaders::pylon)).method_34577((class_4668.class_5939)new class_4668.class_4683(texture, false, false)).method_23615(field_21370).method_23603(field_21345).method_23608(field_21383).method_23611(field_21385);
        if (!direct) {
            glState = glState.method_23610(class_4668.field_25643);
        }
        return RenderHelper.makeLayer("botania:" + name, class_290.field_1580, class_293.class_5596.field_27382, 128, glState.method_23617(false));
    }

    private static class_1921.class_4688 lineState(double width, boolean direct, boolean noDepth) {
        class_1921.class_4688.class_4689 builder = class_1921.class_4688.method_23598().method_34578(field_29433).method_23609(new class_4668.class_4677(OptionalDouble.of(width))).method_23607(field_22241).method_23615(field_21370).method_23616(noDepth ? field_21350 : field_21349).method_23603(field_21345);
        if (!direct) {
            builder = builder.method_23610(field_25643);
        }
        if (noDepth) {
            builder = builder.method_23604(field_21346);
        }
        return builder.method_23617(false);
    }

    public static class_1921 getHaloLayer(class_2960 texture) {
        class_1921.class_4688 glState = class_1921.class_4688.method_23598().method_34578(class_4668.field_29439).method_34577((class_4668.class_5939)new class_4668.class_4683(texture, true, false)).method_23603(new class_4668.class_4671(false)).method_23615(field_21370).method_23617(false);
        return RenderHelper.makeLayer("botania:crafting_halo", class_290.field_20887, class_293.class_5596.field_27382, 64, false, true, glState);
    }

    public static class_1921 getDopplegangerLayer(class_2960 texture) {
        return DOPPLEGANGER.apply(texture);
    }

    public static void drawTexturedModalRect(class_332 gui, class_2960 textureId, int x, int y, int u, int v, int width, int height) {
        gui.method_25290(textureId, x, y, (float)u, (float)v, width, height, 256, 256);
    }

    public static void renderStar(class_4587 ms, class_4597 buffers, int color, float xScale, float yScale, float zScale, long seed) {
        class_4588 buffer = buffers.getBuffer(STAR);
        float semiPeriodTicks = 200.0f;
        float ticks = (float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
        float f1 = class_3532.method_15379((float)class_3532.method_15374((float)((float)Math.PI / semiPeriodTicks * ticks))) * 0.9f + 0.1f;
        float f2 = f1 > 0.0f ? (f1 - 0.7f) / 0.2f : 0.0f;
        Random random = new Random(seed);
        ms.method_22903();
        ms.method_22905(xScale, yScale, zScale);
        int i = 0;
        while ((float)i < (f1 + f1 * f1) / 2.0f * 90.0f + 30.0f) {
            ms.method_22907(VecHelper.rotateX(random.nextFloat() * 360.0f));
            ms.method_22907(VecHelper.rotateY(random.nextFloat() * 360.0f));
            ms.method_22907(VecHelper.rotateZ(random.nextFloat() * 360.0f));
            ms.method_22907(VecHelper.rotateX(random.nextFloat() * 360.0f));
            ms.method_22907(VecHelper.rotateY(random.nextFloat() * 360.0f));
            ms.method_22907(VecHelper.rotateZ(random.nextFloat() * 360.0f + f1 * 90.0f));
            float f3 = random.nextFloat() * 20.0f + 5.0f + f2 * 10.0f;
            float f4 = random.nextFloat() * 2.0f + 1.0f + f2 * 2.0f;
            float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
            float g = (float)((color & 0xFF00) >> 8) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            Matrix4f mat = ms.method_23760().method_23761();
            Runnable center = () -> buffer.method_22918(mat, 0.0f, 0.0f, 0.0f).method_22915(r, g, b, f1).method_1344();
            Runnable[] vertices = new Runnable[]{() -> buffer.method_22918(mat, -0.866f * f4, f3, -0.5f * f4).method_1336(0, 0, 0, 0).method_1344(), () -> buffer.method_22918(mat, 0.866f * f4, f3, -0.5f * f4).method_1336(0, 0, 0, 0).method_1344(), () -> buffer.method_22918(mat, 0.0f, f3, 1.0f * f4).method_1336(0, 0, 0, 0).method_1344(), () -> buffer.method_22918(mat, -0.866f * f4, f3, -0.5f * f4).method_1336(0, 0, 0, 0).method_1344()};
            RenderHelper.triangleFan(center, vertices);
            ++i;
        }
        ms.method_22909();
    }

    public static void triangleFan(Runnable center, Runnable ... vertices) {
        RenderHelper.triangleFan(center, Arrays.asList(vertices));
    }

    public static void triangleFan(Runnable center, List<Runnable> vertices) {
        for (int i = 0; i < vertices.size() - 1; ++i) {
            center.run();
            vertices.get(i).run();
            vertices.get(i + 1).run();
        }
    }

    public static void flatRectangle(class_4588 buffer, Matrix4f mat, float xMin, float xMax, float y, float zMin, float zMax, int r, int g, int b, int a) {
        buffer.method_22918(mat, xMax, y, zMin).method_1336(r, g, b, a).method_1344();
        buffer.method_22918(mat, xMin, y, zMin).method_1336(r, g, b, a).method_1344();
        buffer.method_22918(mat, xMin, y, zMax).method_1336(r, g, b, a).method_1344();
        buffer.method_22918(mat, xMax, y, zMax).method_1336(r, g, b, a).method_1344();
    }

    public static void renderProgressPie(class_332 gui, int x, int y, float progress, class_1799 stack) {
        class_4587 ms = gui.method_51448();
        class_310 mc = class_310.method_1551();
        gui.method_51427(stack, x, y);
        RenderSystem.clear((int)256, (boolean)true);
        GL11.glEnable((int)2960);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.stencilFunc((int)512, (int)1, (int)255);
        RenderSystem.stencilOp((int)7681, (int)7680, (int)7680);
        RenderSystem.stencilMask((int)255);
        gui.method_51427(stack, x, y);
        int r = 10;
        int centerX = x + 8;
        int centerY = y + 8;
        int degs = (int)(360.0f * progress);
        float a = 0.5f + 0.2f * ((float)Math.cos((double)((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) / 10.0) * 0.5f + 0.5f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.stencilMask((int)0);
        RenderSystem.stencilFunc((int)514, (int)1, (int)255);
        Matrix4f mat = ms.method_23760().method_23761();
        class_287 buf = class_289.method_1348().method_1349();
        RenderSystem.setShader(class_757::method_34540);
        buf.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        buf.method_22918(mat, (float)centerX, (float)centerY, 0.0f).method_22915(0.0f, 0.5f, 0.5f, a).method_1344();
        for (int i = degs; i >= 0; --i) {
            float rad = (float)(i - 90) / 180.0f * (float)Math.PI;
            buf.method_22918(mat, (float)centerX + class_3532.method_15362((float)rad) * (float)r, (float)centerY + class_3532.method_15374((float)rad) * (float)r, 0.0f).method_22915(0.0f, 1.0f, 0.5f, a).method_1344();
        }
        buf.method_22918(mat, (float)centerX, (float)centerY, 0.0f).method_22915(0.0f, 1.0f, 0.5f, a).method_1344();
        class_289.method_1348().method_1350();
        RenderSystem.disableBlend();
        GL11.glDisable((int)2960);
    }

    public static void renderItemCustomColor(class_1309 entity, class_1799 stack, int color, class_4587 ms, class_4597 buffers, int light, int overlay, @Nullable class_1087 model) {
        ms.method_22903();
        if (model == null) {
            model = class_310.method_1551().method_1480().method_4019(stack, entity.method_37908(), entity, entity.method_5628());
        }
        model.method_4709().method_3503(class_811.field_4315).method_23075(false, ms);
        ms.method_22904(-0.5, -0.5, -0.5);
        if (model.method_4713() || stack.method_31574(class_1802.field_8547)) {
            throw new IllegalArgumentException("Custom renderer items not supported");
        }
        class_1921 rendertype = class_4696.method_23678((class_1799)stack, (boolean)true);
        class_4588 ivertexbuilder = class_918.method_29711((class_4597)buffers, (class_1921)rendertype, (boolean)true, (boolean)stack.method_7958());
        RenderHelper.renderBakedItemModel(model, stack, color, light, overlay, ms, ivertexbuilder);
        ms.method_22909();
    }

    public static void renderItemCustomColor(class_1309 entity, class_1799 stack, int color, class_4587 ms, class_4597 buffers, int light, int overlay) {
        RenderHelper.renderItemCustomColor(entity, stack, color, ms, buffers, light, overlay, null);
    }

    private static void renderBakedItemModel(class_1087 model, class_1799 stack, int color, int light, int overlay, class_4587 ms, class_4588 buffer) {
        class_5819 random = class_5819.method_43047();
        long i = 42L;
        for (class_2350 direction : class_2350.values()) {
            random.method_43052(42L);
            RenderHelper.renderBakedItemQuads(ms, buffer, color, model.method_4707(null, direction, random), stack, light, overlay);
        }
        random.method_43052(42L);
        RenderHelper.renderBakedItemQuads(ms, buffer, color, model.method_4707(null, null, random), stack, light, overlay);
    }

    private static void renderBakedItemQuads(class_4587 ms, class_4588 buffer, int color, List<class_777> quads, class_1799 stack, int light, int overlay) {
        final float a = (float)(color >> 24 & 0xFF) / 255.0f;
        final float r = (float)(color >> 16 & 0xFF) / 255.0f;
        final float g = (float)(color >> 8 & 0xFF) / 255.0f;
        final float b = (float)(color & 0xFF) / 255.0f;
        buffer = new DelegatedVertexConsumer(buffer){

            public class_4588 method_22915(float red, float green, float blue, float alpha) {
                return super.method_22915(r, g, b, a);
            }
        };
        ((ItemRendererAccessor)class_310.method_1551().method_1480()).callRenderQuadList(ms, buffer, quads, stack, light, overlay);
    }

    public static void renderIconFullBright(class_4587 ms, class_4588 buffer, float startX, float startY, float endX, float endY, int uvStartX, int uvStartY, int uvEndX, int uvEndY, class_1058 icon, int color, float alpha, int light) {
        Matrix4f mat = ms.method_23760().method_23761();
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        buffer.method_22918(mat, startX, endY, 0.0f).method_22915(red, green, blue, alpha).method_22913(icon.method_4580((double)uvStartX), icon.method_4570((double)uvEndY)).method_22916(light).method_1344();
        buffer.method_22918(mat, endX, endY, 0.0f).method_22915(red, green, blue, alpha).method_22913(icon.method_4580((double)uvEndX), icon.method_4570((double)uvEndY)).method_22916(light).method_1344();
        buffer.method_22918(mat, endX, startY, 0.0f).method_22915(red, green, blue, alpha).method_22913(icon.method_4580((double)uvEndX), icon.method_4570((double)uvStartY)).method_22916(light).method_1344();
        buffer.method_22918(mat, startX, startY, 0.0f).method_22915(red, green, blue, alpha).method_22913(icon.method_4580((double)uvStartX), icon.method_4570((double)uvStartY)).method_22916(light).method_1344();
    }

    public static void renderIconCropped(class_4587 ms, class_4588 buffer, int uvStartX, int uvStartY, int uvEndX, int uvEndY, class_1058 icon, int color, float alpha, int light) {
        RenderHelper.renderIconFullBright(ms, buffer, (float)uvStartX / 16.0f, (float)uvStartY / 16.0f, (float)uvEndX / 16.0f, (float)uvEndY / 16.0f, uvStartX, uvStartY, uvEndX, uvEndY, icon, color, alpha, light);
    }

    public static void renderIconFullBright(class_4587 ms, class_4588 buffer, class_1058 icon, int color, float alpha, int light) {
        RenderHelper.renderIconCropped(ms, buffer, 0, 0, 16, 16, icon, color, alpha, light);
    }

    public static void renderIconFullBright(class_4587 ms, class_4588 buffer, class_1058 icon, int color, float alpha) {
        int fullbright = 0xF000F0;
        RenderHelper.renderIconFullBright(ms, buffer, icon, color, alpha, fullbright);
    }

    public static void renderIconFullBright(class_4587 ms, class_4588 buffer, class_1058 icon, float alpha) {
        RenderHelper.renderIconFullBright(ms, buffer, icon, 0xFFFFFF, alpha);
    }

    public static void renderGuiItemAlpha(class_1799 stack, int x, int y, int alpha, class_918 renderer) {
        RenderHelper.renderGuiItemAlpha(stack, x, y, alpha, renderer.method_4019(stack, null, null, 0), renderer);
    }

    public static void renderGuiItemAlpha(class_1799 stack, int x, int y, int alpha, class_1087 model, class_918 renderer) {
        boolean flatLight;
        class_310.method_1551().method_1531().method_4619(class_1059.field_5275).method_4527(false, false);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1059.field_5275);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4587 modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.method_22903();
        modelViewStack.method_46416((float)x, (float)y, 100.0f);
        modelViewStack.method_22904(8.0, 8.0, 0.0);
        modelViewStack.method_22905(1.0f, -1.0f, 1.0f);
        modelViewStack.method_22905(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        boolean bl = flatLight = !model.method_24304();
        if (flatLight) {
            class_308.method_24210();
        }
        class_4597.class_4598 buffer = class_310.method_1551().method_22940().method_23000();
        renderer.method_23179(stack, class_811.field_4317, false, new class_4587(), RenderHelper.wrapBuffer((class_4597)buffer, alpha, alpha < 255), 0xF000F0, class_4608.field_21444, model);
        buffer.method_22993();
        RenderSystem.enableDepthTest();
        if (flatLight) {
            class_308.method_24211();
        }
        modelViewStack.method_22909();
        RenderSystem.applyModelViewMatrix();
    }

    private static class_4597 wrapBuffer(class_4597 buffer, int alpha, boolean forceTranslucent) {
        return renderType -> new GhostVertexConsumer(buffer.getBuffer(forceTranslucent ? TRANSLUCENT : renderType), alpha);
    }

    public static void renderHUDBox(class_332 gui, int startX, int startY, int endX, int endY) {
        gui.method_25294(startX, startY, endX, endY, 0x44000000);
        gui.method_25294(startX - 2, startY - 2, endX + 2, endY + 2, 0x44000000);
    }

    public static void renderItemWithName(class_332 gui, class_310 mc, class_1799 itemStack, int startX, int startY, int color) {
        if (!itemStack.method_7960()) {
            gui.method_27535(mc.field_1772, itemStack.method_7964(), startX + 20, startY + 4, color);
            gui.method_51427(itemStack, startX, startY);
        }
    }

    public static void renderItemWithNameCentered(class_332 gui, class_310 mc, class_1799 itemStack, int startY, int color) {
        int centerX = mc.method_22683().method_4486() / 2;
        int startX = centerX - (20 + mc.field_1772.method_27525((class_5348)itemStack.method_7964())) / 2;
        RenderHelper.renderItemWithName(gui, mc, itemStack, startX, startY, color);
    }

    public static int itemWithNameWidth(class_310 mc, class_1799 itemStack) {
        return 20 + mc.field_1772.method_27525((class_5348)itemStack.method_7964());
    }

    static {
        MANA_PYLON_GLOW = RenderHelper.getPylonGlow("mana_pylon_glow", PylonBlockEntityRenderer.MANA_TEXTURE);
        NATURA_PYLON_GLOW = RenderHelper.getPylonGlow("natura_pylon_glow", PylonBlockEntityRenderer.NATURA_TEXTURE);
        GAIA_PYLON_GLOW = RenderHelper.getPylonGlow("gaia_pylon_glow", PylonBlockEntityRenderer.GAIA_TEXTURE);
        MANA_PYLON_GLOW_DIRECT = RenderHelper.getPylonGlowDirect("mana_pylon_glow_direct", PylonBlockEntityRenderer.MANA_TEXTURE);
        NATURA_PYLON_GLOW_DIRECT = RenderHelper.getPylonGlowDirect("natura_pylon_glow_direct", PylonBlockEntityRenderer.NATURA_TEXTURE);
        GAIA_PYLON_GLOW_DIRECT = RenderHelper.getPylonGlowDirect("gaia_pylon_glow_direct", PylonBlockEntityRenderer.GAIA_TEXTURE);
        ASTROLABE_PREVIEW = new AstrolabeLayer();
        offY = 0.005;
        class_1921.class_4688 glState = class_1921.class_4688.method_23598().method_34578(field_29442).method_23616(field_21350).method_23615(class_4668.field_21367).method_23617(false);
        STAR = RenderHelper.makeLayer("botania:star", class_290.field_1576, class_293.class_5596.field_27379, 256, false, false, glState);
        glState = class_1921.class_4688.method_23598().method_34578(field_29442).method_23615(field_21370).method_23610(field_25643).method_23603(field_21345).method_23617(false);
        RECTANGLE = RenderHelper.makeLayer("botania:rectangle_highlight", class_290.field_1576, class_293.class_5596.field_27382, 256, false, true, glState);
        CIRCLE = RenderHelper.makeLayer("botania:circle_highlight", class_290.field_1576, class_293.class_5596.field_27379, 256, false, false, glState);
        RED_STRING = RenderHelper.makeLayer("botania:red_string", class_290.field_29337, class_293.class_5596.field_27377, 128, RenderHelper.lineState(1.0, false, false));
        LINE_1_NO_DEPTH = RenderHelper.makeLayer("botania:line_1_no_depth", class_290.field_29337, class_293.class_5596.field_27377, 128, RenderHelper.lineState(1.0, true, true));
        LINE_4_NO_DEPTH = RenderHelper.makeLayer("botania:line_4_no_depth", class_290.field_29337, class_293.class_5596.field_27377, 128, RenderHelper.lineState(4.0, true, true));
        LINE_5_NO_DEPTH = RenderHelper.makeLayer("botania:line_5_no_depth", class_290.field_29337, class_293.class_5596.field_27377, 64, RenderHelper.lineState(5.0, true, true));
        LINE_8_NO_DEPTH = RenderHelper.makeLayer("botania:line_8_no_depth", class_290.field_29337, class_293.class_5596.field_27377, 64, RenderHelper.lineState(8.0, true, true));
        glState = class_1921.class_4688.method_23598().method_34578(field_29441).method_34577((class_4668.class_5939)class_4668.field_21376).method_23615(field_21370).method_23610(field_25643).method_23608(field_21383).method_23617(true);
        SPARK = RenderHelper.makeLayer("botania:spark", class_290.field_20888, class_293.class_5596.field_27382, 256, glState);
        glState = class_1921.class_4688.method_23598().method_34578(new class_4668.class_5942(CoreShaders::halo)).method_34577((class_4668.class_5939)class_4668.field_21376).method_23615(field_21370).method_23610(field_25643).method_23617(true);
        LIGHT_RELAY = RenderHelper.makeLayer("botania:light_relay", class_290.field_20887, class_293.class_5596.field_27382, 64, glState);
        glState = class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)field_21376).method_34578(field_29441).method_23615(field_21370).method_23610(field_25643).method_23608(field_21383).method_23617(true);
        ICON_OVERLAY = RenderHelper.makeLayer("botania:icon_overlay", class_290.field_20888, class_293.class_5596.field_27382, 128, glState);
        glState = class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)field_21376).method_34578(new class_4668.class_5942(CoreShaders::manaPool)).method_23615(field_21370).method_23610(field_25643).method_23608(field_21383).method_23617(false);
        MANA_POOL_WATER = RenderHelper.makeLayer("botania:mana_pool_water", class_290.field_20888, class_293.class_5596.field_27382, 128, glState);
        glState = class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)field_21376).method_34578(new class_4668.class_5942(CoreShaders::terraPlate)).method_23615(field_21370).method_23610(field_25643).method_23608(field_21383).method_23617(false);
        TERRA_PLATE = RenderHelper.makeLayer("botania:terra_plate_rune", class_290.field_20888, class_293.class_5596.field_27382, 128, glState);
        glState = class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)field_21376).method_34578(new class_4668.class_5942(CoreShaders::enchanter)).method_23615(field_21370).method_23610(field_25643).method_23608(field_21383).method_23617(false);
        ENCHANTER = RenderHelper.makeLayer("botania:enchanter_rune", class_290.field_20888, class_293.class_5596.field_27382, 128, glState);
        class_4668.class_4683 babylonTexture = new class_4668.class_4683(new class_2960("botania:textures/misc/babylon.png"), false, true);
        glState = class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)babylonTexture).method_34578(new class_4668.class_5942(CoreShaders::halo)).method_23615(field_21370).method_23610(field_25643).method_23603(field_21345).method_23617(true);
        BABYLON_ICON = RenderHelper.makeLayer("botania:babylon", class_290.field_20887, class_293.class_5596.field_27382, 64, glState);
        class_4668.class_4683 haloTexture = new class_4668.class_4683(FlugelTiaraItem.textureHalo, false, true);
        glState = class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)haloTexture).method_34578(new class_4668.class_5942(CoreShaders::halo)).method_23615(field_21370).method_23603(field_21345).method_23617(true);
        HALO = RenderHelper.makeLayer("botania:halo", class_290.field_20887, class_293.class_5596.field_27382, 64, glState);
        glState = class_1921.class_4688.method_23598().method_34578(new class_4668.class_5942(CoreShaders::starfield)).method_34577((class_4668.class_5939)class_4668.class_5940.method_34560().method_34563(class_840.field_4406, false, false).method_34563(class_840.field_4407, false, false).method_34562()).method_23617(false);
        STARFIELD = RenderHelper.makeLayer("botania:starfield", class_290.field_1592, class_293.class_5596.field_27382, 256, false, false, glState);
        glState = class_1921.class_4688.method_23598().method_34578(field_29442).method_23615(field_21367).method_23617(false);
        LIGHTNING = RenderHelper.makeLayer("botania:lightning", class_290.field_1576, class_293.class_5596.field_27382, 256, false, true, glState);
        TRANSLUCENT = class_1921.method_23689((class_2960)class_1059.field_5275);
        DOPPLEGANGER = class_156.method_34866(texture -> {
            class_1921.class_4688 glState = class_1921.class_4688.method_23598().method_34578(new class_4668.class_5942(CoreShaders::doppleganger)).method_34577((class_4668.class_5939)new class_4668.class_4683(texture, false, false)).method_23615(field_21370).method_23603(field_21345).method_23608(field_21383).method_23611(field_21385).method_23617(true);
            return RenderHelper.makeLayer("botania:doppleganger", class_290.field_1580, class_293.class_5596.field_27382, 256, true, true, glState);
        });
    }

    public record GhostVertexConsumer(class_4588 wrapped, int alpha) implements class_4588
    {
        public class_4588 method_22912(double x, double y, double z) {
            return this.wrapped.method_22912(x, y, z);
        }

        public class_4588 method_1336(int red, int green, int blue, int alpha) {
            return this.wrapped.method_1336(red, green, blue, alpha * this.alpha / 255);
        }

        public class_4588 method_22913(float u, float v) {
            return this.wrapped.method_22913(u, v);
        }

        public class_4588 method_22917(int u, int v) {
            return this.wrapped.method_22917(u, v);
        }

        public class_4588 method_22921(int u, int v) {
            return this.wrapped.method_22921(u, v);
        }

        public class_4588 method_22914(float x, float y, float z) {
            return this.wrapped.method_22914(x, y, z);
        }

        public void method_1344() {
            this.wrapped.method_1344();
        }

        public void method_22901(int r, int g, int b, int a) {
            this.wrapped.method_22901(r, g, b, a);
        }

        public void method_35666() {
            this.wrapped.method_35666();
        }
    }

    private static class AstrolabeLayer
    extends class_1921 {
        public AstrolabeLayer() {
            super("botania:astrolabe", class_290.field_1580, class_293.class_5596.field_27382, 256, true, true, () -> {
                class_4722.method_24076().method_23516();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            }, () -> {
                class_4722.method_24076().method_23518();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            });
        }
    }
}

