/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.PetalApothecaryRecipe;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class PetalApothecaryRecipeCategory
implements IRecipeCategory<PetalApothecaryRecipe> {
    public static final RecipeType<PetalApothecaryRecipe> TYPE = RecipeType.create((String)"botania", (String)"petals", PetalApothecaryRecipe.class);
    public static final int CENTER_X = 48;
    public static final int CENTER_Y = 45;
    private final IDrawableStatic background;
    private final class_2561 localizedName;
    private final IDrawableStatic overlay;
    private final IDrawable icon;
    private final class_1856 WATER_BUCKET = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8705});

    public PetalApothecaryRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(114, 97);
        this.localizedName = class_2561.method_43471((String)"botania.nei.petalApothecary");
        this.overlay = guiHelper.createDrawable(ResourceLocationHelper.prefix("textures/gui/petal_overlay.png"), 17, 11, 114, 82);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)BotaniaBlocks.defaultAltar));
    }

    @NotNull
    public RecipeType<PetalApothecaryRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public class_2561 getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(@NotNull PetalApothecaryRecipe recipe, @NotNull IRecipeSlotsView slotsView, @NotNull class_332 gui, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.overlay.draw(gui, 0, 4);
        RenderSystem.disableBlend();
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull PetalApothecaryRecipe recipe, @NotNull IFocusGroup focusGroup) {
        PetalApothecaryRecipeCategory.setRecipeLayout(builder, (List<class_1856>)recipe.method_8117(), BotaniaBlocks.defaultAltar, recipe.method_8110((class_5455)class_5455.field_40585), this.WATER_BUCKET, recipe.getReagent());
    }

    public static void setRecipeLayout(@NotNull IRecipeLayoutBuilder builder, List<class_1856> ingredients, class_2248 catalyst, class_1799 output, class_1856 ... reagents) {
        class_241 center = new class_241(48.0f, 45.0f);
        if (reagents.length > 0) {
            class_241 reagentPoint = new class_241(48.0f, 55.0f);
            builder.addSlot(RecipeIngredientRole.CATALYST, (int)reagentPoint.field_1343, (int)reagentPoint.field_1342).addItemStack(new class_1799((class_1935)catalyst));
            double angleBetweenReagents = 360.0 / (double)(reagents.length + 1);
            for (int i = 0; i < reagents.length; ++i) {
                reagentPoint = PetalApothecaryRecipeCategory.rotatePointAbout(reagentPoint, center, angleBetweenReagents);
                builder.addSlot(RecipeIngredientRole.INPUT, (int)reagentPoint.field_1343, (int)reagentPoint.field_1342).addIngredients(reagents[i]);
            }
        } else {
            builder.addSlot(RecipeIngredientRole.CATALYST, 48, 45).addItemStack(new class_1799((class_1935)catalyst));
        }
        double angleBetweenEach = 360.0 / (double)ingredients.size();
        class_241 point = new class_241(48.0f, 13.0f);
        for (class_1856 ingr : ingredients) {
            builder.addSlot(RecipeIngredientRole.INPUT, (int)point.field_1343, (int)point.field_1342).addIngredients(ingr);
            point = PetalApothecaryRecipeCategory.rotatePointAbout(point, center, angleBetweenEach);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 86, 10).addItemStack(output);
    }

    public static class_241 rotatePointAbout(class_241 in, class_241 about, double degrees) {
        double rad = degrees * Math.PI / 180.0;
        double newX = Math.cos(rad) * (double)(in.field_1343 - about.field_1343) - Math.sin(rad) * (double)(in.field_1342 - about.field_1342) + (double)about.field_1343;
        double newY = Math.sin(rad) * (double)(in.field_1343 - about.field_1343) + Math.cos(rad) * (double)(in.field_1342 - about.field_1342) + (double)about.field_1342;
        return new class_241((float)newX, (float)newY);
    }
}

