/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.entity;

import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.SparkBaseEntity;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public abstract class BaseSparkRenderer<T extends SparkBaseEntity>
extends class_897<T> {
    private final class_1058 starSprite;
    private final class_1058 worldSprite;

    public BaseSparkRenderer(class_5617.class_5618 ctx) {
        super(ctx);
        Function atlas = class_310.method_1551().method_1549(class_1723.field_21668);
        this.starSprite = Objects.requireNonNull((class_1058)atlas.apply(ResourceLocationHelper.prefix("item/corporea_spark_star")));
        this.worldSprite = Objects.requireNonNull((class_1058)atlas.apply(ResourceLocationHelper.prefix("item/spark")));
    }

    public void render(@NotNull T tEntity, float yaw, float partialTicks, class_4587 ms, class_4597 buffers, int light) {
        class_1058 iicon = this.getBaseIcon(tEntity);
        ms.method_22903();
        double time = (float)(tEntity.method_37908().method_8510() % 24000L) + partialTicks + (float)new Random(tEntity.method_5628()).nextInt(200);
        float a = 0.1f + (float)(!tEntity.method_5767() ? 1 : 0) * 0.8f;
        int alpha = (int)((0.7 + 0.3 * (Math.sin(time / 5.0) + 0.5) * 2.0) * (double)a * 255.0);
        int iconColor = 0xFFFFFF | alpha << 24;
        float scale = 0.75f + 0.1f * (float)Math.sin(time / 10.0);
        ms.method_22905(scale, scale, scale);
        class_4588 buffer = buffers.getBuffer(RenderHelper.SPARK);
        ms.method_22903();
        ms.method_22907(this.field_4676.method_24197());
        ms.method_22907(VecHelper.rotateY(180.0f));
        this.renderIcon(ms, buffer, iicon, iconColor);
        ms.method_22903();
        ms.method_22904(-0.02 + Math.sin(time / 20.0) * 0.2, 0.24 + Math.cos(time / 20.0) * 0.2, 0.005);
        ms.method_22905(0.2f, 0.2f, 0.2f);
        int starColor = ColorHelper.getColorValue(((SparkBaseEntity)tEntity).getNetwork()) | (int)(a * 255.0f) << 24;
        this.renderIcon(ms, buffer, this.starSprite, starColor);
        ms.method_22909();
        class_1058 spinningIcon = this.getSpinningIcon(tEntity);
        if (spinningIcon != null) {
            ms.method_22904(-0.02 + Math.sin(time / 20.0) * -0.2, 0.24 + Math.cos(time / 20.0) * -0.2, 0.005);
            ms.method_22905(0.2f, 0.2f, 0.2f);
            this.renderIcon(ms, buffer, spinningIcon, iconColor);
        }
        ms.method_22909();
        ms.method_22909();
    }

    protected class_1058 getBaseIcon(T entity) {
        return this.worldSprite;
    }

    @Nullable
    protected class_1058 getSpinningIcon(T entity) {
        return null;
    }

    @NotNull
    public class_2960 getTextureLocation(@NotNull SparkBaseEntity entity) {
        return class_1723.field_21668;
    }

    private void renderIcon(class_4587 ms, class_4588 buffer, class_1058 icon, int color) {
        float f = icon.method_4594();
        float f1 = icon.method_4577();
        float f2 = icon.method_4593();
        float f3 = icon.method_4575();
        float f4 = 1.0f;
        float f5 = 0.5f;
        float f6 = 0.25f;
        int fullbright = 0xF000F0;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        Matrix4f mat = ms.method_23760().method_23761();
        buffer.method_22918(mat, 0.0f - f5, 0.0f - f6, 0.0f).method_1336(r, g, b, a).method_22913(f, f3).method_22916(fullbright).method_1344();
        buffer.method_22918(mat, f4 - f5, 0.0f - f6, 0.0f).method_1336(r, g, b, a).method_22913(f1, f3).method_22916(fullbright).method_1344();
        buffer.method_22918(mat, f4 - f5, f4 - f6, 0.0f).method_1336(r, g, b, a).method_22913(f1, f2).method_22916(fullbright).method_1344();
        buffer.method_22918(mat, 0.0f - f5, f4 - f6, 0.0f).method_1336(r, g, b, a).method_22913(f, f2).method_22916(fullbright).method_1344();
    }
}

