/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.fabric.integration.rei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import me.shedaniel.math.Point;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.overlay.OverlayListWidget;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.DefaultStrippingDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomDisplay;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.AncientWillContainer;
import vazkii.botania.client.core.handler.CorporeaInputHandler;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.BotanicalBreweryRecipe;
import vazkii.botania.common.crafting.ElvenTradeRecipe;
import vazkii.botania.common.crafting.LexiconElvenTradeRecipe;
import vazkii.botania.common.crafting.ManaInfusionRecipe;
import vazkii.botania.common.crafting.MarimorphosisRecipe;
import vazkii.botania.common.crafting.OrechidIgnemRecipe;
import vazkii.botania.common.crafting.OrechidRecipe;
import vazkii.botania.common.crafting.PetalsRecipe;
import vazkii.botania.common.crafting.PureDaisyRecipe;
import vazkii.botania.common.crafting.RecipeTerraPlate;
import vazkii.botania.common.crafting.RunicAltarRecipe;
import vazkii.botania.common.item.AncientWillItem;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;
import vazkii.botania.common.item.lens.LensItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.fabric.integration.rei.BotaniaREICategoryIdentifiers;
import vazkii.botania.fabric.integration.rei.BreweryREICategory;
import vazkii.botania.fabric.integration.rei.BreweryREIDisplay;
import vazkii.botania.fabric.integration.rei.ElvenTradeREICategory;
import vazkii.botania.fabric.integration.rei.ElvenTradeREIDisplay;
import vazkii.botania.fabric.integration.rei.ManaPoolREICategory;
import vazkii.botania.fabric.integration.rei.ManaPoolREIDisplay;
import vazkii.botania.fabric.integration.rei.MarimorphosisREICategory;
import vazkii.botania.fabric.integration.rei.MarimorphosisREIDisplay;
import vazkii.botania.fabric.integration.rei.OrechidIgnemREIDisplay;
import vazkii.botania.fabric.integration.rei.OrechidREICategory;
import vazkii.botania.fabric.integration.rei.OrechidREIDisplay;
import vazkii.botania.fabric.integration.rei.PetalApothecaryREICategory;
import vazkii.botania.fabric.integration.rei.PetalApothecaryREIDisplay;
import vazkii.botania.fabric.integration.rei.PureDaisyREICategory;
import vazkii.botania.fabric.integration.rei.PureDaisyREIDisplay;
import vazkii.botania.fabric.integration.rei.RunicAltarREICategory;
import vazkii.botania.fabric.integration.rei.RunicAltarREIDisplay;
import vazkii.botania.fabric.integration.rei.TerrestrialAgglomerationREICategory;
import vazkii.botania.fabric.integration.rei.TerrestrialAgglomerationREIDisplay;
import vazkii.botania.fabric.xplat.FabricXplatImpl;

public class BotaniaREIPlugin
implements REIClientPlugin {
    private static final Supplier<class_1799> HOVERED_STACK_GETTER = BotaniaREIPlugin::getHoveredREIStack;

    public BotaniaREIPlugin() {
        if (!CorporeaInputHandler.hoveredStackGetters.contains(HOVERED_STACK_GETTER)) {
            CorporeaInputHandler.hoveredStackGetters.add(HOVERED_STACK_GETTER);
        }
        CorporeaInputHandler.supportedGuiFilter = CorporeaInputHandler.supportedGuiFilter.or(s -> s instanceof DisplayScreen);
    }

    public void registerCategories(CategoryRegistry helper) {
        helper.add(List.of(new PetalApothecaryREICategory(), new PureDaisyREICategory(), new ManaPoolREICategory(), new RunicAltarREICategory(), new ElvenTradeREICategory(), new BreweryREICategory(), new TerrestrialAgglomerationREICategory(), new OrechidREICategory(BotaniaREICategoryIdentifiers.ORECHID, BotaniaFlowerBlocks.orechid), new OrechidREICategory(BotaniaREICategoryIdentifiers.ORECHID_IGNEM, BotaniaFlowerBlocks.orechidIgnem), new MarimorphosisREICategory()));
        helper.addWorkstations(BuiltinPlugin.CRAFTING, new EntryStack[]{EntryStacks.of((class_1935)BotaniaItems.craftingHalo), EntryStacks.of((class_1935)BotaniaItems.autocraftingHalo)});
        for (class_2248 apothecary : BotaniaBlocks.ALL_APOTHECARIES) {
            helper.addWorkstations(BotaniaREICategoryIdentifiers.PETAL_APOTHECARY, new EntryStack[]{EntryStacks.of((class_1935)apothecary)});
        }
        helper.addWorkstations(BotaniaREICategoryIdentifiers.BREWERY, new EntryStack[]{EntryStacks.of((class_1935)BotaniaBlocks.brewery)});
        helper.addWorkstations(BotaniaREICategoryIdentifiers.ELVEN_TRADE, new EntryStack[]{EntryStacks.of((class_1935)BotaniaBlocks.alfPortal)});
        ImmutableSet manaPools = ImmutableSet.of((Object)BotaniaBlocks.manaPool, (Object)BotaniaBlocks.dilutedPool, (Object)BotaniaBlocks.fabulousPool);
        for (class_2248 pool : manaPools) {
            helper.addWorkstations(BotaniaREICategoryIdentifiers.MANA_INFUSION, new EntryStack[]{EntryStacks.of((class_1935)pool)});
        }
        helper.addWorkstations(BotaniaREICategoryIdentifiers.ORECHID, new EntryStack[]{EntryStacks.of((class_1935)BotaniaFlowerBlocks.orechid), EntryStacks.of((class_1935)BotaniaFlowerBlocks.orechidFloating)});
        helper.addWorkstations(BotaniaREICategoryIdentifiers.ORECHID_IGNEM, new EntryStack[]{EntryStacks.of((class_1935)BotaniaFlowerBlocks.orechidIgnem), EntryStacks.of((class_1935)BotaniaFlowerBlocks.orechidIgnemFloating)});
        helper.addWorkstations(BotaniaREICategoryIdentifiers.MARIMORPHOSIS, new EntryStack[]{EntryStacks.of((class_1935)BotaniaFlowerBlocks.marimorphosis), EntryStacks.of((class_1935)BotaniaFlowerBlocks.marimorphosisFloating), EntryStacks.of((class_1935)BotaniaFlowerBlocks.marimorphosisChibi), EntryStacks.of((class_1935)BotaniaFlowerBlocks.marimorphosisChibiFloating)});
        helper.addWorkstations(BotaniaREICategoryIdentifiers.PURE_DAISY, new EntryStack[]{EntryStacks.of((class_1935)BotaniaFlowerBlocks.pureDaisy), EntryStacks.of((class_1935)BotaniaFlowerBlocks.pureDaisyFloating)});
        helper.addWorkstations(BotaniaREICategoryIdentifiers.RUNE_ALTAR, new EntryStack[]{EntryStacks.of((class_1935)BotaniaBlocks.runeAltar)});
        helper.addWorkstations(BotaniaREICategoryIdentifiers.TERRA_PLATE, new EntryStack[]{EntryStacks.of((class_1935)BotaniaBlocks.terraPlate)});
        helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.PETAL_APOTHECARY, null);
        helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.BREWERY, null);
        helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.ELVEN_TRADE, null);
        helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.MANA_INFUSION, null);
        helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.ORECHID, null);
        helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.ORECHID_IGNEM, null);
        helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.MARIMORPHOSIS, null);
        helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.PURE_DAISY, null);
        helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.RUNE_ALTAR, null);
        helper.setPlusButtonArea(BotaniaREICategoryIdentifiers.TERRA_PLATE, null);
    }

    public void registerDisplays(DisplayRegistry helper) {
        this.registerAncientWillRecipeWrapper(helper);
        this.registerCompositeLensRecipeWrapper(helper);
        this.registerTerraPickTippingRecipeWrapper(helper);
        helper.registerFiller(PetalsRecipe.class, PetalApothecaryREIDisplay::new);
        helper.registerFiller(BotanicalBreweryRecipe.class, BreweryREIDisplay::new);
        Predicate<ElvenTradeRecipe> pred = recipe -> !recipe.isReturnRecipe();
        helper.registerFiller(ElvenTradeRecipe.class, pred, ElvenTradeREIDisplay::new);
        helper.registerFiller(LexiconElvenTradeRecipe.class, ElvenTradeREIDisplay::new);
        helper.registerFiller(ManaInfusionRecipe.class, ManaPoolREIDisplay::new);
        helper.registerFiller(PureDaisyRecipe.class, PureDaisyREIDisplay::new);
        helper.registerFiller(RunicAltarRecipe.class, RunicAltarREIDisplay::new);
        helper.registerFiller(RecipeTerraPlate.class, TerrestrialAgglomerationREIDisplay::new);
        try {
            for (Map.Entry<class_2248, class_2248> entry : FabricXplatImpl.CUSTOM_STRIPPING.entrySet()) {
                helper.add((Display)new DefaultStrippingDisplay(EntryStacks.of((class_1935)((class_1935)entry.getKey())), EntryStacks.of((class_1935)((class_1935)entry.getValue()))));
            }
        }
        catch (Exception e) {
            BotaniaAPI.LOGGER.error("Error adding strippable entry to REI", (Throwable)e);
        }
        helper.registerRecipeFiller(OrechidRecipe.class, BotaniaRecipeTypes.ORECHID_TYPE, OrechidREIDisplay::new);
        helper.registerRecipeFiller(OrechidIgnemRecipe.class, BotaniaRecipeTypes.ORECHID_IGNEM_TYPE, OrechidIgnemREIDisplay::new);
        helper.registerRecipeFiller(MarimorphosisRecipe.class, BotaniaRecipeTypes.MARIMORPHOSIS_TYPE, MarimorphosisREIDisplay::new);
    }

    void registerAncientWillRecipeWrapper(DisplayRegistry helper) {
        ImmutableList.Builder input = ImmutableList.builder();
        ImmutableList.Builder output = ImmutableList.builder();
        ImmutableSet wills = ImmutableSet.of((Object)new class_1799((class_1935)BotaniaItems.ancientWillAhrim), (Object)new class_1799((class_1935)BotaniaItems.ancientWillDharok), (Object)new class_1799((class_1935)BotaniaItems.ancientWillGuthan), (Object)new class_1799((class_1935)BotaniaItems.ancientWillKaril), (Object)new class_1799((class_1935)BotaniaItems.ancientWillTorag), (Object)new class_1799((class_1935)BotaniaItems.ancientWillVerac), (Object[])new class_1799[0]);
        AncientWillContainer container = (AncientWillContainer)BotaniaItems.terrasteelHelm;
        class_1799 helmet = new class_1799((class_1935)BotaniaItems.terrasteelHelm);
        input.add((Object)EntryIngredients.of((class_1799)helmet));
        input.add((Object)EntryIngredients.ofItemStacks((Collection)wills));
        for (class_1799 will : wills) {
            class_1799 copy = helmet.method_7972();
            container.addAncientWill(copy, ((AncientWillItem)will.method_7909()).type);
            output.add((Object)EntryStacks.of((class_1799)copy));
        }
        helper.add((Display)new DefaultCustomDisplay(null, (List)input.build(), Collections.singletonList(EntryIngredient.of((Iterable)output.build()))));
    }

    void registerCompositeLensRecipeWrapper(DisplayRegistry helper) {
        List<class_1799> lensStacks = StreamSupport.stream(class_7923.field_41178.method_40286(BotaniaTags.Items.LENS).spliterator(), false).map(class_1799::new).filter(s -> !((LensItem)s.method_7909()).isControlLens((class_1799)s)).filter(s -> ((LensItem)s.method_7909()).isCombinable((class_1799)s)).toList();
        List<class_1792> lenses = lensStacks.stream().map(class_1799::method_7909).toList();
        List<EntryIngredient> inputs = Arrays.asList(EntryIngredients.ofItemStacks(lensStacks), EntryIngredients.of((class_1799)new class_1799((class_1935)class_1802.field_8777)), EntryIngredients.ofItemStacks(lensStacks));
        int end = lenses.size() - 1;
        ArrayList<class_1799> firstInput = new ArrayList<class_1799>();
        ArrayList<class_1799> secondInput = new ArrayList<class_1799>();
        ArrayList<class_1799> outputs = new ArrayList<class_1799>();
        for (int i = 1; i <= end; ++i) {
            class_1799 firstLens = new class_1799((class_1935)lenses.get(i));
            for (class_1792 secondLens : lenses) {
                if (secondLens == firstLens.method_7909()) continue;
                class_1799 secondLensStack = new class_1799((class_1935)secondLens);
                if (!((LensItem)firstLens.method_7909()).canCombineLenses(firstLens, secondLensStack)) continue;
                firstInput.add(firstLens);
                secondInput.add(secondLensStack);
                outputs.add(((LensItem)firstLens.method_7909()).setCompositeLens(firstLens.method_7972(), secondLensStack));
            }
        }
        inputs.set(0, EntryIngredients.ofItemStacks(firstInput));
        inputs.set(2, EntryIngredients.ofItemStacks(secondInput));
        helper.add((Display)new DefaultCustomDisplay(null, inputs, Collections.singletonList(EntryIngredients.ofItemStacks(outputs))));
    }

    void registerTerraPickTippingRecipeWrapper(DisplayRegistry helper) {
        ImmutableList inputs = ImmutableList.of((Object)EntryIngredients.of((class_1935)BotaniaItems.terraPick), (Object)EntryIngredients.of((class_1935)BotaniaItems.elementiumPick));
        class_1799 output = new class_1799((class_1935)BotaniaItems.terraPick);
        TerraShattererItem.setTipped(output);
        helper.add((Display)new DefaultCustomDisplay(null, (List)inputs, Collections.singletonList(EntryIngredients.of((class_1799)output))));
    }

    private static class_1799 getHoveredREIStack() {
        return REIRuntime.getInstance().getOverlay().map(o -> {
            class_1799 stack;
            if (REIRuntime.getInstance().isOverlayVisible()) {
                stack = BotaniaREIPlugin.unwrapEntry(o.getEntryList().getFocusedStack());
                if (!stack.method_7960()) {
                    return stack;
                }
                stack = o.getFavoritesList().map(OverlayListWidget::getFocusedStack).map(BotaniaREIPlugin::unwrapEntry).orElse(class_1799.field_8037);
                if (!stack.method_7960()) {
                    return stack;
                }
            }
            if (class_310.method_1551().field_1755 instanceof DisplayScreen) {
                Point point = PointHelper.ofMouse();
                for (class_364 child : class_310.method_1551().field_1755.method_25396()) {
                    Slot slot;
                    if (!child.method_25405((double)point.x, (double)point.y) || !(child instanceof Slot) || (stack = BotaniaREIPlugin.unwrapEntry((slot = (Slot)child).getCurrentEntry())).method_7960()) continue;
                    return stack;
                }
            }
            return class_1799.field_8037;
        }).orElse(class_1799.field_8037);
    }

    private static class_1799 unwrapEntry(@Nullable EntryStack<?> stack) {
        if (stack != null && !stack.isEmpty() && stack.getType() == VanillaEntryTypes.ITEM) {
            return (class_1799)stack.getValue();
        }
        return class_1799.field_8037;
    }
}

