/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.block;

import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_4516;
import net.minecraft.class_4970;
import net.minecraft.class_6302;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.ForceRelayBlock;
import vazkii.botania.test.TestingUtil;

public class ForceRelayTest {
    @class_6302(method_35936="botania:block/piston_relay_basic")
    public void testBasic(class_4516 helper) {
        class_2338 initialRelay = new class_2338(4, 2, 2);
        class_2338 initialAndesite = new class_2338(4, 4, 5);
        class_2338 initialSlimeUnderAndesite = initialAndesite.method_10074();
        class_2338 initialDiorite = new class_2338(3, 4, 5);
        class_2338 initialSlimeUnderDiorite = initialDiorite.method_10074();
        ForceRelayBlock.WorldData data = ForceRelayBlock.WorldData.get((class_1937)helper.method_35943());
        data.mapping.put(helper.method_36052(initialRelay), helper.method_36052(initialSlimeUnderDiorite));
        helper.method_36041().method_36085(() -> {
            class_2338 activateFirstPiston = new class_2338(4, 2, 0);
            helper.method_35984(activateFirstPiston, class_2246.field_10002);
        }).method_36077(4, () -> {
            helper.method_35972(BotaniaBlocks.pistonRelay, initialRelay.method_10072());
            helper.method_35972(class_2246.field_10115, initialAndesite.method_10072());
            helper.method_35972(class_2246.field_10030, initialSlimeUnderAndesite.method_10072());
            helper.method_35972(class_2246.field_10508, initialDiorite.method_10072());
            helper.method_35972(class_2246.field_10030, initialSlimeUnderDiorite.method_10072());
        }).method_36085(() -> {
            class_2338 activateSecondPiston = new class_2338(6, 2, 3);
            helper.method_35984(activateSecondPiston, class_2246.field_10002);
        }).method_36077(4, () -> {
            class_2338 relayPos = initialRelay.method_10072().method_10067();
            helper.method_35972(BotaniaBlocks.pistonRelay, relayPos);
            helper.method_35972(class_2246.field_10115, initialAndesite.method_10072().method_10067());
            helper.method_35972(class_2246.field_10030, initialSlimeUnderAndesite.method_10072().method_10067());
            helper.method_35972(class_2246.field_10508, initialDiorite.method_10072().method_10067());
            helper.method_35972(class_2246.field_10030, initialSlimeUnderDiorite.method_10072().method_10067());
            helper.method_36044(relayPos);
            TestingUtil.assertThat(!data.mapping.containsKey(relayPos), () -> "Removing relay should remove internal mapping");
        }).method_36075();
    }

    @class_6302(method_35936="botania:block/piston_relay_immovable")
    public void testImmovable(class_4516 helper) {
        class_2338 initialRelay = new class_2338(1, 2, 1);
        class_2338 initialCobble = new class_2338(1, 2, 0);
        ForceRelayBlock.WorldData data = ForceRelayBlock.WorldData.get((class_1937)helper.method_35943());
        data.mapping.put(helper.method_36052(initialRelay), helper.method_36052(initialCobble));
        helper.method_36041().method_36085(() -> {
            class_2338 lever = new class_2338(2, 2, 2);
            helper.method_36039(lever);
        }).method_36077(4, () -> {
            class_2338 relayAfter = new class_2338(0, 2, 1);
            helper.method_35972(BotaniaBlocks.pistonRelay, relayAfter);
            helper.method_35972(class_2246.field_10445, initialCobble);
            TestingUtil.assertEquals(data.mapping.get(helper.method_36052(relayAfter)), helper.method_36052(initialCobble), () -> "If destination block cannot move, the relay should move but retain binding to the destination block's original position");
        }).method_36075();
    }

    @class_6302(method_35936="botania:block/piston_relay_sticky_move_no_pull")
    public void testStickyPistonMoveNotPropagated(class_4516 helper) {
        class_2338 initialRelay = new class_2338(1, 2, 2);
        class_2338 initialGranite = new class_2338(3, 2, 3);
        class_2338 stickyPistonButton = new class_2338(1, 2, 0);
        class_2338 nonstickyPistonButton = new class_2338(1, 2, 5);
        ForceRelayBlock.WorldData data = ForceRelayBlock.WorldData.get((class_1937)helper.method_35943());
        data.mapping.put(helper.method_36052(initialRelay), helper.method_36052(initialGranite));
        helper.method_36041().method_36085(() -> helper.method_36026(stickyPistonButton)).method_36077(4, () -> {
            class_2338 relayAfter = initialRelay.method_10072();
            helper.method_35972(BotaniaBlocks.pistonRelay, relayAfter);
            helper.method_35972(class_2246.field_10289, initialGranite);
            TestingUtil.assertEquals(data.mapping.get(helper.method_36052(relayAfter)), helper.method_36052(initialGranite), () -> "If relay is moved directly via sticky piston, it should update its source location, but retain the binding to the destination block's original position");
            TestingUtil.assertEquals(data.mapping.get(helper.method_36052(initialRelay)), null, () -> "If relay is moved for whatever reason, its location data should be updated");
        }).method_36077(20, () -> {
            class_2338 relayAfter = initialRelay.method_10072();
            helper.method_35972(BotaniaBlocks.pistonRelay, relayAfter);
            helper.method_35972(class_2246.field_10289, initialGranite);
            TestingUtil.assertEquals(data.mapping.get(helper.method_36052(relayAfter)), helper.method_36052(initialGranite), () -> "If a sticky piston retracts from the relay, neither the relay nor its bound location should change");
            TestingUtil.assertEquals(data.mapping.get(helper.method_36052(initialRelay)), null, () -> "If relay is not moved, its location data should not change");
        }).method_36085(() -> helper.method_36026(nonstickyPistonButton)).method_36077(4, () -> {
            class_2338 graniteAfter = initialGranite.method_10095();
            helper.method_35972(BotaniaBlocks.pistonRelay, initialRelay);
            helper.method_35972(class_2246.field_10289, graniteAfter);
            TestingUtil.assertEquals(data.mapping.get(helper.method_36052(initialRelay)), helper.method_36052(graniteAfter), () -> "If relay is moved directly via non-sticky piston, it should update its source and bound locations");
            TestingUtil.assertEquals(data.mapping.get(helper.method_36052(initialRelay.method_10072())), null, () -> "If relay is moved for whatever reason, its location data should be updated");
        }).method_36075();
    }

    @class_6302(method_35936="botania:block/piston_relay_structure_pull")
    public void testMovingInPistonStructure(class_4516 helper) {
        class_2338 button = new class_2338(0, 2, 1);
        class_2338 initialRelay1 = new class_2338(3, 2, 2);
        class_2338 initialRelay2 = new class_2338(3, 2, 5);
        class_2338 initialBoundSlime = new class_2338(2, 2, 4);
        class_2338 initialAndesite = new class_2338(3, 4, 3);
        ForceRelayBlock.WorldData data = ForceRelayBlock.WorldData.get((class_1937)helper.method_35943());
        data.mapping.put(helper.method_36052(initialRelay1), helper.method_36052(initialBoundSlime));
        data.mapping.put(helper.method_36052(initialRelay2), helper.method_36052(initialAndesite));
        helper.method_36041().method_36085(() -> helper.method_36026(button)).method_36077(4, () -> {
            helper.method_35972(BotaniaBlocks.pistonRelay, initialRelay1.method_10078());
            helper.method_35972(BotaniaBlocks.pistonRelay, initialRelay2.method_10078());
            helper.method_36017(initialBoundSlime, class_4970.class_4971::method_26215, () -> "Second slime block structure should have moved, leaving behind an air block at the originally bound location");
            helper.method_35972(class_2246.field_10093, initialAndesite.method_10078());
            TestingUtil.assertEquals(data.mapping.get(helper.method_36052(initialRelay1.method_10078())), helper.method_36052(initialBoundSlime.method_10078()), () -> "Even if the structure was pushed by a sticky piston, the relay and bound locations should have been updated, since the relay was not pushed directly.");
            TestingUtil.assertEquals(data.mapping.get(helper.method_36052(initialRelay2.method_10078())), helper.method_36052(initialAndesite.method_10078()), () -> "If a relay is moved indirectly as part of a block structure, its location and the bound block's location data should have been updated.");
            TestingUtil.assertEquals(data.mapping.get(helper.method_36052(initialRelay1)), null, () -> "If relay is moved for whatever reason, its location data should be updated");
            TestingUtil.assertEquals(data.mapping.get(helper.method_36052(initialRelay2)), null, () -> "If relay is moved for whatever reason, its location data should be updated");
        }).method_36077(24, () -> {
            helper.method_35972(BotaniaBlocks.pistonRelay, initialRelay1);
            helper.method_35972(BotaniaBlocks.pistonRelay, initialRelay2);
            helper.method_35972(class_2246.field_10030, initialBoundSlime);
            helper.method_35972(class_2246.field_10093, initialAndesite);
            TestingUtil.assertEquals(data.mapping.get(helper.method_36052(initialRelay1)), helper.method_36052(initialBoundSlime), () -> "Even if the structure was pushed by a sticky piston, the relay and bound locations should have been updated, since the relay was not pushed directly.");
            TestingUtil.assertEquals(data.mapping.get(helper.method_36052(initialRelay2)), helper.method_36052(initialAndesite), () -> "If a relay is moved indirectly as part of a block structure, its location and the bound block's location data should have been updated.");
            TestingUtil.assertEquals(data.mapping.get(helper.method_36052(initialRelay1.method_10078())), null, () -> "If relay is moved for whatever reason, its location data should be updated");
            TestingUtil.assertEquals(data.mapping.get(helper.method_36052(initialRelay2.method_10078())), null, () -> "If relay is moved for whatever reason, its location data should be updated");
        }).method_36075();
    }
}

