/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block;

import com.chefmooon.frightsdelight.common.Configuration;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightSounds;
import com.chefmooon.frightsdelight.common.utility.TextUtils;
import java.util.function.Supplier;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class DrinkableFeastBlock
extends class_2248 {
    public static final int MAX_SERVINGS = 4;
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2758 SERVINGS = class_2758.method_11867((String)"servings", (int)0, (int)4);
    protected static final class_265 SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    public Supplier<class_1792> servingItem;
    public class_2394 particleData;

    public DrinkableFeastBlock(Supplier<class_1792> servingItem, class_4970.class_2251 properties) {
        super(properties);
        this.servingItem = servingItem;
        this.particleData = null;
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)SERVINGS, (Comparable)Integer.valueOf(4)));
    }

    public DrinkableFeastBlock(Supplier<class_1792> servingItem, class_2394 particleData, class_4970.class_2251 properties) {
        super(properties);
        this.servingItem = servingItem;
        this.particleData = particleData;
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)SERVINGS, (Comparable)Integer.valueOf(4)));
    }

    public class_2758 getServingsProperty() {
        return SERVINGS;
    }

    public int getMaxServings() {
        return 4;
    }

    public class_1799 getServingItem(class_2680 state) {
        return new class_1799((class_1935)this.servingItem.get());
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        return direction == class_2350.field_11033 && !state.method_26184((class_4538)level, pos) ? class_2246.field_10124.method_9564() : super.method_9559(state, direction, neighborState, level, pos, neighborPos);
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, SERVINGS});
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 serving = this.getServingItem(state);
        class_1799 heldItem = player.method_5998(hand);
        if (level.method_8608() && (heldItem.method_31574(serving.method_7909()) ? this.addDrink(level, pos, state, player, hand).method_23665() : this.dispenseDrink(level, pos, state, player, hand).method_23665())) {
            return class_1269.field_5812;
        }
        if (heldItem.method_31574(serving.method_7909())) {
            return this.addDrink(level, pos, state, player, hand);
        }
        return this.dispenseDrink(level, pos, state, player, hand);
    }

    protected class_1269 dispenseDrink(class_1937 world, class_2338 pos, class_2680 state, class_1657 player, class_1268 hand) {
        int servings = (Integer)state.method_11654((class_2769)this.getServingsProperty());
        if (servings == 0) {
            return class_1269.field_5814;
        }
        if (servings > 0) {
            class_1799 serving = this.getServingItem(state);
            class_1799 heldItem = player.method_5998(hand);
            if (heldItem.method_31574(class_1802.field_8469)) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)this.getServingsProperty(), (Comparable)Integer.valueOf(servings - 1)), 3);
                world.method_8396(null, pos, FrightsDelightSounds.BLOCK_DRINKABLE_FEAST_REMOVE.get(), class_3419.field_15245, 0.8f, 0.8f);
                if (!player.method_7337()) {
                    heldItem.method_7934(1);
                    if (!player.method_31548().method_7394(serving)) {
                        player.method_7328(serving, false);
                    }
                }
            } else {
                player.method_7353((class_2561)TextUtils.getTranslatable("container.punch_bowl", new Object[0]), true);
            }
        }
        return class_1269.field_5812;
    }

    protected class_1269 addDrink(class_1937 world, class_2338 pos, class_2680 state, class_1657 player, class_1268 hand) {
        int servings = (Integer)state.method_11654((class_2769)this.getServingsProperty());
        if (servings < 4) {
            class_1799 heldItem = player.method_5998(hand);
            class_1799 container = new class_1799((class_1935)class_1802.field_8469);
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)this.getServingsProperty(), (Comparable)Integer.valueOf(servings + 1)), 3);
            world.method_8396(null, pos, FrightsDelightSounds.BLOCK_DRINKABLE_FEAST_ADD.get(), class_3419.field_15245, 0.8f, 0.8f);
            if (!player.method_7337()) {
                heldItem.method_7934(1);
                if (!player.method_31548().method_7394(container)) {
                    player.method_7328(container, false);
                }
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public void animate(class_2680 state, class_1937 level, class_2338 pos, class_3414 soundEvent, class_5819 random) {
        if (Configuration.drinkableFeastParticles() && this.particleData != null && (Integer)state.method_11654((class_2769)this.getServingsProperty()) > 0) {
            double d = (double)pos.method_10263() + 0.5;
            double e = (double)pos.method_10264() + 0.03 + (double)((Integer)state.method_11654((class_2769)this.getServingsProperty())).intValue() / 8.0;
            double f = (double)pos.method_10260() + 0.5;
            for (int i = 0; i < 1; ++i) {
                if (!random.method_43056()) continue;
                level.method_8406(this.particleData, d + (random.method_43058() - 0.5) / 2.0, e + (1.0 - random.method_43058()) / 20.0, f + (random.method_43058() - 0.5) / 2.0, 0.0, 0.0, 0.0);
                if (level.field_9229.method_43048(10) != 0) continue;
                level.method_45446(pos, soundEvent, class_3419.field_15245, 0.2f, 0.8f, false);
            }
        }
    }

    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        return level.method_8320(pos.method_10074()).method_51367();
    }

    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        return DrinkableFeastBlock.getOutputSignal((Integer)state.method_11654((class_2769)SERVINGS));
    }

    public static int getOutputSignal(int servings) {
        return servings * 2;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public boolean method_9516(class_2680 state, class_1922 level, class_2338 pos, class_10 type) {
        return false;
    }
}

