/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.integration.wthit.provider;

import com.chefmooon.frightsdelight.common.block.FrightsDelightBushBlock;
import com.chefmooon.frightsdelight.common.block.SoulBerryBushBlock;
import com.chefmooon.frightsdelight.common.block.WitherBerryBushBlock;
import com.chefmooon.frightsdelight.common.utility.TextUtils;
import com.chefmooon.frightsdelight.integration.wthit.FrightsDelightWailiaPlugin;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.component.PairComponent;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2769;

public enum BerryBushInfoProvider implements IBlockComponentProvider
{
    INSTANCE;


    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        class_2248 class_22482;
        if (config.getBoolean(FrightsDelightWailiaPlugin.Options.CROP_PROGRESS) && (class_22482 = accessor.getBlock()) instanceof FrightsDelightBushBlock) {
            FrightsDelightBushBlock bush = (FrightsDelightBushBlock)class_22482;
            BerryBushInfoProvider.addGrowthProgressTooltip(tooltip, (float)((Integer)accessor.getBlockState().method_11654((class_2769)bush.getAgeProperty())).intValue() / (float)bush.getMaxAge());
        }
        if (config.getBoolean(FrightsDelightWailiaPlugin.Options.BUSH_GROWTH_CONDITION)) {
            BerryBushInfoProvider.addBushGrowthConditionTooltip(tooltip, accessor);
        }
        if (config.getBoolean(FrightsDelightWailiaPlugin.Options.BUSH_TRANSFORM_CONDITION)) {
            BerryBushInfoProvider.addTransformConditionTooltip(tooltip, accessor);
        }
    }

    private static void addGrowthProgressTooltip(ITooltip tooltip, float growthValue) {
        if ((growthValue *= 100.0f) < 100.0f) {
            tooltip.addLine((ITooltipComponent)new PairComponent((class_2561)class_2561.method_43471((String)"tooltip.waila.crop_growth"), (class_2561)class_2561.method_43470((String)String.format("%.0f%%", Float.valueOf(growthValue)))));
        } else {
            tooltip.addLine((ITooltipComponent)new PairComponent((class_2561)class_2561.method_43471((String)"tooltip.waila.crop_growth"), (class_2561)class_2561.method_43471((String)"tooltip.waila.crop_mature")));
        }
    }

    private static void addBushGrowthConditionTooltip(ITooltip tooltip, IBlockAccessor accessor) {
        class_2248 class_22482 = accessor.getBlock();
        if (class_22482 instanceof FrightsDelightBushBlock) {
            FrightsDelightBushBlock frightsDelightBushBlock = (FrightsDelightBushBlock)class_22482;
            int lightLevel = accessor.getWorld().method_22335(accessor.getPosition().method_10084(), 0);
            boolean growthCondition = (Boolean)accessor.getBlockState().method_11654((class_2769)frightsDelightBushBlock.getGrowConditionProperty());
            if (frightsDelightBushBlock instanceof SoulBerryBushBlock) {
                BerryBushInfoProvider.addGrowthConditionTooltip(tooltip, growthCondition && SoulBerryBushBlock.hasGrowBrightness(lightLevel));
            } else if (frightsDelightBushBlock instanceof WitherBerryBushBlock) {
                BerryBushInfoProvider.addGrowthConditionTooltip(tooltip, growthCondition && WitherBerryBushBlock.hasGrowBrightness(lightLevel));
            }
        }
    }

    private static void addTransformConditionTooltip(ITooltip tooltip, IBlockAccessor accessor) {
        FrightsDelightBushBlock frightsDelightBushBlock;
        class_2248 class_22482 = accessor.getBlock();
        if (class_22482 instanceof FrightsDelightBushBlock && (frightsDelightBushBlock = (FrightsDelightBushBlock)class_22482) instanceof SoulBerryBushBlock) {
            SoulBerryBushBlock soulBerryBushBlock = (SoulBerryBushBlock)frightsDelightBushBlock;
            if ((Integer)accessor.getBlockState().method_11654((class_2769)soulBerryBushBlock.getAgeProperty()) == 3) {
                int lightLevel = accessor.getWorld().method_22335(accessor.getPosition().method_10084(), 0);
                boolean transformCondition = (Boolean)accessor.getBlockState().method_11654((class_2769)soulBerryBushBlock.getTransformConditionProperty());
                BerryBushInfoProvider.addBooleanTooltip(tooltip, "tooltip.waila.bush_transform", transformCondition && SoulBerryBushBlock.hasTransformBrightness(lightLevel));
            }
        }
    }

    private static void addGrowthConditionTooltip(ITooltip tooltip, boolean growthCondition) {
        tooltip.addLine((ITooltipComponent)new PairComponent((class_2561)class_2561.method_43471((String)"tooltip.waila.crop_growable"), (class_2561)(growthCondition ? class_2561.method_43471((String)"tooltip.waila.true") : class_2561.method_43471((String)"tooltip.waila.false"))));
    }

    private static void addBooleanTooltip(ITooltip tooltip, String translationKey, boolean growthCondition) {
        tooltip.addLine((ITooltipComponent)new PairComponent((class_2561)TextUtils.getTranslatable(translationKey, new Object[0]), (class_2561)(growthCondition ? class_2561.method_43471((String)"tooltip.waila.true") : class_2561.method_43471((String)"tooltip.waila.false"))));
    }
}

