/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.ExplosionEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.value.IntValue;
import dev.ftb.mods.ftbchunks.FTBCUtils;
import dev.ftb.mods.ftbchunks.FTBChunksAPIImpl;
import dev.ftb.mods.ftbchunks.FTBChunksCommands;
import dev.ftb.mods.ftbchunks.FTBChunksExpected;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.LongRangePlayerTracker;
import dev.ftb.mods.ftbchunks.PlayerNotifier;
import dev.ftb.mods.ftbchunks.api.ChunkTeamData;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.api.FTBChunksProperties;
import dev.ftb.mods.ftbchunks.api.Protection;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.data.ChunkTeamDataImpl;
import dev.ftb.mods.ftbchunks.data.ClaimExpirationManager;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManagerImpl;
import dev.ftb.mods.ftbchunks.data.PvPMode;
import dev.ftb.mods.ftbchunks.net.ChunkSendingUtils;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbchunks.net.LoginDataPacket;
import dev.ftb.mods.ftbchunks.net.PlayerDeathPacket;
import dev.ftb.mods.ftbchunks.net.PlayerVisibilityPacket;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftbchunks.net.SendManyChunksPacket;
import dev.ftb.mods.ftblibrary.integration.stages.StageHelper;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.event.PlayerJoinedPartyTeamEvent;
import dev.ftb.mods.ftbteams.api.event.PlayerLeftPartyTeamEvent;
import dev.ftb.mods.ftbteams.api.event.PlayerLoggedInAfterTeamEvent;
import dev.ftb.mods.ftbteams.api.event.PlayerTransferredTeamOwnershipEvent;
import dev.ftb.mods.ftbteams.api.event.TeamAllyEvent;
import dev.ftb.mods.ftbteams.api.event.TeamCollectPropertiesEvent;
import dev.ftb.mods.ftbteams.api.event.TeamCreatedEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import dev.ftb.mods.ftbteams.api.event.TeamManagerEvent;
import dev.ftb.mods.ftbteams.api.event.TeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1917;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3730;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FTBChunks {
    public static final String MOD_ID = "ftbchunks";
    public static final Logger LOGGER = LogManager.getLogger((String)"FTB Chunks");
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setLenient().create();
    public static FTBChunks instance;
    public static final int TILES = 15;
    public static final int TILE_SIZE = 16;
    public static final int TILE_OFFSET = 7;
    public static final int MINIMAP_SIZE = 240;
    public static final XZ[] RELATIVE_SPIRAL_POSITIONS;
    public static final Registrar<class_2248> BLOCK_REGISTRY;

    public FTBChunks() {
        FTBChunksAPI._init(FTBChunksAPIImpl.INSTANCE);
        FTBChunksNet.init();
        for (int i = 0; i < RELATIVE_SPIRAL_POSITIONS.length; ++i) {
            FTBChunks.RELATIVE_SPIRAL_POSITIONS[i] = MathUtils.getSpiralPoint((int)(i + 1));
        }
        LifecycleEvent.SERVER_BEFORE_START.register(this::serverBeforeStart);
        LifecycleEvent.SERVER_LEVEL_LOAD.register(this::serverLevelLoad);
        TeamManagerEvent.CREATED.register(this::teamManagerCreated);
        TeamManagerEvent.DESTROYED.register(this::teamManagerDestroyed);
        TeamEvent.PLAYER_LOGGED_IN.register(this::loggedIn);
        TeamEvent.CREATED.register(this::teamCreated);
        TeamEvent.LOADED.register(this::teamLoaded);
        TeamEvent.SAVED.register(this::teamSaved);
        TeamEvent.COLLECT_PROPERTIES.register(this::teamConfig);
        TeamEvent.PLAYER_JOINED_PARTY.register(this::playerJoinedParty);
        TeamEvent.PLAYER_LEFT_PARTY.register(this::playerLeftParty);
        TeamEvent.OWNERSHIP_TRANSFERRED.register(this::teamOwnershipTransferred);
        TeamEvent.PROPERTIES_CHANGED.register(this::teamPropertiesChanged);
        TeamEvent.ADD_ALLY.register(this::playerAllianceChange);
        TeamEvent.REMOVE_ALLY.register(this::playerAllianceChange);
        InteractionEvent.LEFT_CLICK_BLOCK.register(this::blockLeftClick);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(this::blockRightClick);
        InteractionEvent.RIGHT_CLICK_ITEM.register(this::itemRightClick);
        InteractionEvent.INTERACT_ENTITY.register(this::interactEntity);
        InteractionEvent.FARMLAND_TRAMPLE.register(this::farmlandTrample);
        BlockEvent.BREAK.register(this::blockBreak);
        BlockEvent.PLACE.register(this::blockPlace);
        PlayerEvent.PLAYER_QUIT.register(this::loggedOut);
        PlayerEvent.FILL_BUCKET.register(this::fillBucket);
        PlayerEvent.PLAYER_CLONE.register(this::playerCloned);
        PlayerEvent.CHANGE_DIMENSION.register(this::playerChangedDimension);
        PlayerEvent.ATTACK_ENTITY.register(this::playerAttackEntity);
        EntityEvent.ENTER_SECTION.register(this::enterSection);
        EntityEvent.LIVING_CHECK_SPAWN.register(this::checkSpawn);
        EntityEvent.LIVING_HURT.register(this::onLivingHurt);
        ExplosionEvent.DETONATE.register(this::explosionDetonate);
        CommandRegistrationEvent.EVENT.register(FTBChunksCommands::registerCommands);
        TickEvent.SERVER_POST.register(this::serverTickPost);
        TickEvent.PLAYER_POST.register(this::playerTickPost);
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> FTBChunksClient.INSTANCE::init);
    }

    private EventResult playerAttackEntity(class_1657 player, class_1937 level, class_1297 entity, class_1268 interactionHand, @Nullable class_3966 entityHitResult) {
        if (player instanceof class_3222 && !(entity instanceof class_1309) && ClaimedChunkManagerImpl.getInstance().shouldPreventInteraction((class_1297)player, interactionHand, entity.method_24515(), Protection.ATTACK_NONLIVING_ENTITY, entity)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private EventResult onLivingHurt(class_1309 living, class_1282 damageSource, float dmg) {
        if (!living.method_37908().method_8608() && living instanceof class_1657) {
            class_1657 target = (class_1657)living;
            class_1297 class_12972 = damageSource.method_5529();
            if (class_12972 instanceof class_1657) {
                class_1657 attacker = (class_1657)class_12972;
                PvPMode mode = (PvPMode)((Object)FTBChunksWorldConfig.PVP_MODE.get());
                if (mode == PvPMode.ALWAYS) {
                    return EventResult.pass();
                }
                if (this.isPvPProtectedChunk(mode, attacker) || this.isPvPProtectedChunk(mode, target)) {
                    PlayerNotifier.notifyWithCooldown(attacker, (class_2561)class_2561.method_43471((String)"ftbchunks.message.no_pvp").method_27692(class_124.field_1065), 3000L);
                    return EventResult.interruptFalse();
                }
            }
        }
        return EventResult.pass();
    }

    private boolean isPvPProtectedChunk(PvPMode mode, class_1657 player) {
        ClaimedChunkImpl cc = ClaimedChunkManagerImpl.getInstance().getChunk(new ChunkDimPos(player.method_37908(), player.method_24515()));
        return cc != null && (mode == PvPMode.NEVER || !cc.getTeamData().allowPVP());
    }

    private void playerTickPost(class_1657 player) {
        if (player.method_37908().field_9236 && player.method_37908().method_8510() % 20L == 0L) {
            FTBChunksClient.INSTANCE.maybeClearDeathpoint(player);
        }
    }

    private void serverBeforeStart(MinecraftServer server) {
        Path configPath = server.method_27050(ConfigUtil.SERVER_CONFIG_DIR);
        ConfigUtil.loadDefaulted((SNBTConfig)FTBChunksWorldConfig.CONFIG, (Path)configPath, (String)MOD_ID);
    }

    private void serverLevelLoad(class_3218 level) {
        if (ClaimedChunkManagerImpl.getInstance() != null) {
            ClaimedChunkManagerImpl.getInstance().initForceLoadedChunks(level);
        } else {
            LOGGER.warn("Level " + level.method_27983().method_29177() + " loaded before FTB Chunks manager was initialized! Unable to force-load chunks");
        }
    }

    private void teamManagerCreated(TeamManagerEvent event) {
        ClaimedChunkManagerImpl.init(event.getManager());
    }

    private void teamManagerDestroyed(TeamManagerEvent event) {
        ClaimedChunkManagerImpl.shutdown();
    }

    private void loggedIn(PlayerLoggedInAfterTeamEvent event) {
        class_3222 player = event.getPlayer();
        ChunkTeamDataImpl data = ClaimedChunkManagerImpl.getInstance().getOrCreateData(player);
        data.updateLimits();
        String playerId = event.getPlayer().method_5667().toString();
        LOGGER.debug("handling player team login: player = {}, team = {}", (Object)playerId, (Object)data.getTeamId());
        SNBTCompoundTag config = new SNBTCompoundTag();
        FTBChunksWorldConfig.CONFIG.write(config);
        UUID managerId = FTBTeamsAPI.api().getManager().getId();
        new LoginDataPacket(managerId, config).sendTo(player);
        SendGeneralDataPacket.send((ChunkTeamData)data, player);
        LOGGER.debug("server config and team data sent to {}", (Object)playerId);
        long now = System.currentTimeMillis();
        HashMap<Pair, List> chunksToSend = new HashMap<Pair, List>();
        for (ClaimedChunkImpl chunk : ClaimedChunkManagerImpl.getInstance().getAllClaimedChunks()) {
            chunksToSend.computeIfAbsent(Pair.of((Object)chunk.getPos().dimension(), (Object)chunk.getTeamData().getTeamId()), s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, chunk.getPos().x(), chunk.getPos().z(), chunk));
        }
        chunksToSend.forEach((dimensionAndId, chunkPackets) -> FTBTeamsAPI.api().getManager().getTeamByID((UUID)dimensionAndId.getRight()).ifPresent(team -> {
            ChunkTeamDataImpl teamData = ClaimedChunkManagerImpl.getInstance().getOrCreateData((Team)team);
            if (teamData.canPlayerUse(player, FTBChunksProperties.CLAIM_VISIBILITY)) {
                SendManyChunksPacket packet = new SendManyChunksPacket((class_5321<class_1937>)((class_5321)dimensionAndId.getLeft()), (UUID)dimensionAndId.getRight(), (List<SendChunkPacket.SingleChunk>)chunkPackets);
                packet.sendTo(player);
            }
        }));
        LOGGER.debug("claimed chunk data sent to {}", (Object)playerId);
        data.setLastLoginTime(now);
        data.setForceLoadMember(player.method_5667(), FTBChunksWorldConfig.canPlayerOfflineForceload(player));
        if (data.getTeam().getOnlineMembers().size() == 1 && !data.canDoOfflineForceLoading()) {
            data.updateChunkTickets(true);
        }
        PlayerVisibilityPacket.syncToLevel(player.method_37908());
        LOGGER.debug("visible player list sent to {}", (Object)playerId);
    }

    public void loggedOut(class_3222 player) {
        if (!FTBTeamsAPI.api().isManagerLoaded() || !FTBChunksAPI.api().isManagerLoaded()) {
            return;
        }
        ChunkTeamDataImpl data = ClaimedChunkManagerImpl.getInstance().getOrCreateData(player);
        if (data != null) {
            data.setForceLoadMember(player.method_5667(), FTBChunksWorldConfig.canPlayerOfflineForceload(player));
            ClaimedChunkManagerImpl.getInstance().clearForceLoadedCache();
            LongRangePlayerTracker.INSTANCE.stopTracking(player);
            if (data.getTeam().getOnlineMembers().size() == 1 && !data.canDoOfflineForceLoading()) {
                data.updateChunkTickets(false);
            }
        } else {
            LOGGER.warn("on player disconnect: player '{}' has no team?", (Object)player.method_7334().getName());
        }
    }

    private void teamCreated(TeamCreatedEvent teamEvent) {
        ClaimedChunkManagerImpl.getInstance().getOrCreateData(teamEvent.getTeam());
    }

    private void teamLoaded(TeamEvent teamEvent) {
        ClaimedChunkManagerImpl.getInstance().getOrCreateData(teamEvent.getTeam());
    }

    private void teamSaved(TeamEvent teamEvent) {
        ClaimedChunkManagerImpl.getInstance().getOrCreateData(teamEvent.getTeam()).saveNow();
    }

    public EventResult blockLeftClick(class_1657 player, class_1268 hand, class_2338 pos, class_2350 face) {
        if (player instanceof class_3222 && ClaimedChunkManagerImpl.getInstance().shouldPreventInteraction((class_1297)player, hand, pos, FTBChunksExpected.getBlockBreakProtection(), null)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public EventResult blockRightClick(class_1657 player, class_1268 hand, class_2338 pos, class_2350 face) {
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            if (ClaimedChunkManagerImpl.getInstance().shouldPreventInteraction((class_1297)player, hand, pos, FTBChunksExpected.getBlockInteractProtection(), null)) {
                FTBCUtils.forceHeldItemSync(sp, hand);
                return EventResult.interruptFalse();
            }
        }
        return EventResult.pass();
    }

    public CompoundEventResult<class_1799> itemRightClick(class_1657 player, class_1268 hand) {
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            if (ClaimedChunkManagerImpl.getInstance().shouldPreventInteraction((class_1297)player, hand, class_2338.method_49638((class_2374)player.method_5836(1.0f)), Protection.RIGHT_CLICK_ITEM, null)) {
                FTBCUtils.forceHeldItemSync(sp, hand);
                return CompoundEventResult.interruptFalse((Object)player.method_5998(hand));
            }
        }
        return CompoundEventResult.pass();
    }

    private EventResult interactEntity(class_1657 player, class_1297 entity, class_1268 hand) {
        if (player instanceof class_3222 && ClaimedChunkManagerImpl.getInstance().shouldPreventInteraction((class_1297)player, hand, entity.method_24515(), Protection.INTERACT_ENTITY, entity)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public EventResult blockBreak(class_1937 level, class_2338 pos, class_2680 blockState, class_3222 player, @Nullable IntValue intValue) {
        if (ClaimedChunkManagerImpl.getInstance().shouldPreventInteraction((class_1297)player, class_1268.field_5808, pos, FTBChunksExpected.getBlockBreakProtection(), null)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public EventResult blockPlace(class_1937 level, class_2338 pos, class_2680 blockState, @Nullable class_1297 entity) {
        if (entity instanceof class_3222) {
            class_3222 sp = (class_3222)entity;
            if (ClaimedChunkManagerImpl.getInstance().shouldPreventInteraction(entity, class_1268.field_5808, pos, FTBChunksExpected.getBlockPlaceProtection(), null)) {
                FTBCUtils.forceHeldItemSync(sp, class_1268.field_5808);
                return EventResult.interruptFalse();
            }
        }
        return EventResult.pass();
    }

    public CompoundEventResult<class_1799> fillBucket(class_1657 player, class_1937 level, class_1799 emptyBucket, @Nullable class_239 target) {
        if (player instanceof class_3222 && target instanceof class_3965) {
            class_3965 hitResult = (class_3965)target;
            class_1268 hand = player.method_6058();
            if (ClaimedChunkManagerImpl.getInstance().shouldPreventInteraction((class_1297)player, hand, hitResult.method_17777(), Protection.EDIT_FLUID, null)) {
                return CompoundEventResult.interrupt((Boolean)false, (Object)player.method_5998(hand));
            }
        }
        return CompoundEventResult.pass();
    }

    public EventResult farmlandTrample(class_1937 world, class_2338 pos, class_2680 blockState, float distance, class_1297 entity) {
        if (entity instanceof class_3222 && ClaimedChunkManagerImpl.getInstance().shouldPreventInteraction(entity, class_1268.field_5808, pos, Protection.EDIT_BLOCK, null)) {
            return EventResult.interrupt((Boolean)false);
        }
        return EventResult.pass();
    }

    public void enterSection(class_1297 entity, int chunkX, int chunkY, int chunkZ, int prevX, int prevY, int prevZ) {
        class_3222 player;
        if (chunkX == prevX && chunkZ == prevZ && chunkY != prevY || !(entity instanceof class_3222) || PlayerHooks.isFake((class_1657)(player = (class_3222)entity)) || !FTBTeamsAPI.api().isManagerLoaded() || !FTBChunksAPI.api().isManagerLoaded()) {
            return;
        }
        FTBTeamsAPI.api().getManager().getTeamForPlayerID(player.method_5667()).ifPresent(team -> {
            ChunkTeamDataImpl data = ClaimedChunkManagerImpl.getInstance().getOrCreateData((Team)team);
            data.checkForChunkChange((class_1657)player, chunkX, chunkZ);
        });
    }

    public EventResult checkSpawn(class_1309 entity, class_1936 levelAccessor, double x, double y, double z, class_3730 type, @Nullable class_1917 spawner) {
        if (!levelAccessor.method_8608() && !(entity instanceof class_1657) && levelAccessor instanceof class_1937) {
            class_1937 level = (class_1937)levelAccessor;
            switch (type) {
                case field_16459: 
                case field_16472: 
                case field_16469: 
                case field_16474: 
                case field_16460: 
                case field_16527: {
                    ClaimedChunkImpl chunk = ClaimedChunkManagerImpl.getInstance().getChunk(new ChunkDimPos(level, class_2338.method_49637((double)x, (double)y, (double)z)));
                    if (chunk == null || chunk.canEntitySpawn((class_1297)entity)) break;
                    return EventResult.interrupt((Boolean)false);
                }
            }
        }
        return EventResult.pass();
    }

    private boolean ignoreExplosion(class_1937 level, class_1927 explosion) {
        if (level.method_8608() || explosion.method_8346().isEmpty()) {
            return true;
        }
        return explosion.field_9185 == null && (Boolean)FTBChunksWorldConfig.PROTECT_UNKNOWN_EXPLOSIONS.get() == false;
    }

    public void explosionDetonate(class_1937 level, class_1927 explosion, List<class_1297> affectedEntities) {
        if (((Boolean)FTBChunksWorldConfig.DISABLE_PROTECTION.get()).booleanValue() || this.ignoreExplosion(level, explosion)) {
            return;
        }
        ArrayList list = new ArrayList(explosion.method_8346());
        explosion.method_8352();
        HashMap<ChunkDimPos, Boolean> map = new HashMap<ChunkDimPos, Boolean>();
        for (class_2338 pos : list) {
            if (!map.computeIfAbsent(new ChunkDimPos(level, pos), cpos -> {
                ClaimedChunkImpl chunk = ClaimedChunkManagerImpl.getInstance().getChunk((ChunkDimPos)cpos);
                return chunk == null || chunk.allowExplosions();
            }).booleanValue()) continue;
            explosion.method_8346().add(pos);
        }
    }

    private void playerCloned(class_3222 oldPlayer, class_3222 newPlayer, boolean wonGame) {
        if (!wonGame) {
            newPlayer.method_43122().ifPresent(loc -> {
                int num = newPlayer.method_14248().method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15421));
                new PlayerDeathPacket((class_4208)loc, num).sendTo(newPlayer);
            });
        }
    }

    private void playerChangedDimension(class_3222 serverPlayer, class_5321<class_1937> oldLevel, class_5321<class_1937> newLevel) {
        LongRangePlayerTracker.INSTANCE.stopTracking(serverPlayer);
        StageHelper.INSTANCE.getProvider().sync(serverPlayer);
    }

    private void teamConfig(TeamCollectPropertiesEvent event) {
        event.add((TeamProperty)FTBChunksProperties.ALLOW_EXPLOSIONS);
        event.add((TeamProperty)FTBChunksProperties.ALLOW_MOB_GRIEFING);
        event.add((TeamProperty)FTBChunksProperties.ALLOW_ALL_FAKE_PLAYERS);
        event.add((TeamProperty)FTBChunksProperties.ALLOW_NAMED_FAKE_PLAYERS);
        event.add((TeamProperty)FTBChunksProperties.ALLOW_FAKE_PLAYERS_BY_ID);
        event.add((TeamProperty)FTBChunksProperties.ALLOW_PVP);
        FTBChunksExpected.getPlatformSpecificProperties(event);
        event.add((TeamProperty)FTBChunksProperties.ENTITY_INTERACT_MODE);
        event.add((TeamProperty)FTBChunksProperties.NONLIVING_ENTITY_ATTACK_MODE);
        event.add((TeamProperty)FTBChunksProperties.CLAIM_VISIBILITY);
        event.add((TeamProperty)FTBChunksProperties.LOCATION_MODE);
    }

    private void playerJoinedParty(PlayerJoinedPartyTeamEvent event) {
        ChunkTeamDataImpl playerData = ClaimedChunkManagerImpl.getInstance().getOrCreateData(event.getPreviousTeam());
        ChunkTeamDataImpl partyData = ClaimedChunkManagerImpl.getInstance().getOrCreateData(event.getTeam());
        partyData.addMemberData(event.getPlayer(), playerData);
        partyData.updateLimits();
        this.transferClaims(playerData, partyData, playerData.getClaimedChunks());
        partyData.setForceLoadMember(event.getPlayer().method_5667(), FTBChunksWorldConfig.canPlayerOfflineForceload(event.getPlayer()));
        PlayerVisibilityPacket.syncToLevel(event.getPlayer().method_37908());
        partyData.syncChunksToPlayer(event.getPlayer());
    }

    private void playerLeftParty(PlayerLeftPartyTeamEvent event) {
        ChunkTeamDataImpl partyData = ClaimedChunkManagerImpl.getInstance().getOrCreateData(event.getTeam());
        FTBTeamsAPI.api().getManager().getPlayerTeamForPlayerID(event.getPlayerId()).ifPresent(personalTeam -> {
            ChunkTeamDataImpl playerData = ClaimedChunkManagerImpl.getInstance().getOrCreateData((Team)personalTeam);
            if (event.getTeamDeleted()) {
                this.transferClaims(partyData, playerData, partyData.getClaimedChunks());
                ClaimedChunkManagerImpl.getInstance().deleteTeam(event.getTeam());
            } else {
                this.transferClaims(partyData, playerData, partyData.getOriginalClaims(event.getPlayerId()));
            }
            partyData.deleteMemberData(event.getPlayerId());
            if (event.getPlayer() != null) {
                PlayerVisibilityPacket.syncToLevel(event.getPlayer().method_37908());
            }
        });
    }

    private void transferClaims(ChunkTeamDataImpl transferFrom, ChunkTeamDataImpl transferTo, Collection<ClaimedChunkImpl> chunksToTransfer) {
        class_2168 sourceStack = ClaimedChunkManagerImpl.getInstance().getMinecraftServer().method_3739();
        String fromName = transferFrom.getTeam().getShortName();
        String toName = transferTo.getTeam().getShortName();
        transferFrom.clearClaimCaches();
        transferTo.clearClaimCaches();
        int nChunks = transferTo.getClaimedChunks().size();
        HashMap<class_5321, List> chunksToSend = new HashMap<class_5321, List>();
        HashMap<class_5321, List> chunksToUnclaim = new HashMap<class_5321, List>();
        int transferred = 0;
        int unclaimed = 0;
        long now = System.currentTimeMillis();
        int total = transferTo.getClaimedChunks().size();
        LOGGER.info("attempting to transfer {} chunks from {} to {}", (Object)chunksToTransfer.size(), (Object)fromName, (Object)toName);
        for (ClaimedChunkImpl chunk : chunksToTransfer) {
            class_3218 level;
            ChunkDimPos cdp = chunk.getPos();
            if (total >= transferTo.getMaxClaimChunks()) {
                chunk.unclaim(sourceStack, false);
                chunksToUnclaim.computeIfAbsent(cdp.dimension(), s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, cdp.x(), cdp.z(), null));
                ++unclaimed;
            } else {
                chunk.setTeamData(transferTo);
                chunksToSend.computeIfAbsent(cdp.dimension(), s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, cdp.x(), cdp.z(), chunk));
                ++transferred;
            }
            if (chunk.isForceLoaded() && (level = ClaimedChunkManagerImpl.getInstance().getMinecraftServer().method_3847(cdp.dimension())) != null) {
                FTBChunksExpected.addChunkToForceLoaded(level, MOD_ID, transferFrom.getTeamId(), cdp.x(), cdp.z(), false);
                if (chunk.isActuallyForceLoaded()) {
                    FTBChunksExpected.addChunkToForceLoaded(level, MOD_ID, transferTo.getTeamId(), cdp.x(), cdp.z(), true);
                }
            }
            ++total;
        }
        transferFrom.updateLimits();
        transferTo.updateLimits();
        if (transferred > 0 || unclaimed > 0) {
            chunksToSend.forEach((dimension, chunkPackets) -> {
                if (!chunkPackets.isEmpty()) {
                    ChunkSendingUtils.sendManyChunksToAll(sourceStack.method_9211(), transferTo, new SendManyChunksPacket((class_5321<class_1937>)dimension, transferTo.getTeamId(), (List<SendChunkPacket.SingleChunk>)chunkPackets));
                }
            });
            chunksToUnclaim.forEach((dimension, chunkPackets) -> {
                if (!chunkPackets.isEmpty()) {
                    new SendManyChunksPacket((class_5321<class_1937>)dimension, class_156.field_25140, (List<SendChunkPacket.SingleChunk>)chunkPackets).sendToAll(sourceStack.method_9211());
                }
            });
        }
        LOGGER.info("Transferred {} chunks from {} ({}) to {} ({})", (Object)transferred, (Object)transferFrom, (Object)fromName, (Object)transferTo, (Object)toName);
        LOGGER.info("Unclaimed {} chunks for {} ({}) due to claim limits", (Object)unclaimed, (Object)transferFrom, (Object)fromName);
        LOGGER.info("Team {} had {} claimed chunks, now has {}", (Object)toName, (Object)nChunks, (Object)(nChunks + transferred));
    }

    private void teamOwnershipTransferred(PlayerTransferredTeamOwnershipEvent event) {
        ChunkTeamDataImpl data = ClaimedChunkManagerImpl.getInstance().getOrCreateData(event.getTeam());
        data.updateLimits();
    }

    private void teamPropertiesChanged(TeamPropertiesChangedEvent event) {
        MinecraftServer server = ClaimedChunkManagerImpl.getInstance().getMinecraftServer();
        if (server == null) {
            return;
        }
        if (event.getPreviousProperties().get((TeamProperty)FTBChunksProperties.LOCATION_MODE) != event.getTeam().getProperty((TeamProperty)FTBChunksProperties.LOCATION_MODE)) {
            PlayerVisibilityPacket.syncToAll();
        }
        if (event.getPreviousProperties().get((TeamProperty)FTBChunksProperties.CLAIM_VISIBILITY) != event.getTeam().getProperty((TeamProperty)FTBChunksProperties.CLAIM_VISIBILITY)) {
            ChunkTeamDataImpl teamData = ClaimedChunkManagerImpl.getInstance().getOrCreateData(event.getTeam());
            teamData.syncChunksToAll(server);
        }
        ClaimedChunkManagerImpl.getInstance().getOrCreateData(event.getTeam()).clearFakePlayerNameCache();
    }

    private void playerAllianceChange(TeamAllyEvent event) {
        ChunkTeamDataImpl teamData = ClaimedChunkManagerImpl.getInstance().getOrCreateData(event.getTeam());
        ArrayList<class_3222> players = new ArrayList<class_3222>();
        event.getPlayers().forEach(profile -> {
            class_3222 p = ClaimedChunkManagerImpl.getInstance().getMinecraftServer().method_3760().method_14602(profile.getId());
            if (p != null) {
                teamData.syncChunksToPlayer(p);
                players.add(p);
            }
        });
        PlayerVisibilityPacket.syncToPlayers(players);
    }

    private void serverTickPost(MinecraftServer minecraftServer) {
        ClaimExpirationManager.INSTANCE.tick(minecraftServer);
        LongRangePlayerTracker.INSTANCE.tick(minecraftServer);
    }

    static {
        RELATIVE_SPIRAL_POSITIONS = new XZ[225];
        BLOCK_REGISTRY = RegistrarManager.get((String)MOD_ID).get(class_7924.field_41254);
    }
}

