/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.api.ChunkTeamData;
import dev.ftb.mods.ftbchunks.api.ClaimedChunk;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class SendGeneralDataPacket
extends BaseS2CMessage {
    private final GeneralChunkData data;

    private SendGeneralDataPacket(int claimed, int loaded, int maxClaimChunks, int maxForceLoadChunks) {
        this.data = new GeneralChunkData(claimed, loaded, maxClaimChunks, maxForceLoadChunks);
    }

    SendGeneralDataPacket(class_2540 buf) {
        this.data = GeneralChunkData.fromNetwork(buf);
    }

    public MessageType getType() {
        return FTBChunksNet.SEND_GENERAL_DATA;
    }

    public void write(class_2540 buf) {
        this.data.toNetwork(buf);
    }

    public void handle(NetworkManager.PacketContext context) {
        FTBChunksClient.INSTANCE.updateGeneralData(this.data);
    }

    public static void send(ChunkTeamData teamData, class_3222 player) {
        SendGeneralDataPacket.send(teamData, List.of(player));
    }

    public static void send(ChunkTeamData teamData, Collection<class_3222> players) {
        Collection<? extends ClaimedChunk> cc = teamData.getClaimedChunks();
        int loaded = (int)cc.stream().filter(ClaimedChunk::isForceLoaded).count();
        SendGeneralDataPacket data = new SendGeneralDataPacket(cc.size(), loaded, teamData.getMaxClaimChunks(), teamData.getMaxForceLoadChunks());
        players.forEach(player -> teamData.getTeamManager().getTeamForPlayer(player).ifPresent(team -> {
            if (team.getId().equals(teamData.getTeam().getId())) {
                data.sendTo((class_3222)player);
            }
        }));
    }

    public record GeneralChunkData(int claimed, int loaded, int maxClaimChunks, int maxForceLoadChunks) {
        public static GeneralChunkData fromNetwork(class_2540 buf) {
            return new GeneralChunkData(buf.method_10816(), buf.method_10816(), buf.method_10816(), buf.method_10816());
        }

        public void toNetwork(class_2540 buf) {
            buf.method_10804(this.claimed);
            buf.method_10804(this.loaded);
            buf.method_10804(this.maxClaimChunks);
            buf.method_10804(this.maxForceLoadChunks);
        }
    }
}

