/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import corgitaco.corgilib.platform.ModPlatform;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2247;
import net.minecraft.class_2257;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3449;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_4076;
import net.minecraft.class_4590;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5539;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7924;
import net.minecraft.class_8113;
import org.joml.Matrix4f;

public class PlaceAllCommand {
    public static void register(LiteralArgumentBuilder<class_2168> dispatcher, class_7157 commandBuildContext) {
        LiteralArgumentBuilder placeAll = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"place_all").requires(commandSourceStack -> commandSourceStack.method_9259(3) && commandSourceStack.method_9211().method_3724());
        placeAll.then(LiteralArgumentBuilder.literal((String)"templates").then(class_2170.method_9244((String)"mod_id", (ArgumentType)StringArgumentType.word()).suggests((context1, builder) -> class_2172.method_9265(ModPlatform.PLATFORM.getModIDS(), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"block", (ArgumentType)class_2257.method_9653((class_7157)commandBuildContext)).then(class_2170.method_9244((String)"depth", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            class_2247 blockInput = class_2257.method_9655((CommandContext)context, (String)"block");
            PlaceAllCommand.dumpTemplates(((class_2168)context.getSource()).method_9222(), ((class_2168)context.getSource()).method_9225(), StringArgumentType.getString((CommandContext)context, (String)"mod_id"), blockInput.method_9494(), IntegerArgumentType.getInteger((CommandContext)context, (String)"depth"));
            return 1;
        })))));
        placeAll.then(LiteralArgumentBuilder.literal((String)"features").then(class_2170.method_9244((String)"mod_id", (ArgumentType)StringArgumentType.word()).suggests((context1, builder) -> class_2172.method_9265(ModPlatform.PLATFORM.getModIDS(), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"block", (ArgumentType)class_2257.method_9653((class_7157)commandBuildContext)).then(class_2170.method_9244((String)"depth", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            class_2247 blockInput = class_2257.method_9655((CommandContext)context, (String)"block");
            PlaceAllCommand.dumpConfiguredFeatures(((class_2168)context.getSource()).method_9222(), ((class_2168)context.getSource()).method_9225(), StringArgumentType.getString((CommandContext)context, (String)"mod_id"), blockInput.method_9494(), IntegerArgumentType.getInteger((CommandContext)context, (String)"depth"));
            return 1;
        })))));
        placeAll.then(LiteralArgumentBuilder.literal((String)"structures").then(class_2170.method_9244((String)"mod_id", (ArgumentType)StringArgumentType.word()).suggests((context1, builder) -> class_2172.method_9265(ModPlatform.PLATFORM.getModIDS(), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"block", (ArgumentType)class_2257.method_9653((class_7157)commandBuildContext)).then(class_2170.method_9244((String)"depth", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            class_2247 blockInput = class_2257.method_9655((CommandContext)context, (String)"block");
            PlaceAllCommand.dumpStructures(((class_2168)context.getSource()).method_9222(), ((class_2168)context.getSource()).method_9225(), StringArgumentType.getString((CommandContext)context, (String)"mod_id"), blockInput.method_9494(), IntegerArgumentType.getInteger((CommandContext)context, (String)"depth"));
            return 1;
        })))));
        dispatcher.then((ArgumentBuilder)placeAll);
    }

    private static void dumpTemplates(class_243 position, class_3218 serverLevel, String modId, class_2680 state, int floorDepth) {
        class_3485 structureManager = serverLevel.method_14183();
        List<class_2960> list = structureManager.method_44226().filter(location -> location.method_12836().equalsIgnoreCase(modId)).sorted().toList();
        int size = list.size();
        int rowsAndCols = (int)Math.floor(Math.sqrt(size) / 2.0);
        PlaceAllCommand.generateObject(position, serverLevel, rowsAndCols, 48, state, floorDepth, (idx, pos) -> {
            class_2960 templateLocation = (class_2960)list.get((int)idx);
            class_3499 structureTemplate = (class_3499)structureManager.method_15094(templateLocation).get();
            structureTemplate.method_15172((class_5425)serverLevel, pos, pos, new class_3492(), serverLevel.field_9229, 2);
            class_2382 structureTemplateSize = structureTemplate.method_15160();
            PlaceAllCommand.generateText(serverLevel, class_243.method_24953((class_2382)pos.method_10069(structureTemplateSize.method_10263() / 2, structureTemplateSize.method_10264() + 3, structureTemplateSize.method_10260() / 2)), templateLocation.toString());
        });
    }

    public static void dumpConfiguredFeatures(class_243 position, class_3218 serverLevel, String modId, class_2680 state, int floorDepth) {
        List<class_6880.class_6883> list = ((class_2378)serverLevel.method_30349().method_33310(class_7924.field_41239).get()).method_40270().filter(reference -> reference.method_40237().method_29177().method_12836().equalsIgnoreCase(modId)).sorted(Comparator.comparing(holder -> holder.method_40237().method_29177())).toList();
        int size = list.size();
        int rowsAndCols = (int)Math.floor(Math.sqrt(size) / 2.0);
        PlaceAllCommand.generateObject(position, serverLevel, rowsAndCols, 32, state, floorDepth, (idx, offset) -> {
            class_6880.class_6883 configuredFeatureReference = (class_6880.class_6883)list.get((int)idx);
            String textComponent = "";
            if (!((class_2975)configuredFeatureReference.comp_349()).method_12862((class_5281)serverLevel, serverLevel.method_14178().method_12129(), serverLevel.field_9229, offset)) {
                textComponent = "Failed: ";
            }
            PlaceAllCommand.generateText(serverLevel, class_243.method_24953((class_2382)offset.method_10086(32)), textComponent + configuredFeatureReference.method_40237().method_29177().toString());
        });
    }

    public static void dumpStructures(class_243 position, class_3218 serverLevel, String modId, class_2680 state, int floorDepth) {
        List<class_6880.class_6883> list = ((class_2378)serverLevel.method_30349().method_33310(class_7924.field_41246).get()).method_40270().filter(reference -> reference.method_40237().method_29177().method_12836().equalsIgnoreCase(modId)).sorted(Comparator.comparing(holder -> holder.method_40237().method_29177())).toList();
        int size = list.size();
        int rowsAndCols = (int)Math.floor(Math.sqrt(size) / 2.0);
        PlaceAllCommand.generateObject(position, serverLevel, rowsAndCols, 512, state, floorDepth, (idx, offset) -> {
            class_6880.class_6883 structureReference = (class_6880.class_6883)list.get((int)idx);
            structureReference.method_40229().right().ifPresent(structure -> {
                class_2794 generator = serverLevel.method_14178().method_12129();
                class_3449 generatedStart = structure.method_41614(serverLevel.method_30349(), generator, generator.method_12098(), serverLevel.method_14178().method_41248(), serverLevel.method_14183(), serverLevel.method_8412(), new class_1923(offset), 0, (class_5539)serverLevel, biomeHolder -> true);
                class_3341 boundingBox = generatedStart.method_14969();
                class_1923 start = new class_1923(class_4076.method_18675((int)boundingBox.method_35415()), class_4076.method_18675((int)boundingBox.method_35417()));
                class_1923 end = new class_1923(class_4076.method_18675((int)boundingBox.method_35418()), class_4076.method_18675((int)boundingBox.method_35420()));
                class_1923.method_19281((class_1923)start, (class_1923)end).forEach(chunkPos -> generatedStart.method_14974((class_5281)serverLevel, serverLevel.method_27056(), generator, serverLevel.method_8409(), new class_3341(chunkPos.method_8326(), serverLevel.method_31607(), chunkPos.method_8328(), chunkPos.method_8327(), serverLevel.method_31600(), chunkPos.method_8329()), chunkPos));
            });
        });
    }

    public static void generateObject(class_243 position, class_3218 serverLevel, int rowsAndCols, int size, class_2680 floorBlock, int floorDepth, BiConsumer<Integer, class_2338> consumer) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        int templateIDX = 0;
        for (int x = -rowsAndCols; x <= rowsAndCols; ++x) {
            for (int z = -rowsAndCols; z <= rowsAndCols; ++z) {
                for (int xFill = 0; xFill <= size; ++xFill) {
                    for (int zFill = 0; zFill <= size; ++zFill) {
                        for (int y = 0; y < floorDepth; ++y) {
                            mutableBlockPos.method_10103((int)position.method_10216() + x * size + xFill, (int)position.field_1351 - y, (int)position.method_10215() + z * size + zFill);
                            serverLevel.method_30092((class_2338)mutableBlockPos, floorBlock, 2, 0);
                        }
                    }
                }
                mutableBlockPos.method_10102((double)((int)position.field_1352 + x * size + 16), position.field_1351 + 1.0, (double)((int)position.field_1350 + z * size + 16));
                consumer.accept(templateIDX, (class_2338)mutableBlockPos);
                ++templateIDX;
            }
        }
    }

    private static void generateText(class_3218 serverLevel, class_243 spawnPos, String displayText) {
        class_8113.class_8123 textDisplay = new class_8113.class_8123(class_1299.field_42457, (class_1937)serverLevel);
        textDisplay.method_33574(spawnPos);
        textDisplay.method_48911((class_2561)class_2561.method_43470((String)displayText));
        Matrix4f matrix = new Matrix4f();
        matrix.scale(5.0f);
        textDisplay.method_48849(new class_4590(matrix));
        textDisplay.method_48847(class_8113.class_8114.field_42409);
        serverLevel.method_8649((class_1297)textDisplay);
    }
}

