/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.nicerportals.mixin;

import java.util.HashSet;
import java.util.List;
import me.roundaround.nicerportals.NicerPortalsMod;
import me.roundaround.nicerportals.mixin.NetherPortalAccessor;
import me.roundaround.nicerportals.util.HashSetQueue;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2423;
import net.minecraft.class_2424;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2424.class})
public abstract class NetherPortalMixin {
    private boolean valid = false;
    HashSet<class_2338> validPortalPositions = new HashSet();
    int portalBlockCount = 0;
    @Shadow
    class_1936 field_11318;
    @Shadow
    class_2350 field_11314;
    @Shadow
    class_2350.class_2351 field_11317;

    @Inject(method={"method_30487(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/BlockView;Lnet/minecraft/util/math/BlockPos;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isValidFrameBlock(class_2680 state, class_1922 world, class_2338 pos, CallbackInfoReturnable<Boolean> info) {
        if (!((Boolean)NicerPortalsMod.CONFIG.MOD_ENABLED.getValue()).booleanValue() || !((Boolean)NicerPortalsMod.CONFIG.CRYING_OBSIDIAN.getValue()).booleanValue()) {
            return;
        }
        if (state.method_27852(class_2246.field_22423)) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void constructor(class_1936 world, class_2338 startPos, class_2350.class_2351 axis, CallbackInfo info) {
        if (!((Boolean)NicerPortalsMod.CONFIG.MOD_ENABLED.getValue()).booleanValue() || !((Boolean)NicerPortalsMod.CONFIG.ANY_SHAPE.getValue()).booleanValue()) {
            return;
        }
        this.valid = this.checkAreaForPortalValidity(startPos, axis);
    }

    private boolean checkAreaForPortalValidity(class_2338 startPos, class_2350.class_2351 axis) {
        this.validPortalPositions.clear();
        HashSet<class_2338> validFrameBlocks = new HashSet<class_2338>();
        HashSetQueue<class_2338> positionsToCheck = new HashSetQueue<class_2338>();
        boolean minSizeFound = false;
        List<class_2350> directions = List.of(class_2350.field_11033, class_2350.field_11036, this.field_11314, this.field_11314.method_10153());
        positionsToCheck.push(startPos);
        while (!positionsToCheck.isEmpty()) {
            class_2338 pos = (class_2338)positionsToCheck.pop();
            if (this.validPortalPositions.contains(pos) || validFrameBlocks.contains(pos)) continue;
            boolean isOrCanBePortal = this.isValidPosForPortalBlock(pos);
            boolean isFrameBlock = this.isValidFrameBlock(pos);
            if (!isOrCanBePortal && !isFrameBlock) {
                return false;
            }
            if (isOrCanBePortal) {
                this.validPortalPositions.add(pos);
                if (this.validPortalPositions.size() > (Integer)NicerPortalsMod.CONFIG.MAX_SIZE.getValue()) {
                    return false;
                }
                if (this.field_11318.method_8320(pos).method_27852(class_2246.field_10316)) {
                    ++this.portalBlockCount;
                }
                if (!minSizeFound && (this.validPortalPositions.contains(pos.method_10084()) || this.validPortalPositions.contains(pos.method_10074()))) {
                    minSizeFound = true;
                }
                directions.forEach(direction -> {
                    class_2338 neighborPos = pos.method_10093(direction);
                    if (!this.validPortalPositions.contains(neighborPos) && !validFrameBlocks.contains(neighborPos)) {
                        positionsToCheck.push(neighborPos);
                    }
                });
                continue;
            }
            validFrameBlocks.add(pos);
        }
        return minSizeFound || (Boolean)NicerPortalsMod.CONFIG.ENFORCE_MINIMUM.getValue() == false;
    }

    private boolean isValidPosForPortalBlock(class_2338 pos) {
        return NetherPortalAccessor.isValidStateInsidePortal(this.field_11318.method_8320(pos)) && !this.field_11318.method_31606(pos);
    }

    private boolean isValidFrameBlock(class_2338 pos) {
        return NetherPortalAccessor.getIsValidFrameBlock().test(this.field_11318.method_8320(pos), (class_1922)this.field_11318, pos) && !this.field_11318.method_31606(pos);
    }

    @Inject(method={"createPortal"}, at={@At(value="HEAD")}, cancellable=true)
    private void createPortal(CallbackInfo info) {
        if (!((Boolean)NicerPortalsMod.CONFIG.MOD_ENABLED.getValue()).booleanValue() || !((Boolean)NicerPortalsMod.CONFIG.ANY_SHAPE.getValue()).booleanValue()) {
            return;
        }
        class_2680 blockState = (class_2680)class_2246.field_10316.method_9564().method_11657((class_2769)class_2423.field_11310, (Comparable)this.field_11317);
        this.validPortalPositions.stream().forEach(pos -> this.field_11318.method_8652(pos, blockState, 18));
        info.cancel();
    }

    @Inject(method={"isValid"}, at={@At(value="HEAD")}, cancellable=true)
    private void isValid(CallbackInfoReturnable<Boolean> info) {
        if (!((Boolean)NicerPortalsMod.CONFIG.MOD_ENABLED.getValue()).booleanValue() || !((Boolean)NicerPortalsMod.CONFIG.ANY_SHAPE.getValue()).booleanValue()) {
            return;
        }
        info.setReturnValue((Object)this.valid);
    }

    @Inject(method={"wasAlreadyValid"}, at={@At(value="HEAD")}, cancellable=true)
    private void wasAlreadyValid(CallbackInfoReturnable<Boolean> info) {
        if (!((Boolean)NicerPortalsMod.CONFIG.MOD_ENABLED.getValue()).booleanValue() || !((Boolean)NicerPortalsMod.CONFIG.ANY_SHAPE.getValue()).booleanValue()) {
            return;
        }
        info.setReturnValue((Object)(this.valid && this.validPortalPositions.size() == this.portalBlockCount ? 1 : 0));
    }
}

