/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.nicerportals.roundalib.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_7919;

public class IconButtonWidget
extends class_4185 {
    protected static final int DEFAULT_SIZE = 20;
    protected static final int DEFAULT_TEXTURE_SIZE = 256;
    protected final int iconU;
    protected final int iconV;
    protected final int textureSize;
    protected final class_2960 texture;

    protected IconButtonWidget(int x, int y, int width, int height, int iconU, int iconV, int textureSize, class_2960 texture, class_4185.class_4241 onPress, class_7919 tooltip) {
        super(x, y, width, height, (class_2561)class_2561.method_43473(), onPress, field_40754);
        this.iconU = iconU;
        this.iconV = iconV;
        this.textureSize = textureSize;
        this.texture = texture;
        if (tooltip != null) {
            this.method_47400(tooltip);
        }
    }

    public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
        super.method_48579(drawContext, mouseX, mouseY, delta);
        float brightness = this.field_22763 ? 1.0f : 0.6f;
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        drawContext.method_25290(this.texture, this.method_46426(), this.method_46427(), (float)this.iconU, (float)this.iconV, this.field_22758, this.field_22759, this.textureSize, this.textureSize);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static Builder builder(class_2960 texture, class_4185.class_4241 onPress) {
        return new Builder(texture, onPress);
    }

    public static class Builder {
        private final class_2960 texture;
        private final class_4185.class_4241 onPress;
        private int size = 20;
        private int x;
        private int y;
        private int iconU;
        private int iconV;
        private int textureSize = 256;
        private boolean autoCalculateUV = false;
        private int textureIndex;
        private int autoCalculateStartX = 0;
        private int autoCalculateStartY = 0;
        private class_7919 tooltip = null;

        public Builder(class_2960 texture, class_4185.class_4241 onPress) {
            this.texture = texture;
            this.onPress = onPress;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder position(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder uv(int u, int v) {
            this.iconU = u;
            this.iconV = v;
            return this;
        }

        public Builder textureSize(int textureSize) {
            this.textureSize = textureSize;
            return this;
        }

        public Builder autoCalculateUV(int textureIndex) {
            this.autoCalculateUV = true;
            this.textureIndex = textureIndex;
            return this;
        }

        public Builder autoCalculateUV(int textureIndex, int startX, int startY) {
            this.autoCalculateStartX = startX;
            this.autoCalculateStartY = startY;
            return this.autoCalculateUV(textureIndex);
        }

        public Builder tooltip(class_7919 tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder tooltip(class_2561 tooltip) {
            return this.tooltip(class_7919.method_47407((class_2561)tooltip));
        }

        public IconButtonWidget build() {
            int u = this.iconU;
            int v = this.iconV;
            if (this.autoCalculateUV) {
                int workableWidth = this.textureSize - this.autoCalculateStartX;
                int iconsPerRow = workableWidth / this.size;
                u = this.autoCalculateStartX + this.textureIndex % iconsPerRow * this.size;
                v = this.autoCalculateStartY + this.textureIndex / iconsPerRow * this.size;
            }
            return new IconButtonWidget(this.x, this.y, this.size, this.size, u, v, this.textureSize, this.texture, this.onPress, this.tooltip);
        }
    }
}

