/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1058;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_2487;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import tfar.davespotioneering.DavesPotioneering;
import tfar.davespotioneering.init.ModSoundEvents;
import tfar.davespotioneering.item.GauntletItem;
import tfar.davespotioneering.mixin.IngameGuiAccess;

public class GauntletHUD {
    public static final class_2960 GAUNTLET_ICON_LOC = new class_2960("davespotioneering", "textures/gauntlet_icons/");
    private static final int TEX_H = 41;
    static final int TEX_HEIGHT = 41;
    static final int TEX_WIDTH = 121;
    private static class_1842 activePotion = null;
    private static class_1842 prePotion = null;
    private static class_1842 postPotion = null;
    private static final class_2960 hud_texture = GauntletHUD.getGauntletIconLoc("hud");
    public static final class_310 mc = class_310.method_1551();
    private static boolean forwardCycle = false;
    private static boolean backwardCycle = false;
    private static final int maxCooldown = 40;
    private static int cooldown = 40;

    public static class_2960 getGauntletIconLoc(String fileName) {
        return new class_2960(GAUNTLET_ICON_LOC.method_12836(), GAUNTLET_ICON_LOC.method_12832() + fileName + ".png");
    }

    public static void init(class_1842 activePotion, class_1842 prePotion, class_1842 postPotion) {
        GauntletHUD.activePotion = activePotion;
        GauntletHUD.prePotion = prePotion;
        GauntletHUD.postPotion = postPotion;
    }

    public static void render(class_332 matrixStack) {
        class_746 player;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_329 hud = GauntletHUD.mc.field_1705;
        int fade = ((IngameGuiAccess)hud).getToolHighlightTimer();
        int windowW = mc.method_22683().method_4486();
        int windowH = mc.method_22683().method_4502();
        int xFixed = class_3532.method_15340((int)((windowW + DavesPotioneering.CONFIG.gauntlet_hud_x) / 2), (int)0, (int)(windowW - 120));
        int yFixed = class_3532.method_15340((int)(windowH + DavesPotioneering.CONFIG.gauntlet_hud_y), (int)0, (int)(windowH - 41));
        if (DavesPotioneering.CONFIG.gauntlet_hud_preset == Preset.ABOVE_HOTBAR) {
            int height = 91;
            if (fade > 0) {
                height += 10;
            }
            yFixed = windowH - height;
        }
        if (forwardCycle) {
            matrixStack.method_25291(hud_texture, xFixed, yFixed, 0, 0.0f, 87.0f, 120, 41, 128, 128);
            if (--cooldown <= 0) {
                mc.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)ModSoundEvents.GAUNTLET_SCROLL, (float)1.0f));
                forwardCycle = false;
                cooldown = 40;
            }
        } else if (backwardCycle) {
            matrixStack.method_25291(hud_texture, xFixed, yFixed, 0, 0.0f, 44.0f, 120, 41, 128, 128);
            if (--cooldown <= 0) {
                mc.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)ModSoundEvents.GAUNTLET_SCROLL, (float)1.0f));
                backwardCycle = false;
                cooldown = 40;
            }
        } else {
            matrixStack.method_25291(hud_texture, xFixed, yFixed, 0, 0.0f, 1.0f, 120, 41, 128, 128);
        }
        if ((player = class_310.method_1551().field_1724) == null) {
            return;
        }
        class_1799 g = player.method_6047();
        class_2487 info = g.method_7948().method_10562("info");
        GauntletHUD.renderPotion(prePotion, matrixStack, xFixed + 3, yFixed + 21, GauntletItem.getCooldownFromPotionByIndex(info.method_10550("activePotionIndex") - 1, g));
        GauntletHUD.renderPotion(activePotion, matrixStack, xFixed + 51, yFixed + 5, GauntletItem.getCooldownFromPotionByIndex(info.method_10550("activePotionIndex"), g));
        GauntletHUD.renderPotion(postPotion, matrixStack, xFixed + 99, yFixed + 21, GauntletItem.getCooldownFromPotionByIndex(info.method_10550("activePotionIndex") + 1, g));
    }

    private static void renderPotion(class_1842 potion, class_332 matrixStack, int x, int y, int cooldown) {
        if (potion == null) {
            return;
        }
        if (potion.method_8049().isEmpty()) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (potion.method_8049().size() > 1) {
            String name = class_7923.field_41179.method_10221((Object)potion).toString();
            class_2960 resourceLocation = name.contains("turtle_master") ? GauntletHUD.getGauntletIconLoc("turtle_master") : (mc.method_1478().method_14486(GauntletHUD.getGauntletIconLoc(name)).isPresent() ? GauntletHUD.getGauntletIconLoc(name) : GauntletHUD.getGauntletIconLoc("unknown"));
            matrixStack.method_25291(resourceLocation, x, y, 0, 0.0f, 0.0f, 18, 18, 18, 18);
        } else {
            class_1291 effect = ((class_1293)potion.method_8049().get(0)).method_5579();
            class_1058 sprite = mc.method_18505().method_18663(effect);
            matrixStack.method_25298(x, y, 0, 18, 18, sprite);
        }
        if (cooldown > 0) {
            if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                matrixStack.method_25303(GauntletHUD.mc.field_1772, "" + cooldown, x, y - 20, 0xFF0000);
            }
            int w = 18;
            int scale = GauntletHUD.getScaledCooldown(w, cooldown);
            matrixStack.method_25294(x, y + w - scale, x + 18, y + w, Integer.MAX_VALUE);
        }
    }

    private static int getScaledCooldown(float pixels, float cooldown) {
        float totalCooldown = DavesPotioneering.CONFIG.gauntlet_cooldown;
        float progress = totalCooldown - cooldown;
        if (totalCooldown != 0.0f) {
            float result = progress * pixels / totalCooldown;
            return Math.round(result);
        }
        return 0;
    }

    private static void draw(class_287 renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        renderer.method_22912((double)x, (double)y, 0.0).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22912((double)x, (double)(y + height), 0.0).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22912((double)(x + width), (double)(y + height), 0.0).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22912((double)(x + width), (double)y, 0.0).method_1336(red, green, blue, alpha).method_1344();
        class_289.method_1348().method_1350();
    }

    public static void forwardCycle() {
        forwardCycle = true;
    }

    public static void backwardCycle() {
        backwardCycle = true;
    }

    public static enum Preset {
        TOP_LEFT,
        TOP_RIGHT,
        BTM_LEFT,
        BTM_RIGHT,
        ABOVE_HOTBAR,
        FREE_MOVE;

    }
}

