/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1836;
import net.minecraft.class_1842;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import tfar.davespotioneering.DavesPotioneering;
import tfar.davespotioneering.init.ModSoundEvents;
import tfar.davespotioneering.item.Perspective;

public class GauntletItem
extends class_1829
implements Perspective {
    public static final class_2960 ALC_ID = new class_2960("davespotioneering", "item/sprite/potioneer_gauntlet");
    public static final class_2960 LIT_ALC_ID = new class_2960("davespotioneering", "item/sprite/lit_potioneer_gauntlet");

    public GauntletItem(class_1792.class_1793 properties) {
        super((class_1832)class_1834.field_22033, 4, -2.8f, properties);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 playerIn, class_1268 handIn) {
        class_1799 stack = playerIn.method_5998(handIn);
        if (playerIn.method_5715()) {
            boolean active = stack.method_7948().method_10577("active");
            int blaze = stack.method_7936() - stack.method_7919();
            if (!world.field_9236 && (blaze > 0 || active)) {
                stack.method_7948().method_10556("active", !active);
                world.method_43128(null, playerIn.method_23317(), playerIn.method_23318(), playerIn.method_23321(), active ? ModSoundEvents.GAUNTLET_TURNING_OFF : ModSoundEvents.GAUNTLET_TURNING_ON, class_3419.field_15248, 0.5f, 1.0f);
            }
            return class_1271.method_22427((Object)stack);
        }
        return class_1271.method_22430((Object)stack);
    }

    public boolean method_7846() {
        return false;
    }

    public boolean method_7870(class_1799 stack) {
        return stack.method_7947() == 1;
    }

    public int getRGBDurabilityForDisplay(class_1799 stack) {
        return class_124.field_1065.method_532();
    }

    public boolean method_7873(class_1799 stack, class_1309 victim, class_1309 attacker) {
        if (stack.method_7909() instanceof GauntletItem) {
            class_2487 info = stack.method_7948().method_10562("info");
            class_1842[] potions = GauntletItem.getPotionsFromNBT(info);
            if (attacker instanceof class_1657) {
                boolean active = stack.method_7969().method_10577("active");
                if (potions != null && GauntletItem.getCooldownFromPotionByIndex(info.method_10550("activePotionIndex"), stack) <= 0 && stack.method_7936() - stack.method_7919() > 0 && active) {
                    class_2499 cooldownMap;
                    class_1842 potion = potions[0];
                    for (class_1293 effectInstance : potion.method_8049()) {
                        victim.method_6092(new class_1293(effectInstance));
                    }
                    stack.method_7956(1, attacker, livingEntity -> {});
                    if (stack.method_7919() == stack.method_7936()) {
                        stack.method_7969().method_10556("active", false);
                    }
                    if (info.method_10580("potionCooldownMap") instanceof class_2499) {
                        cooldownMap = (class_2499)info.method_10580("potionCooldownMap");
                    } else {
                        cooldownMap = new class_2499();
                        cooldownMap.method_10531(0, (class_2520)new class_2495(new ArrayList()));
                        cooldownMap.method_10531(1, (class_2520)new class_2495(new ArrayList()));
                    }
                    GauntletItem.addPotionCooldownByIndex(info.method_10550("activePotionIndex"), DavesPotioneering.CONFIG.gauntlet_cooldown, stack, cooldownMap);
                }
            }
        }
        return true;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        class_3545<List<class_1293>, List<class_1842>> tuple;
        super.method_7851(stack, worldIn, tooltip, flagIn);
        tooltip.add((class_2561)class_2561.method_43471((String)(this.method_7876() + ".hold_shift.desc")));
        if (class_437.method_25442()) {
            tooltip.add((class_2561)this.getShiftDescription().method_27692(class_124.field_1080));
        }
        tooltip.add((class_2561)class_2561.method_43471((String)(this.method_7876() + ".hold_ctrl.desc")));
        if (class_437.method_25441()) {
            tooltip.add((class_2561)this.getCtrlDescription().method_27692(class_124.field_1080));
        }
        if ((tuple = GauntletItem.getEffectsFromGauntlet(stack)) == null) {
            return;
        }
        if (((List)tuple.method_15442()).isEmpty()) {
            return;
        }
        tooltip.add((class_2561)class_2561.method_43470((String)" "));
        for (class_1293 instance : (List)tuple.method_15442()) {
            class_5250 product;
            class_5250 effectFormatted = class_2561.method_43471((String)instance.method_5586());
            effectFormatted.method_27692(instance.method_5579().method_18792().method_18793());
            class_5250 amplifier = class_2561.method_43470((String)"");
            if (instance.method_5578() > 0) {
                amplifier = class_2561.method_43470((String)String.valueOf(instance.method_5578()));
            }
            if (instance.method_5584() > 1) {
                class_5250 duration = (class_5250)class_1292.method_5577((class_1293)instance, (float)1.0f);
                product = class_2561.method_43469((String)"davespotioneering.tooltip.gauntlet.withDuration", (Object[])new Object[]{effectFormatted, amplifier, duration});
            } else {
                product = class_2561.method_43469((String)"davespotioneering.tooltip.gauntlet", (Object[])new Object[]{effectFormatted, amplifier});
            }
            tooltip.add((class_2561)product);
        }
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int itemSlot, boolean isSelected) {
        super.method_7888(stack, world, entity, itemSlot, isSelected);
        if (entity instanceof class_1657 && !entity.method_5770().method_8608()) {
            GauntletItem.modifyCooldowns(stack, cd -> {
                if (cd > 0) {
                    cd = cd - 1;
                }
                return cd;
            });
        }
    }

    public class_5250 getShiftDescription() {
        return class_2561.method_43471((String)(this.method_7876() + ".shift.desc"));
    }

    public class_5250 getCtrlDescription() {
        return class_2561.method_43471((String)(this.method_7876() + ".ctrl.desc"));
    }

    @Nullable
    public static class_3545<List<class_1293>, List<class_1842>> getEffectsFromGauntlet(class_1799 stack) {
        if (!stack.method_7985()) {
            return null;
        }
        class_2499 nbts = stack.method_7969().method_10562("info").method_10554("potions", 8);
        ArrayList effects = new ArrayList();
        ArrayList<class_1842> potions = new ArrayList<class_1842>();
        for (class_2520 inbt : nbts) {
            if (!(inbt instanceof class_2519)) continue;
            class_2519 stringNBT = (class_2519)inbt;
            class_1842 potion = (class_1842)class_7923.field_41179.method_10223(new class_2960(stringNBT.method_10714()));
            effects.addAll(potion.method_8049());
            potions.add(potion);
        }
        return new class_3545(effects, potions);
    }

    public static void cycleGauntletForward(class_1657 player) {
        if (player == null) {
            return;
        }
        class_2487 info = player.method_6047().method_7948().method_10562("info");
        class_2499 nbts = info.method_10554("potions", 8);
        if (nbts.isEmpty()) {
            return;
        }
        int index = info.method_10550("activePotionIndex");
        if (++index > 5) {
            index = 0;
        }
        info.method_10569("activePotionIndex", index);
    }

    public static void cycleGauntletBackward(class_1657 player) {
        if (player == null) {
            return;
        }
        class_2487 info = player.method_6047().method_7948().method_10562("info");
        class_2499 nbts = info.method_10554("potions", 8);
        if (nbts.isEmpty()) {
            return;
        }
        int index = info.method_10550("activePotionIndex");
        if (--index < 0) {
            index = 5;
        }
        info.method_10569("activePotionIndex", index);
    }

    public static class_1842[] getPotionsFromNBT(class_2487 info) {
        class_2520 pre;
        class_2499 nbts = info.method_10554("potions", 8);
        if (nbts.isEmpty()) {
            return null;
        }
        int index = info.method_10550("activePotionIndex");
        if (--index < 0) {
            index = 5;
        }
        if ((pre = nbts.method_10534(index)) == null) {
            return null;
        }
        index += 2;
        class_2520 post = nbts.method_10534(index %= 6);
        if (post == null) {
            return null;
        }
        class_1842 activePotion = (class_1842)class_7923.field_41179.method_10223(new class_2960(nbts.method_10534(info.method_10550("activePotionIndex")).method_10714()));
        class_1842 prePotion = (class_1842)class_7923.field_41179.method_10223(new class_2960(pre.method_10714()));
        class_1842 postPotion = (class_1842)class_7923.field_41179.method_10223(new class_2960(post.method_10714()));
        return new class_1842[]{activePotion, prePotion, postPotion};
    }

    public static class_2499 addPotionCooldownByIndex(int index, int cooldown, class_1799 stack, class_2499 cooldownMap) {
        class_2487 info = stack.method_7948().method_10562("info");
        if (cooldownMap.method_10534(0) instanceof class_2495 && cooldownMap.method_10534(1) instanceof class_2495) {
            class_2495 indexArray = (class_2495)cooldownMap.method_10534(0);
            class_2495 cooldownArray = (class_2495)cooldownMap.method_10534(1);
            indexArray.add((Object)class_2497.method_23247((int)index));
            cooldownArray.add((Object)class_2497.method_23247((int)cooldown));
            class_2499 list = new class_2499();
            list.method_10531(0, (class_2520)indexArray);
            list.method_10531(1, (class_2520)cooldownArray);
            info.method_10566("potionCooldownMap", (class_2520)list);
            return list;
        }
        return cooldownMap;
    }

    public static int getCooldownFromPotionByIndex(int indexOfPotion, class_1799 stack) {
        class_2499 cooldownMap;
        class_2487 info = stack.method_7948().method_10562("info");
        class_2520 inbt = info.method_10580("potionCooldownMap");
        if (inbt instanceof class_2499 && (cooldownMap = (class_2499)inbt).method_10534(0) instanceof class_2495 && cooldownMap.method_10534(1) instanceof class_2495) {
            class_2495 indexArray = (class_2495)cooldownMap.method_10534(0);
            class_2495 cooldownArray = (class_2495)cooldownMap.method_10534(1);
            try {
                int indexOfPotionIndex = GauntletItem.toList(indexArray.method_10588()).indexOf(indexOfPotion);
                return GauntletItem.toList(cooldownArray.method_10588()).get(indexOfPotionIndex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public static void modifyCooldowns(class_1799 gauntlet, Function<Integer, Integer> modifier) {
        class_2499 map;
        class_2520 class_25202;
        class_2487 info = gauntlet.method_7948().method_10562("info");
        class_2520 inbt = info.method_10580("potionCooldownMap");
        if (inbt instanceof class_2499 && (class_25202 = (map = (class_2499)inbt).method_10534(0)) instanceof class_2495) {
            class_2495 indexArray = (class_2495)class_25202;
            class_25202 = map.method_10534(1);
            if (class_25202 instanceof class_2495) {
                class_2495 cooldownArray = (class_2495)class_25202;
                if (cooldownArray.isEmpty() || indexArray.isEmpty()) {
                    return;
                }
                if (cooldownArray.method_10588().length != indexArray.method_10588().length) {
                    return;
                }
                ArrayList<Integer> cooldownList = new ArrayList<Integer>();
                ArrayList<Integer> indexList = new ArrayList<Integer>();
                for (int i = 0; i < cooldownArray.method_10588().length; ++i) {
                    int modified = modifier.apply(cooldownArray.method_10588()[i]);
                    if (modified <= 0) continue;
                    cooldownList.add(modified);
                    indexList.add(indexArray.method_10588()[i]);
                }
                class_2495 newArray = new class_2495(cooldownList);
                class_2495 newArrayIndex = new class_2495(indexList);
                map.method_10606(1, (class_2520)newArray);
                map.method_10606(0, (class_2520)newArrayIndex);
            }
        }
    }

    public static List<Integer> toList(int ... in) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i : in) {
            list.add(i);
        }
        return list;
    }

    @Override
    public class_2960 getGuiModel(boolean active) {
        return active ? LIT_ALC_ID : ALC_ID;
    }
}

