/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.entity;

import com.google.common.base.Suppliers;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.entity.BattleStandardDarkEntity;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class BattleStandardEntity
extends class_1314 {
    public static final Supplier<class_1299<BattleStandardEntity>> TYPE = Suppliers.memoize(() -> class_1299.class_1300.method_5903(BattleStandardEntity::new, (class_1311)class_1311.field_17715).method_5905("battlestandard"));
    float abilityDamage = Config.getFloat("righteousStandardDamage", "UniqueEffects", ConfigDefaultValues.righteousStandardDamage);
    float abilityHeal = 3.0f;
    float abilityHealScalingModifier = Config.getFloat("righteousStandardSpellScalingHeal", "UniqueEffects", ConfigDefaultValues.righteousStandardSpellScalingHeal);
    float spellScalingModifier = Config.getFloat("righteousStandardSpellScaling", "UniqueEffects", ConfigDefaultValues.righteousStandardSpellScaling);
    public class_1309 ownerEntity;
    public String standardType;
    public int decayRate;
    public String positiveEffect;
    public String positiveEffectSecondary;
    public int positiveEffectAmplifier;
    public String negativeEffect;
    public String negativeEffectSecondary;
    public int negativeEffectAmplifier;
    public boolean dealsDamage = true;
    public boolean doesHealing = true;
    private static boolean errorLogged = false;

    public static class_5132.class_5133 createBattleStandardAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 150.0).method_26868(class_5134.field_23719, 0.0).method_26868(class_5134.field_23718, 100.0);
    }

    public BattleStandardEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
    }

    private static void errorCatch(String identifier) {
        if (!errorLogged) {
            System.out.println("ERROR: Identifier " + identifier + " does not match any registered effects.\nDestroying banner entity now.");
            errorLogged = true;
        }
    }

    protected boolean method_6062() {
        return true;
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5643(class_1282 source, float amount) {
        return this.ownerEntity == null;
    }

    public void method_5670() {
        if (!this.method_37908().method_8608()) {
            if (this.field_6012 % 10 == 0) {
                this.method_6033(this.method_6032() - (float)this.decayRate);
                if (this.ownerEntity == null) {
                    this.method_6033(this.method_6032() - 1000.0f);
                }
            }
            if (this.ownerEntity != null && this.standardType != null) {
                class_1309 le;
                class_238 box;
                if (!this.ownerEntity.method_5805()) {
                    this.method_6033(this.method_6032() - 1000.0f);
                }
                int radius = 6;
                if (HelperMethods.commonSpellAttributeScaling(this.spellScalingModifier, (class_1297)this.ownerEntity, "fire") > 0.0f) {
                    this.abilityDamage = HelperMethods.commonSpellAttributeScaling(this.spellScalingModifier, (class_1297)this.ownerEntity, "fire");
                }
                if (this.field_6012 % 10 == 0) {
                    box = new class_238(this.method_23317() + (double)radius, this.method_23318() + (double)((float)radius / 3.0f), this.method_23321() + (double)radius, this.method_23317() - (double)radius, this.method_23318() - (double)((float)radius / 3.0f), this.method_23321() - (double)radius);
                    block28: for (class_1297 entity : this.method_37908().method_8333((class_1297)this, box, class_1301.field_6157)) {
                        if (!(entity instanceof class_1309) || !HelperMethods.checkFriendlyFire(le = (class_1309)entity, this.ownerEntity) || le == this.ownerEntity || le instanceof BattleStandardEntity || le instanceof BattleStandardDarkEntity) continue;
                        block9 : switch (this.standardType) {
                            case "sunfire": {
                                le.method_5643(this.ownerEntity.method_48923().method_48831(), this.abilityDamage);
                                le.method_5639(1);
                                le.method_37222(new class_1293(class_1294.field_5909, 120, 1), (class_1297)this);
                                break;
                            }
                            case "nullification": {
                                for (class_1293 statusEffect : le.method_6026()) {
                                    if (statusEffect == null || !statusEffect.method_5579().method_5573()) continue;
                                    le.method_6016(statusEffect.method_5579());
                                    break block9;
                                }
                                continue block28;
                            }
                            case "api": {
                                if (this.dealsDamage) {
                                    le.method_5643(this.ownerEntity.method_48923().method_48831(), this.abilityDamage);
                                }
                                if (this.negativeEffect != null) {
                                    try {
                                        le.method_37222(new class_1293((class_1291)class_7923.field_41174.method_10223(new class_2960(this.negativeEffect)), 20, this.negativeEffectAmplifier), (class_1297)this);
                                    }
                                    catch (Exception e) {
                                        BattleStandardEntity.errorCatch(this.negativeEffect);
                                        this.method_6033(this.method_6032() - 1000.0f);
                                    }
                                }
                                if (this.negativeEffectSecondary == null) break;
                                try {
                                    le.method_37222(new class_1293((class_1291)class_7923.field_41174.method_10223(new class_2960(this.negativeEffectSecondary)), 20, this.negativeEffectAmplifier), (class_1297)this);
                                    break;
                                }
                                catch (Exception e) {
                                    BattleStandardEntity.errorCatch(this.negativeEffectSecondary);
                                    this.method_6033(this.method_6032() - 1000.0f);
                                }
                            }
                        }
                    }
                    HelperMethods.spawnParticle(this.method_37908(), (class_2394)class_2398.field_11239, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                }
                if (this.method_6032() > this.method_6063() - 2.0f && this.method_24828()) {
                    HelperMethods.spawnParticle(this.method_37908(), (class_2394)class_2398.field_11239, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.3, 0.0);
                    HelperMethods.spawnParticle(this.method_37908(), (class_2394)class_2398.field_17430, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.1, 0.0);
                    box = new class_238(this.method_23317() + 1.0, this.method_23318() + 1.0, this.method_23321() + 1.0, this.method_23317() - 1.0, this.method_23318() - 1.0, this.method_23321() - 1.0);
                    for (class_1297 entity : this.method_37908().method_8333((class_1297)this, box, class_1301.field_6157)) {
                        if (!(entity instanceof class_1309) || !HelperMethods.checkFriendlyFire(le = (class_1309)entity, this.ownerEntity) || le == this.ownerEntity) continue;
                        le.method_5643(this.ownerEntity.method_48923().method_48831(), this.abilityDamage * 3.0f);
                        le.method_5639(1);
                        le.method_18800((le.method_23317() - this.method_23317()) / 4.0, 0.5, (le.method_23321() - this.method_23321()) / 4.0);
                    }
                }
                if (this.field_6012 % 80 == 0) {
                    box = new class_238(this.method_23317() + (double)radius, this.method_23318() + (double)((float)radius / 3.0f), this.method_23321() + (double)radius, this.method_23317() - (double)radius, this.method_23318() - (double)((float)radius / 3.0f), this.method_23321() - (double)radius);
                    block31: for (class_1297 entities : this.method_37908().method_8333((class_1297)this, box, class_1301.field_6157)) {
                        if (!(entities instanceof class_1309) || HelperMethods.checkFriendlyFire(le = (class_1309)entities, this.ownerEntity)) continue;
                        if (HelperMethods.commonSpellAttributeScaling(this.abilityHealScalingModifier, (class_1297)this.ownerEntity, "healing") > 0.0f) {
                            this.abilityHeal = HelperMethods.commonSpellAttributeScaling(this.abilityHealScalingModifier, (class_1297)this.ownerEntity, "healing");
                        }
                        block19 : switch (this.standardType) {
                            case "sunfire": {
                                le.method_6025(this.abilityHeal);
                                le.method_37222(new class_1293(class_1294.field_5910, 90, 1), (class_1297)this);
                                break;
                            }
                            case "nullification": {
                                for (class_1293 statusEffect : le.method_6026()) {
                                    if (statusEffect == null || statusEffect.method_5579().method_5573() || Objects.equals(statusEffect.method_5579(), EffectRegistry.BATTLE_FATIGUE.get())) continue;
                                    le.method_6016(statusEffect.method_5579());
                                    break block19;
                                }
                                continue block31;
                            }
                            case "api": {
                                if (this.doesHealing) {
                                    le.method_6025(this.abilityHeal);
                                }
                                if (this.positiveEffect != null) {
                                    try {
                                        le.method_37222(new class_1293((class_1291)class_7923.field_41174.method_10223(new class_2960(this.positiveEffect)), 85, this.positiveEffectAmplifier), (class_1297)this);
                                    }
                                    catch (Exception e) {
                                        BattleStandardEntity.errorCatch(this.positiveEffect);
                                        this.method_6033(this.method_6032() - 1000.0f);
                                    }
                                }
                                if (this.positiveEffectSecondary == null) break;
                                try {
                                    le.method_37222(new class_1293((class_1291)class_7923.field_41174.method_10223(new class_2960(this.positiveEffectSecondary)), 85, this.positiveEffectAmplifier), (class_1297)this);
                                    break;
                                }
                                catch (Exception e) {
                                    BattleStandardEntity.errorCatch(this.positiveEffectSecondary);
                                    this.method_6033(this.method_6032() - 1000.0f);
                                }
                            }
                        }
                    }
                    this.method_37908().method_43129(null, (class_1297)this, (class_3414)SoundRegistry.ELEMENTAL_BOW_EARTH_SHOOT_IMPACT_02.get(), this.method_5634(), 0.1f, 0.6f);
                    double xpos = this.method_23317() - (double)(radius + 1);
                    double ypos = this.method_23318();
                    double zpos = this.method_23321() - (double)(radius + 1);
                    for (int i = radius * 2; i > 0; --i) {
                        for (int j = radius * 2; j > 0; --j) {
                            float choose = (float)(Math.random() * 1.0);
                            if (!((double)choose > 0.5)) continue;
                            HelperMethods.spawnParticle(this.method_37908(), (class_2394)class_2398.field_17430, xpos + (double)i + (double)choose, ypos, zpos + (double)j + (double)choose, 0.0, -0.1, 0.0);
                        }
                    }
                }
            }
        }
        super.method_5670();
    }
}

