/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3414;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.AbilityMethods;
import net.sweenus.simplyswords.util.HelperMethods;

public class LichbladeSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;
    public static boolean scalesWithSpellPower;
    float overallAbsorptionCap = Config.getFloat("abilityAbsorptionCap", "UniqueEffects", ConfigDefaultValues.abilityAbsorptionCap);
    int radius = (int)Config.getFloat("soulAnguishRadius", "UniqueEffects", ConfigDefaultValues.soulAnguishRadius);
    float absorptionCap = Config.getFloat("soulAnguishAbsorptionCap", "UniqueEffects", ConfigDefaultValues.soulAnguishAbsorptionCap);
    float abilityDamage = Config.getFloat("soulAnguishDamage", "UniqueEffects", ConfigDefaultValues.soulAnguishDamage);
    int maxDuration = (int)Config.getFloat("soulAnguishDuration", "UniqueEffects", ConfigDefaultValues.soulAnguishDuration);
    int skillCooldown = (int)Config.getFloat("soulAnguishCooldown", "UniqueEffects", ConfigDefaultValues.soulAnguishCooldown);
    float healAmount = Config.getFloat("soulAnguishHeal", "UniqueEffects", ConfigDefaultValues.soulAnguishHeal);
    int range = (int)Config.getFloat("soulAnguishRange", "UniqueEffects", ConfigDefaultValues.soulAnguishRange);
    float spellScalingModifier = Config.getFloat("soulAnguishSpellScaling", "UniqueEffects", ConfigDefaultValues.soulAnguishSpellScaling);
    public int damageTracker = 0;
    double lastX;
    double lastY;
    double lastZ;
    double targetX;
    double targetY;
    double targetZ;
    class_1309 abilityTarget;

    public LichbladeSwordItem(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        HelperMethods.playHitSounds(attacker, target);
        return super.method_7873(stack, target, attacker);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (itemStack.method_7919() >= itemStack.method_7936() - 1) {
            return class_1271.method_22431((Object)itemStack);
        }
        if (itemStack.method_31574((class_1792)ItemsRegistry.SLUMBERING_LICHBLADE.get())) {
            return class_1271.method_22430((Object)itemStack);
        }
        this.abilityTarget = (class_1309)HelperMethods.getTargetedEntity((class_1297)user, this.range);
        if (this.abilityTarget != null) {
            this.abilityTarget.method_37222(new class_1293(class_1294.field_5912, 10, 0), (class_1297)user);
            world.method_43129(null, (class_1297)user, (class_3414)SoundRegistry.DARK_SWORD_ENCHANT.get(), user.method_5634(), 0.5f, 0.5f);
            this.lastX = user.method_23317();
            this.lastY = user.method_23318();
            this.lastZ = user.method_23321();
        }
        user.method_6019(hand);
        return class_1271.method_22428((Object)itemStack);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (!world.method_8608() && user.method_6118(class_1304.field_6173) == stack && this.abilityTarget != null) {
            if (stack.method_31574((class_1792)ItemsRegistry.AWAKENED_LICHBLADE.get())) {
                if (this.abilityTarget.method_29504() || this.abilityTarget == user || remainingUseTicks < this.maxDuration) {
                    this.abilityTarget = user;
                    if (user.method_5649(this.lastX, this.lastY, this.lastZ) < (double)this.radius) {
                        user.method_6073(Math.min(this.overallAbsorptionCap, user.method_6067() + Math.min((float)this.damageTracker / 2.0f, this.absorptionCap)));
                        user.method_6075();
                        world.method_43129(null, (class_1297)user, (class_3414)SoundRegistry.DARK_SWORD_SPELL.get(), user.method_5634(), 0.04f, 0.5f);
                    }
                }
            } else if (stack.method_31574((class_1792)ItemsRegistry.WAKING_LICHBLADE.get()) && (this.abilityTarget.method_29504() || remainingUseTicks < this.maxDuration)) {
                user.method_6075();
            }
            if (user.field_6012 % 5 == 0) {
                this.targetX = this.abilityTarget.method_23317();
                this.targetY = this.abilityTarget.method_23318();
                this.targetZ = this.abilityTarget.method_23321();
                if (this.targetX > this.lastX) {
                    this.lastX += 1.0;
                }
                if (this.targetX < this.lastX) {
                    this.lastX -= 1.0;
                }
                if (this.targetZ > this.lastZ) {
                    this.lastZ += 1.0;
                }
                if (this.targetZ < this.lastZ) {
                    this.lastZ -= 1.0;
                }
                if (this.targetY > this.lastY) {
                    this.lastY += 1.0;
                }
                if (this.targetY < this.lastY) {
                    this.lastY -= 1.0;
                }
            }
            AbilityMethods.tickAbilitySoulAnguish(stack, world, user, this.abilityDamage, this.radius, this.lastX, this.lastY, this.lastZ, this.healAmount, this.abilityTarget);
        }
    }

    public int method_7881(class_1799 stack) {
        return this.maxDuration * 2;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8947;
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        this.damageTracker = 0;
        if (!world.field_9236 && user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            if (this.abilityTarget != null) {
                player.method_7357().method_7906(stack.method_7909(), this.skillCooldown);
            }
        }
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 user, int slot, boolean selected) {
        if (HelperMethods.commonSpellAttributeScaling(this.spellScalingModifier, user, "soul") > 0.0f) {
            this.abilityDamage = HelperMethods.commonSpellAttributeScaling(this.spellScalingModifier, user, "soul");
            scalesWithSpellPower = true;
        }
        if (!user.method_37908().method_8608() && user instanceof class_1309) {
            class_1309 livingUser = (class_1309)user;
            if (livingUser.field_6012 % 35 == 0 && livingUser.method_6118(class_1304.field_6173) == stack && !livingUser.method_6115()) {
                class_238 box = new class_238(livingUser.method_23317() + (double)this.radius, livingUser.method_23318() + (double)this.radius, livingUser.method_23321() + (double)this.radius, livingUser.method_23317() - (double)this.radius, livingUser.method_23318() - (double)this.radius, livingUser.method_23321() - (double)this.radius);
                for (class_1297 entity : world.method_8333((class_1297)livingUser, box, class_1301.field_6157)) {
                    if (!(entity instanceof class_1309)) continue;
                    class_1309 le = (class_1309)entity;
                    if (!HelperMethods.checkFriendlyFire((class_1309)entity, livingUser)) continue;
                    le.method_5643(livingUser.method_48923().method_48815(user, user), this.abilityDamage);
                }
                world.method_43129(null, (class_1297)livingUser, (class_3414)SoundRegistry.DARK_SWORD_BLOCK.get(), livingUser.method_5634(), 0.1f, 0.2f);
                double xpos = livingUser.method_23317() - (double)(this.radius + 1);
                double ypos = livingUser.method_23318();
                double zpos = livingUser.method_23321() - (double)(this.radius + 1);
                for (int i = this.radius * 2; i > 0; --i) {
                    for (int j = this.radius * 2; j > 0; --j) {
                        float choose = (float)(Math.random() * 1.0);
                        HelperMethods.spawnParticle(world, (class_2394)class_2398.field_38002, xpos + (double)i + (double)choose, ypos, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                        HelperMethods.spawnParticle(world, (class_2394)class_2398.field_23114, xpos + (double)i + (double)choose, ypos + 0.1, zpos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                        HelperMethods.spawnParticle(world, (class_2394)class_2398.field_11219, xpos + (double)i + (double)choose, ypos + 2.0, zpos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(user, stack, world, stepMod, class_2398.field_23114, class_2398.field_23114, class_2398.field_11219, true);
        super.method_7888(stack, world, user, slot, selected);
    }

    @Override
    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        class_2583 RIGHTCLICK = HelperMethods.getStyle("rightclick");
        class_2583 ABILITY = HelperMethods.getStyle("ability");
        class_2583 TEXT = HelperMethods.getStyle("text");
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        if (itemStack.method_31574((class_1792)ItemsRegistry.SLUMBERING_LICHBLADE.get())) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.lichbladesworditem.tooltip1").method_10862(ABILITY));
        } else if (itemStack.method_31574((class_1792)ItemsRegistry.WAKING_LICHBLADE.get())) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.lichbladesworditem.tooltip1.2").method_10862(ABILITY));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.lichbladesworditem.tooltip1.3").method_10862(ABILITY));
        }
        tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.lichbladesworditem.tooltip2").method_10862(TEXT));
        tooltip.add((class_2561)class_2561.method_43469((String)"item.simplyswords.lichbladesworditem.tooltip3", (Object[])new Object[]{this.radius}).method_10862(TEXT));
        if (!itemStack.method_31574((class_1792)ItemsRegistry.SLUMBERING_LICHBLADE.get())) {
            tooltip.add((class_2561)class_2561.method_43470((String)""));
            tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.onrightclickheld").method_10862(RIGHTCLICK));
            tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.lichbladesworditem.tooltip4").method_10862(TEXT));
            tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.lichbladesworditem.tooltip5").method_10862(TEXT));
            tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.lichbladesworditem.tooltip6").method_10862(TEXT));
            if (itemStack.method_31574((class_1792)ItemsRegistry.AWAKENED_LICHBLADE.get())) {
                tooltip.add((class_2561)class_2561.method_43470((String)""));
                tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.lichbladesworditem.tooltip7").method_10862(TEXT));
                tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.lichbladesworditem.tooltip8").method_10862(TEXT));
                tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.lichbladesworditem.tooltip9").method_10862(TEXT));
            }
        }
        if (scalesWithSpellPower) {
            tooltip.add((class_2561)class_2561.method_43470((String)""));
            tooltip.add((class_2561)class_2561.method_43471((String)"item.simplyswords.compat.scaleSoul"));
        }
        super.method_7851(itemStack, world, tooltip, tooltipContext);
    }
}

